/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class RefactoringSearchEngine {
    private RefactoringSearchEngine() {
    }

    public static ICompilationUnit[] findAffectedCompilationUnits(SearchPattern pattern, IJavaSearchScope scope, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        final boolean[] hasPotentialMatches = new boolean[]{false};
        boolean hasNonCuMatches = false;
        final HashSet resources = new HashSet(5);
        SearchRequestor requestor = new SearchRequestor(){
            private IResource fLastResource;

            public void acceptSearchMatch(SearchMatch match) {
                if (match.getAccuracy() == 1) {
                    hasPotentialMatches[0] = true;
                }
                if (this.fLastResource != match.getResource()) {
                    this.fLastResource = match.getResource();
                    resources.add(this.fLastResource);
                }
            }
        };
        try {
            new SearchEngine().search(pattern, SearchUtils.getDefaultSearchParticipants(), scope, requestor, pm);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>(resources.size());
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            IJavaElement element = JavaCore.create((IResource)resource);
            if (element instanceof ICompilationUnit) {
                result.add(element);
                continue;
            }
            hasNonCuMatches = true;
        }
        RefactoringSearchEngine.addStatusErrors(status, hasPotentialMatches[0], hasNonCuMatches);
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    public static SearchResultGroup[] search(SearchPattern pattern, IJavaSearchScope scope, IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        return RefactoringSearchEngine.internalSearch(new SearchEngine(), pattern, scope, new CollectingSearchRequestor(), monitor, status);
    }

    public static SearchResultGroup[] search(SearchPattern pattern, IJavaSearchScope scope, CollectingSearchRequestor requestor, IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        return RefactoringSearchEngine.internalSearch(new SearchEngine(), pattern, scope, requestor, monitor, status);
    }

    public static SearchResultGroup[] search(SearchPattern pattern, IJavaSearchScope scope, CollectingSearchRequestor requestor, IProgressMonitor monitor, WorkingCopyOwner owner, RefactoringStatus status) throws JavaModelException {
        return RefactoringSearchEngine.internalSearch(new SearchEngine(owner), pattern, scope, requestor, monitor, status);
    }

    public static SearchResultGroup[] search(SearchPattern pattern, IJavaSearchScope scope, IProgressMonitor monitor, ICompilationUnit[] workingCopies, RefactoringStatus status) throws JavaModelException {
        return RefactoringSearchEngine.internalSearch(new SearchEngine(workingCopies), pattern, scope, new CollectingSearchRequestor(), monitor, status);
    }

    private static SearchResultGroup[] internalSearch(SearchEngine searchEngine, SearchPattern pattern, IJavaSearchScope scope, CollectingSearchRequestor requestor, IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        try {
            searchEngine.search(pattern, SearchUtils.getDefaultSearchParticipants(), scope, (SearchRequestor)requestor, monitor);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        return RefactoringSearchEngine.groupByCu(requestor.getResults(), status);
    }

    public static SearchResultGroup[] groupByCu(SearchMatch[] matches, RefactoringStatus status) {
        return RefactoringSearchEngine.groupByCu(Arrays.asList(matches), status);
    }

    public static SearchResultGroup[] groupByCu(List matchList, RefactoringStatus status) {
        HashMap grouped = new HashMap();
        boolean hasPotentialMatches = false;
        boolean hasNonCuMatches = false;
        Iterator<Object> iter = matchList.iterator();
        while (iter.hasNext()) {
            SearchMatch searchMatch = (SearchMatch)iter.next();
            if (searchMatch.getAccuracy() == 1) {
                hasPotentialMatches = true;
            }
            if (!grouped.containsKey(searchMatch.getResource())) {
                grouped.put(searchMatch.getResource(), new ArrayList(1));
            }
            ((List)grouped.get(searchMatch.getResource())).add(searchMatch);
        }
        iter = grouped.keySet().iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            IJavaElement element = JavaCore.create((IResource)resource);
            if (element instanceof ICompilationUnit) continue;
            iter.remove();
            hasNonCuMatches = true;
        }
        SearchResultGroup[] result = new SearchResultGroup[grouped.keySet().size()];
        int i = 0;
        Iterator iter2 = grouped.keySet().iterator();
        while (iter2.hasNext()) {
            IResource resource = (IResource)iter2.next();
            List searchMatches = (List)grouped.get(resource);
            SearchMatch[] matchArray = searchMatches.toArray(new SearchMatch[searchMatches.size()]);
            result[i] = new SearchResultGroup(resource, matchArray);
            ++i;
        }
        RefactoringSearchEngine.addStatusErrors(status, hasPotentialMatches, hasNonCuMatches);
        return result;
    }

    public static SearchPattern createOrPattern(IJavaElement[] elements, int limitTo) {
        if (elements == null || elements.length == 0) {
            return null;
        }
        HashSet<IJavaElement> set = new HashSet<IJavaElement>(Arrays.asList(elements));
        Iterator iter = set.iterator();
        IJavaElement first = (IJavaElement)iter.next();
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)first, (int)limitTo);
        while (iter.hasNext()) {
            IJavaElement each = (IJavaElement)iter.next();
            pattern = SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)SearchPattern.createPattern((IJavaElement)each, (int)limitTo));
        }
        return pattern;
    }

    private static void addStatusErrors(RefactoringStatus status, boolean hasPotentialMatches, boolean hasNonCuMatches) {
        if (hasPotentialMatches) {
            status.addError(RefactoringCoreMessages.getString("RefactoringSearchEngine.potential_matches"));
        }
        if (hasNonCuMatches) {
            status.addError(RefactoringCoreMessages.getString("RefactoringSearchEngine.non_cu_matches"));
        }
    }
}

