/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScanner;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

class TextMatchUpdater {
    private static final String TEXT_EDIT_LABEL = RefactoringCoreMessages.getString("TextMatchUpdater.update");
    private IJavaSearchScope fScope;
    private TextChangeManager fManager;
    private SearchResultGroup[] fReferences;
    private RefactoringScanner fScanner;
    private String fNewName;
    private int fCurrentNameLength;

    private TextMatchUpdater(TextChangeManager manager, IJavaSearchScope scope, ITextUpdating processor, SearchResultGroup[] references) {
        Assert.isNotNull(manager);
        Assert.isNotNull(scope);
        Assert.isNotNull(references);
        this.fManager = manager;
        this.fScope = scope;
        this.fReferences = references;
        this.fNewName = processor.getNewElementName();
        this.fCurrentNameLength = processor.getCurrentElementName().length();
        this.fScanner = new RefactoringScanner(processor.getCurrentElementName());
    }

    static void perform(IProgressMonitor pm, IJavaSearchScope scope, ITextUpdating processor, TextChangeManager manager, SearchResultGroup[] references) throws JavaModelException {
        new TextMatchUpdater(manager, scope, processor, references).updateTextMatches(pm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTextMatches(IProgressMonitor pm) throws JavaModelException {
        try {
            IProject[] projectsInScope = this.getProjectsInScope();
            pm.beginTask("", projectsInScope.length);
            for (int i = 0; i < projectsInScope.length; ++i) {
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.addTextMatches((IResource)projectsInScope[i], (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
        }
        finally {
            pm.done();
        }
    }

    private IProject[] getProjectsInScope() {
        IPath[] enclosingProjects = this.fScope.enclosingProjectsAndJars();
        HashSet<IPath> enclosingProjectSet = new HashSet<IPath>();
        enclosingProjectSet.addAll(Arrays.asList(enclosingProjects));
        ArrayList<IProject> projectsInScope = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!enclosingProjectSet.contains(projects[i].getFullPath())) continue;
            projectsInScope.add(projects[i]);
        }
        return projectsInScope.toArray(new IProject[projectsInScope.size()]);
    }

    private void addTextMatches(IResource resource, IProgressMonitor pm) throws JavaModelException {
        try {
            String task = RefactoringCoreMessages.getString("TextMatchUpdater.searching") + resource.getFullPath();
            if (resource instanceof IFile) {
                IJavaElement element = JavaCore.create((IResource)resource);
                if (!(element instanceof ICompilationUnit)) {
                    return;
                }
                if (!element.exists()) {
                    return;
                }
                if (!this.fScope.encloses(element)) {
                    return;
                }
                this.addCuTextMatches((ICompilationUnit)element);
            } else if (resource instanceof IContainer) {
                IResource[] members = ((IContainer)resource).members();
                pm.beginTask(task, members.length);
                pm.subTask(task);
                for (int i = 0; i < members.length; ++i) {
                    if (pm.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    this.addTextMatches(members[i], (IProgressMonitor)new SubProgressMonitor(pm, 1));
                }
            }
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        finally {
            pm.done();
        }
    }

    private void addCuTextMatches(ICompilationUnit cu) throws JavaModelException {
        this.fScanner.scan(cu);
        Set matches = this.fScanner.getMatches();
        if (matches.size() == 0) {
            return;
        }
        this.removeReferences(cu, matches);
        if (matches.size() != 0) {
            this.addTextUpdates(cu, matches);
        }
    }

    private void removeReferences(ICompilationUnit cu, Set matches) {
        for (int i = 0; i < this.fReferences.length; ++i) {
            SearchResultGroup group = this.fReferences[i];
            if (!cu.equals(group.getCompilationUnit())) continue;
            this.removeReferences(matches, group);
        }
    }

    private void removeReferences(Set matches, SearchResultGroup group) {
        SearchMatch[] searchResults = group.getSearchResults();
        for (int r = 0; r < searchResults.length; ++r) {
            int unqualifiedStart = searchResults[r].getOffset() + searchResults[r].getLength() - this.fCurrentNameLength;
            matches.remove(new Integer(unqualifiedStart));
        }
    }

    private void addTextUpdates(ICompilationUnit cu, Set matches) {
        Iterator resultIter = matches.iterator();
        while (resultIter.hasNext()) {
            int matchStart = (Integer)resultIter.next();
            ReplaceEdit edit = new ReplaceEdit(matchStart, this.fCurrentNameLength, this.fNewName);
            TextChangeCompatibility.addTextEdit(this.fManager.get(cu), TEXT_EDIT_LABEL, (TextEdit)edit);
        }
    }
}

