/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class JavaSearchScopeFactory {
    private static JavaSearchScopeFactory fgInstance;
    private static final IJavaSearchScope EMPTY_SCOPE;
    private static final Set EMPTY_SET;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaProject;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    private JavaSearchScopeFactory() {
    }

    public static JavaSearchScopeFactory getInstance() {
        if (fgInstance == null) {
            fgInstance = new JavaSearchScopeFactory();
        }
        return fgInstance;
    }

    public IWorkingSet[] queryWorkingSets() throws JavaModelException {
        IWorkingSet[] workingSets;
        Shell shell = JavaPlugin.getActiveWorkbenchShell();
        if (shell == null) {
            return null;
        }
        IWorkingSetSelectionDialog dialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(shell, true);
        if (dialog.open() == 0 && (workingSets = dialog.getSelection()).length > 0) {
            return workingSets;
        }
        return null;
    }

    public IJavaSearchScope createJavaSearchScope(IWorkingSet[] workingSets, boolean includeJRE) {
        if (workingSets == null || workingSets.length < 1) {
            return EMPTY_SCOPE;
        }
        HashSet javaElements = new HashSet(workingSets.length * 10);
        for (int i = 0; i < workingSets.length; ++i) {
            this.addJavaElements(javaElements, workingSets[i]);
        }
        return this.createJavaSearchScope(javaElements, includeJRE);
    }

    public IJavaSearchScope createJavaSearchScope(IWorkingSet workingSet, boolean includeJRE) {
        HashSet javaElements = new HashSet(10);
        this.addJavaElements(javaElements, workingSet);
        return this.createJavaSearchScope(javaElements, includeJRE);
    }

    public IJavaSearchScope createJavaSearchScope(IResource[] resources, boolean includeJRE) {
        if (resources == null) {
            return EMPTY_SCOPE;
        }
        HashSet javaElements = new HashSet(resources.length);
        this.addJavaElements(javaElements, resources);
        return this.createJavaSearchScope(javaElements, includeJRE);
    }

    public IJavaSearchScope createJavaSearchScope(ISelection selection, boolean includeJRE) {
        return this.createJavaSearchScope(this.getJavaElements(selection), includeJRE);
    }

    private IJavaSearchScope internalCreateProjectScope(ISelection selection, boolean includeJRE) {
        Set javaProjects = this.getJavaProjects(selection);
        return this.createJavaSearchScope(javaProjects, includeJRE);
    }

    public IJavaSearchScope createJavaProjectSearchScope(IJavaElement selection, boolean includeJRE) {
        return this.createJavaProjectSearchScope((ISelection)new StructuredSelection((Object)selection), includeJRE);
    }

    public IJavaSearchScope createJavaProjectSearchScope(ISelection selection, boolean includeJRE) {
        IEditorInput input = this.getActiveEditorInput();
        if (input != null) {
            return JavaSearchScopeFactory.getInstance().internalCreateProjectScope(input, includeJRE);
        }
        return this.internalCreateProjectScope(selection, includeJRE);
    }

    public String getProjectScopeDescription(IJavaElement element) {
        IJavaProject project2;
        IAdaptable inputElement;
        IJavaProject project = element.getJavaProject();
        IEditorInput input = this.getActiveEditorInput();
        if (input != null && (inputElement = this.getEditorInputElement(input)) != null && (project2 = this.getJavaProject(inputElement)) != null) {
            project = project2;
        }
        if (project != null) {
            return SearchMessages.getFormattedString("ProjectScope", project.getElementName());
        }
        return SearchMessages.getFormattedString("ProjectScope", "");
    }

    private IEditorInput getActiveEditorInput() {
        IEditorPart editor;
        IWorkbenchPage page = JavaPlugin.getActivePage();
        if (page != null && (editor = page.getActiveEditor()) != null && editor.equals(page.getActivePart())) {
            return editor.getEditorInput();
        }
        return null;
    }

    private IJavaSearchScope internalCreateProjectScope(IEditorInput editorInput, boolean includeJRE) {
        IAdaptable inputElement = this.getEditorInputElement(editorInput);
        StructuredSelection selection = inputElement != null ? new StructuredSelection((Object)inputElement) : StructuredSelection.EMPTY;
        return this.internalCreateProjectScope((ISelection)selection, includeJRE);
    }

    private IAdaptable getEditorInputElement(IEditorInput editorInput) {
        IClassFile inputElement = null;
        if (editorInput instanceof IClassFileEditorInput) {
            inputElement = ((IClassFileEditorInput)editorInput).getClassFile();
        } else if (editorInput instanceof IFileEditorInput) {
            inputElement = ((IFileEditorInput)editorInput).getFile();
        }
        return inputElement;
    }

    private Set getJavaProjects(ISelection selection) {
        HashSet<IJavaProject> javaProjects;
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            javaProjects = new HashSet<IJavaProject>(((IStructuredSelection)selection).size());
            while (iter.hasNext()) {
                IJavaProject javaProject;
                Object selectedElement = iter.next();
                if (selectedElement instanceof ISearchResultViewEntry) {
                    selectedElement = ((ISearchResultViewEntry)selectedElement).getGroupByKey();
                }
                if (selectedElement instanceof LogicalPackage) {
                    javaProjects.add(((LogicalPackage)((Object)selectedElement)).getJavaProject());
                    continue;
                }
                if (!(selectedElement instanceof IAdaptable) || (javaProject = this.getJavaProject((IAdaptable)selectedElement)) == null) continue;
                javaProjects.add(javaProject);
            }
        } else {
            javaProjects = EMPTY_SET;
        }
        return javaProjects;
    }

    private IJavaProject getJavaProject(IAdaptable selectedElement) {
        IJavaProject javaProject = (IJavaProject)selectedElement.getAdapter(class$org$eclipse$jdt$core$IJavaProject == null ? (class$org$eclipse$jdt$core$IJavaProject = JavaSearchScopeFactory.class$("org.eclipse.jdt.core.IJavaProject")) : class$org$eclipse$jdt$core$IJavaProject);
        if (javaProject != null) {
            return javaProject;
        }
        IJavaElement javaElement = (IJavaElement)selectedElement.getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = JavaSearchScopeFactory.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement);
        if (javaElement != null && (javaProject = javaElement.getJavaProject()) != null) {
            return javaProject;
        }
        IResource resource = (IResource)selectedElement.getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = JavaSearchScopeFactory.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        if (resource != null) {
            IProject project = resource.getProject();
            try {
                if (project != null && project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                    return JavaCore.create((IProject)project);
                }
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
        return null;
    }

    public IProject[] getProjects(IJavaSearchScope scope) {
        IPath[] paths = scope.enclosingProjectsAndJars();
        HashSet<IResource> temp = new HashSet<IResource>();
        for (int i = 0; i < paths.length; ++i) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(paths[i]);
            if (resource == null || resource.getType() != 4) continue;
            temp.add(resource);
        }
        return temp.toArray(new IProject[temp.size()]);
    }

    private Set getJavaElements(ISelection selection) {
        HashSet javaElements;
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            javaElements = new HashSet(((IStructuredSelection)selection).size());
            while (iter.hasNext()) {
                IResource resource;
                Object selectedElement = iter.next();
                if (selectedElement instanceof ISearchResultViewEntry) {
                    selectedElement = ((ISearchResultViewEntry)selectedElement).getGroupByKey();
                }
                if (selectedElement instanceof IJavaElement) {
                    this.addJavaElements(javaElements, (IJavaElement)selectedElement);
                    continue;
                }
                if (selectedElement instanceof IResource) {
                    this.addJavaElements(javaElements, (IResource)selectedElement);
                    continue;
                }
                if (selectedElement instanceof LogicalPackage) {
                    this.addJavaElements(javaElements, (LogicalPackage)((Object)selectedElement));
                    continue;
                }
                if (!(selectedElement instanceof IAdaptable) || (resource = (IResource)((IAdaptable)selectedElement).getAdapter(class$org$eclipse$core$resources$IResource == null ? JavaSearchScopeFactory.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource)) == null) continue;
                this.addJavaElements(javaElements, resource);
            }
        } else {
            javaElements = EMPTY_SET;
        }
        return javaElements;
    }

    private IJavaSearchScope createJavaSearchScope(Set javaElements, boolean includeJRE) {
        if (javaElements.isEmpty()) {
            return EMPTY_SCOPE;
        }
        IJavaElement[] elementArray = javaElements.toArray(new IJavaElement[javaElements.size()]);
        return SearchEngine.createJavaSearchScope((IJavaElement[])elementArray, (int)JavaSearchScopeFactory.getSearchFlags(includeJRE));
    }

    static int getSearchFlags(boolean includeJRE) {
        int flags = 3;
        if (includeJRE) {
            flags |= 4;
        }
        return flags;
    }

    private void addJavaElements(Set javaElements, IResource[] resources) {
        for (int i = 0; i < resources.length; ++i) {
            this.addJavaElements(javaElements, resources[i]);
        }
    }

    private void addJavaElements(Set javaElements, IResource resource) {
        IJavaElement javaElement = (IJavaElement)resource.getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = JavaSearchScopeFactory.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement);
        if (javaElement == null) {
            return;
        }
        if (javaElement.getElementType() == 4) {
            try {
                this.addJavaElements(javaElements, ((IFolder)resource).members());
            }
            catch (CoreException ex) {
                // empty catch block
            }
        }
        javaElements.add(javaElement);
    }

    private void addJavaElements(Set javaElements, IJavaElement javaElement) {
        javaElements.add(javaElement);
    }

    private void addJavaElements(Set javaElements, IWorkingSet workingSet) {
        if (workingSet == null) {
            return;
        }
        IAdaptable[] elements = workingSet.getElements();
        for (int i = 0; i < elements.length; ++i) {
            IJavaElement javaElement = (IJavaElement)elements[i].getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? JavaSearchScopeFactory.class$("org.eclipse.jdt.core.IJavaElement") : class$org$eclipse$jdt$core$IJavaElement);
            if (javaElement != null) {
                this.addJavaElements(javaElements, javaElement);
                continue;
            }
            IResource resource = (IResource)elements[i].getAdapter(class$org$eclipse$core$resources$IResource == null ? JavaSearchScopeFactory.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource);
            if (resource == null) continue;
            this.addJavaElements(javaElements, resource);
        }
    }

    public void addJavaElements(Set javaElements, LogicalPackage selectedElement) {
        IPackageFragment[] packages = selectedElement.getFragments();
        for (int i = 0; i < packages.length; ++i) {
            this.addJavaElements(javaElements, (IJavaElement)packages[i]);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        EMPTY_SCOPE = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[0]);
        EMPTY_SET = new HashSet(0);
    }
}

