/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;

public class RTFTransfer
extends ByteArrayTransfer {
    private static RTFTransfer _instance = new RTFTransfer();
    private static final String TEXT_RTF = "text/rtf";
    private static final int TEXT_RTF_ID = RTFTransfer.registerType("text/rtf");
    private static final String TEXT_RTF2 = "TEXT/RTF";
    private static final int TEXT_RTF2_ID = RTFTransfer.registerType("TEXT/RTF");
    private static final String APPLICATION_RTF = "application/rtf";
    private static final int APPLICATION_RTF_ID = RTFTransfer.registerType("application/rtf");

    private RTFTransfer() {
    }

    public static RTFTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        transferData.result = 0;
        if (object == null || !(object instanceof String) || !this.isSupportedType(transferData)) {
            return;
        }
        String string = (String)object;
        if (string.length() == 0) {
            return;
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int pValue = OS.XtMalloc(buffer.length);
        if (pValue == 0) {
            return;
        }
        OS.memmove(pValue, buffer, buffer.length);
        transferData.length = buffer.length;
        transferData.format = 8;
        transferData.pValue = pValue;
        transferData.result = 1;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        int size = transferData.format * transferData.length / 8;
        if (size == 0) {
            return null;
        }
        byte[] buffer = new byte[size];
        OS.memmove(buffer, transferData.pValue, size);
        char[] chars = Converter.mbcsToWcs(null, buffer);
        String string = new String(chars);
        int end = string.indexOf(0);
        return end == -1 ? string : string.substring(0, end);
    }

    protected int[] getTypeIds() {
        return new int[]{TEXT_RTF_ID, TEXT_RTF2_ID, APPLICATION_RTF_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{TEXT_RTF, TEXT_RTF2, APPLICATION_RTF};
    }
}

