/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Canvas
extends Composite {
    Caret caret;

    Canvas() {
    }

    public Canvas(Composite parent, int style) {
        super(parent, style);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    Caret getIMCaret() {
        return this.caret;
    }

    void redrawWidget(int x, int y, int width, int height, boolean all) {
        boolean isFocus;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        super.redrawWidget(x, y, width, height, all);
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    void releaseWidget() {
        if (this.caret != null) {
            this.caret.releaseResources();
        }
        this.caret = null;
        super.releaseWidget();
    }

    public void scroll(int destX, int destY, int x, int y, int width, int height, boolean all) {
        boolean disjoint;
        int xDisplay;
        boolean isFocus;
        this.checkWidget();
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - x;
        int deltaY = destY - y;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        if ((xDisplay = OS.XtDisplay(this.handle)) == 0) {
            return;
        }
        int xWindow = OS.XtWindow(this.handle);
        if (xWindow == 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNwidth, 0, OS.XmNheight, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (Math.min(x + width, argList[1]) >= Math.max(x, 0) && Math.min(y + height, 0 + argList[3]) >= Math.max(y, 0)) {
            int xEvent = OS.XtMalloc(96);
            OS.XSync(xDisplay, false);
            OS.XSync(xDisplay, false);
            while (OS.XCheckWindowEvent(xDisplay, xWindow, 32768, xEvent)) {
                OS.XtDispatchEvent(xEvent);
            }
            OS.XtFree(xEvent);
        }
        int xGC = OS.XCreateGC(xDisplay, xWindow, 0, null);
        OS.XCopyArea(xDisplay, xWindow, xWindow, xGC, x, y, width, height, destX, destY);
        OS.XFreeGC(xDisplay, xGC);
        boolean bl2 = disjoint = destX + width < x || x + width < destX || destY + height < y || y + height < destY;
        if (disjoint) {
            OS.XClearArea(xDisplay, xWindow, x, y, width, height, true);
        } else {
            if (deltaX != 0) {
                int newX = destX - deltaX;
                if (deltaX < 0) {
                    newX = destX + width;
                }
                OS.XClearArea(xDisplay, xWindow, newX, y, Math.abs(deltaX), height, true);
            }
            if (deltaY != 0) {
                int newY = destY - deltaY;
                if (deltaY < 0) {
                    newY = destY + height;
                }
                OS.XClearArea(xDisplay, xWindow, x, newY, width, Math.abs(deltaY), true);
            }
        }
        if (all) {
            Control[] children = this._getChildren();
            for (int i = 0; i < children.length; ++i) {
                Control child = children[i];
                Rectangle rect = child.getBounds();
                if (Math.min(x + width, rect.x + rect.width) < Math.max(x, rect.x) || Math.min(y + height, rect.y + rect.height) < Math.max(y, rect.y)) continue;
                child.setLocation(rect.x + deltaX, rect.y + deltaY);
            }
        }
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret newCaret = caret;
        Caret oldCaret = this.caret;
        this.caret = newCaret;
        if (this.hasFocus()) {
            if (oldCaret != null) {
                oldCaret.killFocus();
            }
            if (newCaret != null) {
                if (newCaret.isDisposed()) {
                    this.error(5);
                }
                newCaret.setFocus();
            }
        }
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean isFocus;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        boolean changed = super.setBounds(x, y, width, height, move, resize);
        if (isFocus) {
            this.caret.setFocus();
        }
        return changed;
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    int XExposure(int w, int client_data, int call_data, int continue_to_dispatch) {
        boolean isFocus;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        int result = super.XExposure(w, client_data, call_data, continue_to_dispatch);
        if (isFocus) {
            this.caret.setFocus();
        }
        return result;
    }

    int xFocusIn(XFocusChangeEvent xEvent) {
        int result = super.xFocusIn(xEvent);
        if (this.caret != null) {
            this.caret.setFocus();
        }
        return result;
    }

    int xFocusOut(XFocusChangeEvent xEvent) {
        int result = super.xFocusOut(xEvent);
        if (this.caret != null) {
            this.caret.killFocus();
        }
        return result;
    }
}

