/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.instructions;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.eval.ast.engine.IRuntimeContext;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionsEvaluationMessages;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.SimpleInstruction;

public class PushLocalVariable
extends SimpleInstruction {
    private String fName;

    public PushLocalVariable(String name) {
        this.fName = name;
    }

    public void execute() throws CoreException {
        IVariable internalVariable = this.getInternalVariable(this.fName);
        if (internalVariable != null) {
            this.push(internalVariable);
            return;
        }
        IRuntimeContext context = this.getContext();
        IJavaVariable[] locals = context.getLocals();
        for (int i = 0; i < locals.length; ++i) {
            if (!locals[i].getName().equals(this.getName())) continue;
            this.push(locals[i]);
            return;
        }
        throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, MessageFormat.format(InstructionsEvaluationMessages.getString("PushLocalVariable.Cannot_find_the_variable____1"), this.fName), null));
    }

    protected String getName() {
        return this.fName;
    }

    public String toString() {
        return MessageFormat.format(InstructionsEvaluationMessages.getString("PushLocalVariable.push___{0}__2"), this.getName());
    }
}

