/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.resources.CharsetDeltaJob;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class CharsetManager
implements IManager {
    protected final Bundle systemBundle = Platform.getBundle((String)"org.eclipse.osgi");
    public static final String ENCODING_PREF_NODE = "encoding";
    private static final String PROJECT_KEY = "<project>";
    CharsetManagerJob job;
    private IResourceChangeListener listener;
    private CharsetDeltaJob charsetListener;
    Workspace workspace;

    public CharsetManager(Workspace workspace) {
        this.workspace = workspace;
    }

    public String getCharsetFor(IPath resourcePath) {
        return this.getCharsetFor(resourcePath, false);
    }

    public String getCharsetFor(IPath resourcePath, boolean recurse) {
        Assert.isLegal(resourcePath.segmentCount() >= 1);
        IProject project = this.workspace.getRoot().getProject(resourcePath.segment(0));
        org.osgi.service.prefs.Preferences encodingSettings = this.getPreferences(project);
        return this.internalGetCharsetFor(resourcePath, encodingSettings, recurse);
    }

    private String internalGetCharsetFor(IPath resourcePath, org.osgi.service.prefs.Preferences encodingSettings, boolean recurse) {
        String charset = encodingSettings.get(this.getKeyFor(resourcePath), null);
        if (!recurse) {
            return charset;
        }
        while (charset == null && resourcePath.segmentCount() > 1) {
            resourcePath = resourcePath.removeLastSegments(1);
            charset = encodingSettings.get(this.getKeyFor(resourcePath), null);
        }
        return charset == null ? ResourcesPlugin.getEncoding() : charset;
    }

    String getKeyFor(IPath resourcePath) {
        return resourcePath.segmentCount() > 1 ? resourcePath.removeFirstSegments(1).toString() : PROJECT_KEY;
    }

    org.osgi.service.prefs.Preferences getPreferences(IProject project) {
        return new ProjectScope(project).getNode("org.eclipse.core.resources").node(ENCODING_PREF_NODE);
    }

    public void setCharsetFor(IPath resourcePath, String newCharset) throws CoreException {
        if (resourcePath.segmentCount() == 0) {
            Preferences resourcesPreferences = ResourcesPlugin.getPlugin().getPluginPreferences();
            if (newCharset != null) {
                resourcesPreferences.setValue(ENCODING_PREF_NODE, newCharset);
            } else {
                resourcesPreferences.setToDefault(ENCODING_PREF_NODE);
            }
            ResourcesPlugin.getPlugin().savePluginPreferences();
            return;
        }
        IProject project = this.workspace.getRoot().getProject(resourcePath.segment(0));
        org.osgi.service.prefs.Preferences encodingSettings = this.getPreferences(project);
        if (newCharset == null || newCharset.trim().length() == 0) {
            encodingSettings.remove(this.getKeyFor(resourcePath));
        } else {
            encodingSettings.put(this.getKeyFor(resourcePath), newCharset);
        }
        try {
            this.charsetListener.setDisabled(true);
            encodingSettings.flush();
        }
        catch (BackingStoreException e) {
            String message = Policy.bind("resources.savingEncoding");
            throw new ResourceException(382, project.getFullPath(), message, e);
        }
        finally {
            this.charsetListener.setDisabled(false);
        }
    }

    public void shutdown(IProgressMonitor monitor) {
        this.workspace.removeResourceChangeListener(this.listener);
        if (this.charsetListener != null) {
            this.charsetListener.shutdown();
        }
    }

    public void startup(IProgressMonitor monitor) throws CoreException {
        this.job = new CharsetManagerJob();
        this.listener = new Listener();
        this.workspace.addResourceChangeListener(this.listener, 1);
        this.charsetListener = new CharsetDeltaJob(this.workspace);
        this.charsetListener.startup();
    }

    public void charsetPreferencesChanged(IProject project) {
        this.charsetListener.charsetPreferencesChanged(project);
    }

    class Listener
    implements IResourceChangeListener {
        Listener() {
        }

        private void processEntryChanges(IResourceDelta projectDelta, Set projectsToSave) {
            String[] affectedResources;
            boolean resourceChanges = false;
            IProject currentProject = (IProject)projectDelta.getResource();
            org.osgi.service.prefs.Preferences projectPrefs = CharsetManager.this.getPreferences(currentProject);
            try {
                affectedResources = projectPrefs.keys();
            }
            catch (BackingStoreException e) {
                String message = Policy.bind("resources.readingEncoding");
                ResourcesPlugin.getPlugin().getLog().log((IStatus)new ResourceStatus(383, currentProject.getFullPath(), message, e));
                return;
            }
            for (int i = 0; i < affectedResources.length; ++i) {
                IResourceDelta memberDelta = projectDelta.findMember((IPath)new Path(affectedResources[i]));
                if (memberDelta == null || memberDelta.getKind() != 2) continue;
                resourceChanges = true;
                String currentValue = projectPrefs.get(affectedResources[i], null);
                projectPrefs.remove(affectedResources[i]);
                if ((memberDelta.getFlags() & 0x2000) == 0) continue;
                IProject targetProject = CharsetManager.this.workspace.getRoot().getProject(memberDelta.getMovedToPath().segment(0));
                org.osgi.service.prefs.Preferences targetPrefs = CharsetManager.this.getPreferences(targetProject);
                targetPrefs.put(CharsetManager.this.getKeyFor(memberDelta.getMovedToPath()), currentValue);
                if (targetProject == currentProject) continue;
                projectsToSave.add(targetProject);
            }
            if (resourceChanges) {
                projectsToSave.add(currentProject);
            }
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            IResourceDelta[] projectDeltas = delta.getAffectedChildren();
            HashSet projectsToSave = new HashSet();
            for (int i = 0; i < projectDeltas.length; ++i) {
                if (projectDeltas[i].getKind() != 4 || (projectDeltas[i].getFlags() & 0x4000) != 0) continue;
                this.processEntryChanges(projectDeltas[i], projectsToSave);
            }
            CharsetManager.this.job.addChanges(projectsToSave);
        }
    }

    private class CharsetManagerJob
    extends Job {
        private List asyncChanges = new ArrayList();

        public CharsetManagerJob() {
            super(Policy.bind("resources.charsetUpdating"));
            this.setSystem(true);
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChanges(Set newChanges) {
            if (newChanges.isEmpty()) {
                return;
            }
            List list = this.asyncChanges;
            synchronized (list) {
                this.asyncChanges.addAll(newChanges);
                this.asyncChanges.notify();
            }
            this.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IProject getNextChange() {
            List list = this.asyncChanges;
            synchronized (list) {
                return this.asyncChanges.isEmpty() ? null : (IProject)this.asyncChanges.remove(this.asyncChanges.size() - 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            result = new MultiStatus("org.eclipse.core.resources", 382, Policy.bind("resources.updatingEncoding"), null);
            monitor = Policy.monitorFor(monitor);
            try {
                block15: {
                    monitor.beginTask(Policy.bind("resources.charsetUpdating"), Policy.totalWork);
                    rule = CharsetManager.this.workspace.getRuleFactory().modifyRule(CharsetManager.this.workspace.getRoot());
                    try {
                        CharsetManager.this.workspace.prepareOperation(rule, monitor);
                        CharsetManager.this.workspace.beginOperation(true);
lbl9:
                        // 4 sources

                        while ((next = this.getNextChange()) != null) {
                            if (CharsetManager.this.systemBundle.getState() != 32) {
                                var5_8 = Status.OK_STATUS;
                                var8_10 = null;
                                break block15;
                            }
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl37
                    }
                    catch (OperationCanceledException e) {
                        CharsetManager.this.workspace.getWorkManager().operationCanceled();
                        throw e;
                    }
                    catch (Throwable var7_13) {
                        var8_12 = null;
                        CharsetManager.this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
                        throw var7_13;
                    }
                }
                CharsetManager.this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
                monitor.done();
                return var5_8;
lbl-1000:
                // 1 sources

                {
                    try {
                        if (!next.isAccessible()) ** GOTO lbl9
                        CharsetManager.this.getPreferences(next).flush();
                    }
                    catch (BackingStoreException e) {
                        detailMessage = Policy.bind("resources.savingEncoding");
                        result.add((IStatus)new ResourceStatus(382, next.getFullPath(), detailMessage, e));
                    }
                    ** GOTO lbl9
lbl37:
                    // 1 sources

                    monitor.worked(Policy.opWork);
                }
                var8_11 = null;
                CharsetManager.this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
                return result;
            }
            catch (CoreException ce) {
                var4_5 = ce.getStatus();
                return var4_5;
            }
            finally {
                monitor.done();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldRun() {
            List list = this.asyncChanges;
            synchronized (list) {
                return !this.asyncChanges.isEmpty();
            }
        }
    }
}

