/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.actions.ITeamRunnableContext;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ProgressDialogRunnableContext
implements ITeamRunnableContext {
    private Shell shell;
    private IRunnableContext runnableContext;
    private ISchedulingRule schedulingRule;
    private boolean postponeBuild;

    public ProgressDialogRunnableContext(Shell shell) {
        this.shell = shell;
    }

    public boolean isPostponeBuild() {
        return this.postponeBuild;
    }

    public void setPostponeBuild(boolean postponeBuild) {
        this.postponeBuild = postponeBuild;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.schedulingRule;
    }

    public void setSchedulingRule(ISchedulingRule schedulingRule) {
        this.schedulingRule = schedulingRule;
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setRunnableContext(IRunnableContext runnableContext) {
        this.runnableContext = runnableContext;
    }

    public void run(IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.getRunnableContext().run(true, true, this.wrapRunnable(runnable));
    }

    private IRunnableContext getRunnableContext() {
        if (this.runnableContext == null) {
            return new IRunnableContext(){

                public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
                    IProgressService manager = PlatformUI.getWorkbench().getProgressService();
                    manager.busyCursorWhile(runnable);
                }
            };
        }
        return this.runnableContext;
    }

    private IRunnableWithProgress wrapRunnable(final IRunnableWithProgress runnable) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    if (ProgressDialogRunnableContext.this.schedulingRule == null && !ProgressDialogRunnableContext.this.postponeBuild) {
                        runnable.run(monitor);
                    } else {
                        Exception[] exception = new Exception[]{null};
                        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(this, exception){
                            private final /* synthetic */ Exception[] val$exception;
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$exception = val$exception;
                            }

                            public void run(IProgressMonitor pm) throws CoreException {
                                try {
                                    2.access$200(this.this$1).run(pm);
                                }
                                catch (InvocationTargetException e) {
                                    this.val$exception[0] = e;
                                }
                                catch (InterruptedException e) {
                                    this.val$exception[0] = e;
                                }
                            }
                        }, ProgressDialogRunnableContext.this.schedulingRule, 0, monitor);
                        if (exception[0] != null) {
                            if (exception[0] instanceof InvocationTargetException) {
                                throw (InvocationTargetException)exception[0];
                            }
                            if (exception[0] instanceof InterruptedException) {
                                throw (InterruptedException)exception[0];
                            }
                        }
                    }
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }

            static /* synthetic */ IRunnableWithProgress access$200(2 x0) {
                return x0.runnable;
            }
        };
    }
}

