/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.Feature;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentProvider;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.search.UpdatesSearchCategory;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.search.EnvironmentFilter;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;

public class UpdateUtils {
    public static final String P_UPDATE_POLICY_URL = "updatePolicyURL";

    private UpdateUtils() {
    }

    public static String getPluginId() {
        return UpdateCore.getPlugin().getBundle().getSymbolicName();
    }

    public static void logException(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, UpdateUtils.getPluginId(), 0, message, e);
        }
        UpdateUtils.log(status);
    }

    public static void log(IStatus status) {
        if (status.getSeverity() != 1) {
            UpdateCore.getPlugin().getLog().log(status);
        }
    }

    public static IFeature[] searchSite(String featureId, IConfiguredSite site, boolean onlyConfigured) throws CoreException {
        IFeatureReference[] references = null;
        references = onlyConfigured ? site.getConfiguredFeatures() : site.getSite().getFeatureReferences();
        Vector<IFeature> result = new Vector<IFeature>();
        for (int i = 0; i < references.length; ++i) {
            IFeature feature = references[i].getFeature(null);
            String id = feature.getVersionedIdentifier().getIdentifier();
            if (!featureId.equals(id)) continue;
            result.add(feature);
        }
        return result.toArray(new IFeature[result.size()]);
    }

    public static IFeature[] getInstalledFeatures(IFeature feature) {
        return UpdateUtils.getInstalledFeatures(feature, true);
    }

    public static IFeature[] getInstalledFeatures(IFeature feature, boolean onlyConfigured) {
        return UpdateUtils.getInstalledFeatures(feature.getVersionedIdentifier(), onlyConfigured);
    }

    public static IFeature[] getInstalledFeatures(VersionedIdentifier vid, boolean onlyConfigured) {
        Vector<IFeature> features = new Vector<IFeature>();
        try {
            ILocalSite localSite = SiteManager.getLocalSite();
            IInstallConfiguration config = localSite.getCurrentConfiguration();
            IConfiguredSite[] isites = config.getConfiguredSites();
            String id = vid.getIdentifier();
            for (int i = 0; i < isites.length; ++i) {
                IConfiguredSite isite = isites[i];
                IFeature[] result = UpdateUtils.searchSite(id, isite, onlyConfigured);
                for (int j = 0; j < result.length; ++j) {
                    IFeature installedFeature = result[j];
                    features.add(installedFeature);
                }
            }
        }
        catch (CoreException e) {
            UpdateUtils.logException(e);
        }
        return features.toArray(new IFeature[features.size()]);
    }

    public static IFeature getPatchedFeature(IFeature patch) {
        IImport[] imports = patch.getImports();
        for (int i = 0; i < imports.length; ++i) {
            IImport iimport = imports[i];
            if (!iimport.isPatch()) continue;
            VersionedIdentifier patchedVid = iimport.getVersionedIdentifier();
            IFeature[] features = UpdateUtils.getInstalledFeatures(patchedVid, false);
            for (int f = 0; f < features.length; ++f) {
                if (!patchedVid.equals(features[f].getVersionedIdentifier())) continue;
                return features[f];
            }
        }
        return null;
    }

    public static boolean isPatch(IFeature candidate) {
        IImport[] imports = candidate.getImports();
        for (int i = 0; i < imports.length; ++i) {
            IImport iimport = imports[i];
            if (!iimport.isPatch()) continue;
            return true;
        }
        return false;
    }

    public static boolean isPatch(IFeature target, IFeature candidate) {
        VersionedIdentifier vid = target.getVersionedIdentifier();
        IImport[] imports = candidate.getImports();
        for (int i = 0; i < imports.length; ++i) {
            VersionedIdentifier ivid;
            IImport iimport = imports[i];
            if (!iimport.isPatch() || !vid.equals(ivid = iimport.getVersionedIdentifier())) continue;
            return true;
        }
        return false;
    }

    public static IInstallConfiguration getBackupConfigurationFor(IFeature feature) {
        VersionedIdentifier vid = feature.getVersionedIdentifier();
        String key = "@" + vid.getIdentifier() + "_" + vid.getVersion();
        try {
            ILocalSite lsite = SiteManager.getLocalSite();
            IInstallConfiguration[] configs = lsite.getPreservedConfigurations();
            for (int i = 0; i < configs.length; ++i) {
                IInstallConfiguration config = configs[i];
                if (!config.getLabel().startsWith(key)) continue;
                return config;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public static boolean hasLicense(IFeature feature) {
        IURLEntry info = feature.getLicense();
        if (info == null) {
            return false;
        }
        String licenseTxt = info.getAnnotation();
        if (licenseTxt == null) {
            return false;
        }
        return licenseTxt.trim().length() > 0;
    }

    public static boolean hasOptionalFeatures(IFeatureReference fref) {
        try {
            return UpdateUtils.hasOptionalFeatures(fref.getFeature(null));
        }
        catch (CoreException e) {
            return false;
        }
    }

    public static boolean hasOptionalFeatures(IFeature feature) {
        try {
            IIncludedFeatureReference[] irefs = feature.getIncludedFeatureReferences();
            for (int i = 0; i < irefs.length; ++i) {
                IIncludedFeatureReference iref = irefs[i];
                if (iref.isOptional()) {
                    return true;
                }
                IFeature child = iref.getFeature(null);
                if (!UpdateUtils.hasOptionalFeatures(child)) continue;
                return true;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    public static IFeature getLocalFeature(IConfiguredSite csite, IFeature feature) throws CoreException {
        IFeatureReference[] refs = csite.getConfiguredFeatures();
        for (int i = 0; i < refs.length; ++i) {
            IFeatureReference ref = refs[i];
            VersionedIdentifier refVid = ref.getVersionedIdentifier();
            if (!feature.getVersionedIdentifier().equals(refVid)) continue;
            return ref.getFeature(null);
        }
        return null;
    }

    public static IConfiguredSite getConfigSite(IFeature feature, IInstallConfiguration config) throws CoreException {
        IConfiguredSite[] configSites = config.getConfiguredSites();
        for (int i = 0; i < configSites.length; ++i) {
            IConfiguredSite site = configSites[i];
            if (!site.getSite().equals(feature.getSite())) continue;
            return site;
        }
        return null;
    }

    public static IConfiguredSite getDefaultTargetSite(IInstallConfiguration config, IInstallFeatureOperation pendingChange) {
        return UpdateUtils.getDefaultTargetSite(config, pendingChange, true);
    }

    public static IConfiguredSite getDefaultTargetSite(IInstallConfiguration config, IInstallFeatureOperation pendingChange, boolean checkAffinityFeature) {
        IFeature oldFeature = pendingChange.getOldFeature();
        IFeature newFeature = pendingChange.getFeature();
        if (oldFeature != null) {
            try {
                return UpdateUtils.getConfigSite(oldFeature, config);
            }
            catch (CoreException e) {
                UpdateUtils.logException(e);
                return null;
            }
        }
        String newFeatureID = newFeature.getVersionedIdentifier().getIdentifier();
        IConfiguredSite sameSite = UpdateUtils.getSiteWithFeature(config, newFeatureID);
        if (sameSite != null) {
            return sameSite;
        }
        if (checkAffinityFeature) {
            return UpdateUtils.getAffinitySite(config, newFeature);
        }
        return null;
    }

    public static IConfiguredSite getAffinitySite(IInstallConfiguration config, IFeature newFeature) {
        String affinityID = newFeature.getAffinityFeature();
        if (affinityID != null) {
            IConfiguredSite affinitySite = UpdateUtils.getSiteWithFeature(config, affinityID);
            if (affinitySite != null) {
                return affinitySite;
            }
        } else {
            IFeature patchedFeature = UpdateUtils.getPatchedFeature(newFeature);
            if (patchedFeature != null) {
                return UpdateUtils.getSiteWithFeature(config, patchedFeature.getVersionedIdentifier().getIdentifier());
            }
        }
        return null;
    }

    public static IConfiguredSite getSiteWithFeature(IInstallConfiguration config, String featureID) {
        if (featureID == null) {
            return null;
        }
        IConfiguredSite[] sites = config.getConfiguredSites();
        for (int i = 0; i < sites.length; ++i) {
            IConfiguredSite site = sites[i];
            IFeatureReference[] refs = site.getFeatureReferences();
            for (int j = 0; j < refs.length; ++j) {
                IFeatureReference ref = refs[j];
                try {
                    IFeature feature = ref.getFeature(null);
                    if (!featureID.equals(feature.getVersionedIdentifier().getIdentifier())) continue;
                    return site;
                }
                catch (CoreException e) {
                    UpdateUtils.logException(e);
                }
            }
        }
        return null;
    }

    public static void collectOldFeatures(IFeature feature, IConfiguredSite targetSite, ArrayList result) throws CoreException {
        IIncludedFeatureReference[] included = feature.getIncludedFeatureReferences();
        for (int i = 0; i < included.length; ++i) {
            IFeature ifeature;
            IIncludedFeatureReference iref = included[i];
            try {
                ifeature = iref.getFeature(null);
            }
            catch (CoreException e) {
                if (iref.isOptional()) continue;
                throw e;
            }
            String id = iref.getVersionedIdentifier().getIdentifier();
            IFeature[] sameIds = UpdateUtils.searchSite(id, targetSite, true);
            for (int j = 0; j < sameIds.length; ++j) {
                IFeature sameId = sameIds[j];
                if (sameId.equals(ifeature)) continue;
                result.add(sameId);
            }
            UpdateUtils.collectOldFeatures(ifeature, targetSite, result);
        }
    }

    public static UpdateSearchRequest createNewUpdatesRequest(IFeature[] features) {
        UpdateSearchScope scope = new UpdateSearchScope();
        scope.setUpdateMapURL(UpdateUtils.getUpdateMapURL());
        UpdatesSearchCategory category = new UpdatesSearchCategory();
        if (features != null) {
            category.setFeatures(features);
        }
        UpdateSearchRequest searchRequest = new UpdateSearchRequest(category, scope);
        searchRequest.addFilter(new EnvironmentFilter());
        return searchRequest;
    }

    public static boolean isNestedChild(IInstallConfiguration config, IFeature feature) {
        IConfiguredSite[] csites = config.getConfiguredSites();
        try {
            for (int i = 0; csites != null && i < csites.length; ++i) {
                IFeatureReference[] refs = csites[i].getConfiguredFeatures();
                for (int j = 0; refs != null && j < refs.length; ++j) {
                    IFeature parent = refs[j].getFeature(null);
                    IIncludedFeatureReference[] children = parent.getIncludedFeatureReferences();
                    for (int k = 0; children != null && k < children.length; ++k) {
                        IFeature child = children[k].getFeature(null);
                        if (!feature.equals(child)) continue;
                        return true;
                    }
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    public static boolean hasObsoletePatches(IFeature feature) {
        try {
            IIncludedFeatureReference[] irefs = feature.getIncludedFeatureReferences();
            for (int i = 0; i < irefs.length; ++i) {
                IIncludedFeatureReference iref = irefs[i];
                IFeature ifeature = iref.getFeature(null);
                IConfiguredSite csite = ifeature.getSite().getCurrentConfiguredSite();
                if (csite.isConfigured(ifeature) || UpdateUtils.isPatchHappy(ifeature)) continue;
                return false;
            }
        }
        catch (CoreException e) {
            return false;
        }
        return true;
    }

    public static boolean isPatchHappy(IFeature feature) throws CoreException {
        IImport[] imports = feature.getImports();
        IImport patchReference = null;
        for (int i = 0; i < imports.length; ++i) {
            IImport iimport = imports[i];
            if (!iimport.isPatch()) continue;
            patchReference = iimport;
            break;
        }
        if (patchReference == null) {
            return false;
        }
        VersionedIdentifier refVid = patchReference.getVersionedIdentifier();
        IConfiguredSite csite = feature.getSite().getCurrentConfiguredSite();
        if (csite == null) {
            return false;
        }
        IFeatureReference[] crefs = csite.getConfiguredFeatures();
        for (int i = 0; i < crefs.length; ++i) {
            IFeatureReference cref = crefs[i];
            VersionedIdentifier cvid = cref.getVersionedIdentifier();
            if (!cvid.getIdentifier().equals(refVid.getIdentifier()) || !cvid.getVersion().isGreaterThan(refVid.getVersion())) continue;
            return true;
        }
        return false;
    }

    public static URL getUpdateMapURL() {
        Preferences pref = UpdateCore.getPlugin().getPluginPreferences();
        String mapFile = pref.getString(P_UPDATE_POLICY_URL);
        if (mapFile != null && mapFile.length() > 0) {
            try {
                String decodedFile = URLDecoder.decode(mapFile, "UTF-8");
                return new URL(decodedFile);
            }
            catch (MalformedURLException e) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void downloadFeatureContent(IFeature feature, final IProgressMonitor progress) throws InstallAbortedException, CoreException {
        int i;
        if (!(feature instanceof Feature)) {
            return;
        }
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_INSTALL) {
            UpdateCore.debug("Downloading...:" + feature.getURL().toExternalForm());
        }
        NullProgressMonitor pm = new NullProgressMonitor(){

            public boolean isCanceled() {
                return progress.isCanceled();
            }
        };
        InstallMonitor monitor = new InstallMonitor((IProgressMonitor)pm);
        IFeatureContentProvider provider = feature.getFeatureContentProvider();
        IPluginEntry[] targetSitePluginEntries = null;
        IPluginEntry[] sourceFeaturePluginEntries = feature.getPluginEntries();
        IConfiguredSite targetSite = UpdateUtils.getSiteWithFeature(SiteManager.getLocalSite().getCurrentConfiguration(), ((Feature)feature).getFeatureIdentifier());
        if (targetSite == null) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_INSTALL) {
                UpdateCore.debug("The site to install in is null");
            }
            targetSitePluginEntries = new IPluginEntry[]{};
        } else {
            targetSitePluginEntries = targetSite.getSite().getPluginEntries();
        }
        IPluginEntry[] pluginsToInstall = UpdateManagerUtils.diff(sourceFeaturePluginEntries, targetSitePluginEntries);
        INonPluginEntry[] nonPluginsToInstall = feature.getNonPluginEntries();
        provider.getFeatureEntryArchiveReferences(monitor);
        for (i = 0; i < pluginsToInstall.length; ++i) {
            provider.getPluginEntryArchiveReferences(pluginsToInstall[i], monitor);
        }
        for (i = 0; i < nonPluginsToInstall.length; ++i) {
            provider.getNonPluginEntryArchiveReferences(nonPluginsToInstall[i], monitor);
        }
        IIncludedFeatureReference[] children = feature.getIncludedFeatureReferences();
        for (int i2 = 0; i2 < children.length; ++i2) {
            IFeature childFeature = null;
            try {
                childFeature = children[i2].getFeature(null);
            }
            catch (CoreException e) {
                UpdateCore.warn(null, e);
            }
            if (childFeature == null) continue;
            UpdateUtils.downloadFeatureContent(childFeature, monitor);
        }
    }
}

