/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.position;

import org.osgi.util.measurement.Measurement;
import org.osgi.util.measurement.Unit;

public class Position {
    private Measurement altitude;
    private Measurement longitude;
    private Measurement latitude;
    private Measurement speed;
    private Measurement track;
    private static final double LON_RANGE = Math.PI;
    private static final double LAT_RANGE = Math.PI / 2.0;
    private static final double TRACK_RANGE = Math.PI * 2.0;

    public Position(Measurement measurement, Measurement measurement2, Measurement measurement3, Measurement measurement4, Measurement measurement5) {
        if (measurement != null) {
            if (!Unit.rad.equals(measurement.getUnit())) {
                throw new IllegalArgumentException("Invalid Latitude");
            }
            this.latitude = measurement;
        }
        if (measurement2 != null) {
            if (!Unit.rad.equals(measurement2.getUnit())) {
                throw new IllegalArgumentException("Invalid Longitude");
            }
            this.longitude = measurement2;
        }
        this.normalizeLatLon();
        if (measurement3 != null) {
            if (!Unit.m.equals(measurement3.getUnit())) {
                throw new IllegalArgumentException("Invalid Altitude");
            }
            this.altitude = measurement3;
        }
        if (measurement4 != null) {
            if (!Unit.m_s.equals(measurement4.getUnit())) {
                throw new IllegalArgumentException("Invalid Speed");
            }
            this.speed = measurement4;
        }
        if (measurement5 != null) {
            if (!Unit.rad.equals(measurement5.getUnit())) {
                throw new IllegalArgumentException("Invalid Track");
            }
            this.track = this.normalizeTrack(measurement5);
        }
    }

    public Measurement getAltitude() {
        return this.altitude;
    }

    public Measurement getLongitude() {
        return this.longitude;
    }

    public Measurement getLatitude() {
        return this.latitude;
    }

    public Measurement getSpeed() {
        return this.speed;
    }

    public Measurement getTrack() {
        return this.track;
    }

    private void normalizeLatLon() {
        if (this.longitude == null || this.latitude == null) {
            return;
        }
        double d = this.longitude.getValue();
        double d2 = this.latitude.getValue();
        if (d >= -LON_RANGE && d < LON_RANGE && d2 >= -LAT_RANGE && d2 <= LAT_RANGE) {
            return;
        }
        d = this.normalize(d, LON_RANGE);
        if ((d2 = this.normalize(d2, LAT_RANGE * 2.0)) > LAT_RANGE || d2 < -LAT_RANGE) {
            d = this.normalize(d - LON_RANGE, LON_RANGE);
            d2 = this.normalize(LAT_RANGE * 2.0 - d2, LAT_RANGE);
        }
        this.longitude = new Measurement(d, this.longitude.getError(), this.longitude.getUnit(), this.longitude.getTime());
        this.latitude = new Measurement(d2, this.latitude.getError(), this.latitude.getUnit(), this.latitude.getTime());
    }

    private double normalize(double d, double d2) {
        double d3 = 2.0 * d2;
        while (d >= d2) {
            d -= d3;
        }
        while (d < -d2) {
            d += d3;
        }
        return d;
    }

    private Measurement normalizeTrack(Measurement measurement) {
        double d = measurement.getValue();
        if (0.0 <= d && d < TRACK_RANGE) {
            return measurement;
        }
        if ((d %= TRACK_RANGE) < 0.0) {
            d += TRACK_RANGE;
        }
        return new Measurement(d, measurement.getError(), measurement.getUnit(), measurement.getTime());
    }
}

