/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.NewExampleAction;
import org.eclipse.ui.actions.NewProjectAction;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.ide.NewWizardShortcutAction;
import org.eclipse.ui.internal.registry.NewWizardsRegistryReader;

public class NewWizardMenu
extends ContributionItem {
    private IAction showDlgAction;
    private IAction newProjectAction;
    private IAction newExampleAction;
    private Map actions = new HashMap(21);
    private NewWizardsRegistryReader reader = new NewWizardsRegistryReader();
    private boolean enabled = true;
    private IWorkbenchWindow window;
    private boolean dirty = true;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.markDirty();
            NewWizardMenu.this.dirty = true;
        }
    };

    public NewWizardMenu(IMenuManager innerMgr, IWorkbenchWindow window, boolean register) {
        this(window);
        this.fillMenu((IContributionManager)innerMgr);
    }

    public NewWizardMenu(IWorkbenchWindow window) {
        this.window = window;
        this.showDlgAction = ActionFactory.NEW.create(window);
        this.newProjectAction = new NewProjectAction(window);
        this.newExampleAction = new NewExampleAction(window);
    }

    private void fillMenu(IContributionManager innerMgr) {
        innerMgr.removeAll();
        if (this.enabled) {
            innerMgr.add(this.newProjectAction);
            ArrayList actions = null;
            IWorkbenchPage page = this.window.getActivePage();
            if (page != null) {
                actions = ((WorkbenchPage)page).getNewWizardActionIds();
            }
            if (actions != null) {
                if (actions.size() > 0) {
                    innerMgr.add((IContributionItem)new Separator());
                }
                Iterator i = actions.iterator();
                while (i.hasNext()) {
                    String id = (String)i.next();
                    IAction action = this.getAction(id);
                    if (action == null || WorkbenchActivityHelper.filterItem((Object)action)) continue;
                    innerMgr.add(action);
                }
            }
            if (this.hasExamples()) {
                innerMgr.add((IContributionItem)new Separator());
                innerMgr.add(this.newExampleAction);
            }
            innerMgr.add((IContributionItem)new Separator());
            innerMgr.add(this.showDlgAction);
        }
    }

    private IAction getAction(String id) {
        WorkbenchWizardElement element;
        Object action = (IAction)this.actions.get(id);
        if (action == null && (element = this.reader.findWizard(id)) != null) {
            action = new NewWizardShortcutAction(this.window, element);
            this.actions.put(id, action);
        }
        return action;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setEnabled(boolean enabledValue) {
        this.enabled = enabledValue;
    }

    public void deregisterListeners() {
    }

    public void fill(Menu menu, int index) {
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        MenuManager manager = new MenuManager();
        this.fillMenu((IContributionManager)manager);
        IContributionItem[] items = manager.getItems();
        for (int i = 0; i < items.length; ++i) {
            items[i].fill(menu, index++);
        }
        this.dirty = false;
    }

    private boolean hasExamples() {
        NewWizardsRegistryReader rdr = new NewWizardsRegistryReader(false);
        Object[] children = rdr.getWizardElements().getChildren(null);
        for (int i = 0; i < children.length; ++i) {
            WizardCollectionElement currentChild = (WizardCollectionElement)children[i];
            if (!currentChild.getId().equals("org.eclipse.ui.Examples")) continue;
            return true;
        }
        return false;
    }
}

