/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.ui.refactoring.Assert;
import org.eclipse.ltk.internal.ui.refactoring.ExceptionHandler;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.WorkbenchRunnableAdapter;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class RefactoringWizardOpenOperation {
    private RefactoringWizard fWizard;
    private RefactoringStatus fInitialConditions;
    public static final int INITIAL_CONDITION_CHECKING_FAILED = 1025;

    public RefactoringWizardOpenOperation(RefactoringWizard wizard) {
        Assert.isNotNull((Object)wizard);
        this.fWizard = wizard;
    }

    public RefactoringStatus getInitialConditionCheckingStatus() {
        return this.fInitialConditions;
    }

    public int run(final Shell parent, final String dialogTitle) throws InterruptedException {
        Assert.isNotNull(dialogTitle);
        final Refactoring refactoring = this.fWizard.getRefactoring();
        final IJobManager manager = Platform.getJobManager();
        final int[] result = new int[1];
        final InterruptedException[] canceled = new InterruptedException[1];
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block7: {
                    block6: {
                        try {
                            try {
                                manager.suspend((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), null);
                                refactoring.setValidationContext((Object)parent);
                                RefactoringWizardOpenOperation.this.fInitialConditions = RefactoringWizardOpenOperation.this.checkInitialConditions(refactoring, parent, dialogTitle);
                                if (RefactoringWizardOpenOperation.this.fInitialConditions.hasFatalError()) {
                                    String message = RefactoringWizardOpenOperation.this.fInitialConditions.getMessageMatchingSeverity(4);
                                    MessageDialog.openInformation((Shell)parent, (String)dialogTitle, (String)message);
                                    result[0] = 1025;
                                    Object var3_5 = null;
                                    break block6;
                                }
                                RefactoringWizardOpenOperation.this.fWizard.setInitialConditionCheckingStatus(RefactoringWizardOpenOperation.this.fInitialConditions);
                                Dialog dialog = RefactoringUI.createRefactoringWizardDialog(RefactoringWizardOpenOperation.this.fWizard, parent);
                                result[0] = dialog.open();
                                break block7;
                            }
                            catch (InterruptedException e) {
                                canceled[0] = e;
                                Object var3_7 = null;
                                manager.resume((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                                refactoring.setValidationContext(null);
                                return;
                            }
                            catch (OperationCanceledException e) {
                                canceled[0] = new InterruptedException(e.getMessage());
                                Object var3_8 = null;
                                manager.resume((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                                refactoring.setValidationContext(null);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_9 = null;
                            manager.resume((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                            refactoring.setValidationContext(null);
                            throw throwable;
                        }
                    }
                    manager.resume((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                    refactoring.setValidationContext(null);
                    return;
                }
                Object var3_6 = null;
                manager.resume((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                refactoring.setValidationContext(null);
            }
        };
        BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)r);
        if (canceled[0] != null) {
            throw canceled[0];
        }
        return result[0];
    }

    private RefactoringStatus checkInitialConditions(Refactoring refactoring, Shell parent, String title) throws InterruptedException {
        try {
            CheckConditionsOperation cco = new CheckConditionsOperation(refactoring, 2);
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            service.busyCursorWhile((IRunnableWithProgress)new WorkbenchRunnableAdapter((IWorkspaceRunnable)cco, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot()));
            return cco.getStatus();
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, parent, title, RefactoringUIMessages.getString("RefactoringUI.open.unexpected_exception"));
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringUIMessages.getString("RefactoringUI.open.unexpected_exception"));
        }
    }
}

