/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.XMLWriter;
import org.eclipse.jdt.internal.core.util.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UserLibrary {
    private static final String CURRENT_VERSION = "1";
    private static final String TAG_VERSION = "version";
    private static final String TAG_USERLIBRARY = "userlibrary";
    private static final String TAG_SOURCEATTACHMENT = "sourceattachment";
    private static final String TAG_SOURCEATTACHMENTROOT = "sourceattachmentroot";
    private static final String TAG_PATH = "path";
    private static final String TAG_ARCHIVE = "archive";
    private static final String TAG_SYSTEMLIBRARY = "systemlibrary";
    private boolean isSystemLibrary;
    private IClasspathEntry[] entries;

    public UserLibrary(IClasspathEntry[] entries, boolean isSystemLibrary) {
        Assert.isNotNull(entries);
        this.entries = entries;
        this.isSystemLibrary = isSystemLibrary;
    }

    public IClasspathEntry[] getEntries() {
        return this.entries;
    }

    public boolean isSystemLibrary() {
        return this.isSystemLibrary;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            UserLibrary other = (UserLibrary)obj;
            if (this.entries.length == other.entries.length && this.isSystemLibrary == other.isSystemLibrary) {
                for (int i = 0; i < this.entries.length; ++i) {
                    if (this.entries[i].equals(other.entries[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.isSystemLibrary) {
            ++hashCode;
        }
        for (int i = 0; i < this.entries.length; ++i) {
            hashCode = hashCode * 17 + this.entries.hashCode();
        }
        return hashCode;
    }

    String serialize() throws IOException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)s, "UTF8");
        XMLWriter xmlWriter = new XMLWriter(writer);
        HashMap<String, String> library = new HashMap<String, String>();
        library.put(TAG_VERSION, String.valueOf(CURRENT_VERSION));
        library.put(TAG_SYSTEMLIBRARY, String.valueOf(this.isSystemLibrary));
        xmlWriter.printTag(TAG_USERLIBRARY, library, true, true, false);
        for (int i = 0; i < this.entries.length; ++i) {
            IPath sourceAttachRoot;
            IClasspathEntry curr = this.entries[i];
            HashMap<String, String> archive = new HashMap<String, String>();
            archive.put(TAG_PATH, curr.getPath().toString());
            IPath sourceAttach = curr.getSourceAttachmentPath();
            if (sourceAttach != null) {
                archive.put(TAG_SOURCEATTACHMENT, (String)sourceAttach);
            }
            if ((sourceAttachRoot = curr.getSourceAttachmentRootPath()) != null) {
                archive.put(TAG_SOURCEATTACHMENTROOT, (String)sourceAttachRoot);
            }
            xmlWriter.printTag(TAG_ARCHIVE, archive, true, true, true);
        }
        xmlWriter.endTag(TAG_USERLIBRARY, true);
        writer.flush();
        writer.close();
        return s.toString("UTF8");
    }

    static UserLibrary createFromString(Reader reader) throws IOException {
        Element cpElement;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
        }
        catch (SAXException e) {
            throw new IOException(Util.bind("file.badFormat"));
        }
        catch (ParserConfigurationException e) {
            throw new IOException(Util.bind("file.badFormat"));
        }
        finally {
            reader.close();
        }
        if (!cpElement.getNodeName().equalsIgnoreCase(TAG_USERLIBRARY)) {
            throw new IOException(Util.bind("file.badFormat"));
        }
        boolean isSystem = Boolean.valueOf(cpElement.getAttribute(TAG_SYSTEMLIBRARY));
        NodeList list = cpElement.getChildNodes();
        int length = list.getLength();
        ArrayList<IClasspathEntry> res = new ArrayList<IClasspathEntry>(length);
        for (int i = 0; i < length; ++i) {
            Element element;
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !(element = (Element)node).getNodeName().equals(TAG_ARCHIVE)) continue;
            String path = element.getAttribute(TAG_PATH);
            Path sourceAttach = element.hasAttribute(TAG_SOURCEATTACHMENT) ? new Path(element.getAttribute(TAG_SOURCEATTACHMENT)) : null;
            Path sourceAttachRoot = element.hasAttribute(TAG_SOURCEATTACHMENTROOT) ? new Path(element.getAttribute(TAG_SOURCEATTACHMENTROOT)) : null;
            res.add(JavaCore.newLibraryEntry((IPath)new Path(path), (IPath)sourceAttach, (IPath)sourceAttachRoot));
        }
        IClasspathEntry[] entries = res.toArray(new IClasspathEntry[res.size()]);
        return new UserLibrary(entries, isSystem);
    }

    public String toString() {
        if (this.entries == null) {
            return "null";
        }
        StringBuffer buffer = new StringBuffer();
        int length = this.entries.length;
        for (int i = 0; i < length; ++i) {
            buffer.append(this.entries[i].toString() + '\n');
        }
        return buffer.toString();
    }
}

