/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.pde.internal.core.ischema.*;
import org.eclipse.pde.internal.core.schema.SchemaElementReference;
import org.eclipse.pde.internal.ui.PDEPlugin;

public class ReferencePropertySource extends GrammarPropertySource {

	public ReferencePropertySource(SchemaElementReference obj) {
		super(obj);
	}

	protected String isMinOccursValid(int ivalue) {
		String status = super.isMinOccursValid(ivalue);
		if (status==null && isInAll()) {
			if (ivalue!=0 && ivalue!=1) {
				return PDEPlugin.getResourceString("ReferencePropertySource.minOccurs.value"); //$NON-NLS-1$
			}
		}
		return status;
	}

	protected String isMaxOccursValid(int ivalue) {
		String status = super.isMaxOccursValid(ivalue);
		if (status==null && isInAll()) {
			if (ivalue!=1) {
				return PDEPlugin.getResourceString("ReferencePropertySource.maxOccurs.value"); //$NON-NLS-1$
			}
		}
		return status;
	}
	
	private boolean isInAll() {
		ISchemaCompositor compositor = getReference().getCompositor();
		return (compositor!=null && compositor.getKind()==ISchemaCompositor.ALL);
	}
	
	protected SchemaElementReference getReference() {
		return (SchemaElementReference)getSourceObject();
	}
}
