/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.launchConfigurations.AntWorkingDirectoryBlock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaJRETab;
import org.eclipse.jdt.internal.debug.ui.jres.JREDescriptor;
import org.eclipse.jdt.internal.debug.ui.launcher.VMArgumentsBlock;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public class AntJRETab
extends JavaJRETab {
    private static final String MAIN_TYPE_NAME = "org.eclipse.ant.internal.ui.antsupport.InternalAntRunner";
    protected VMArgumentsBlock fVMArgumentsBlock = new VMArgumentsBlock();
    protected AntWorkingDirectoryBlock fWorkingDirectoryBlock = new AntWorkingDirectoryBlock();

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"ant_jre_tab_context");
        Composite comp = (Composite)this.fJREBlock.getControl();
        ((GridData)comp.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)comp.getLayoutData()).verticalAlignment = 4;
        this.fVMArgumentsBlock.createControl(comp);
        ((GridData)this.fVMArgumentsBlock.getControl().getLayoutData()).horizontalSpan = 2;
        this.fWorkingDirectoryBlock.createControl(comp);
        ((GridData)this.fWorkingDirectoryBlock.getControl().getLayoutData()).horizontalSpan = 2;
    }

    protected JREDescriptor getDefaultJREDescriptor() {
        return new JREDescriptor(){

            public String getDescription() {
                return AntLaunchConfigurationMessages.getString("AntJRETab.2");
            }
        };
    }

    protected JREDescriptor getSpecificJREDescriptor() {
        return new JREDescriptor(){

            public String getDescription() {
                return AntLaunchConfigurationMessages.getString("AntJRETab.3");
            }
        };
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.fWorkingDirectoryBlock.setEnabled(!this.fJREBlock.isDefaultJRE());
        this.fVMArgumentsBlock.setEnabled(!this.fJREBlock.isDefaultJRE());
        if (this.fJREBlock.isDefaultJRE()) {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, (String)null);
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, (String)null);
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, (String)null);
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, (String)null);
        } else {
            super.performApply(configuration);
            this.applySeparateVMAttributes(configuration);
            this.fVMArgumentsBlock.performApply(configuration);
            this.fWorkingDirectoryBlock.performApply(configuration);
        }
        this.setLaunchConfigurationWorkingCopy(configuration);
    }

    private void applySeparateVMAttributes(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, MAIN_TYPE_NAME);
        configuration.setAttribute("process_factory_id", "org.eclipse.ant.ui.remoteAntProcessFactory");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        this.fVMArgumentsBlock.initializeFrom(configuration);
        this.fWorkingDirectoryBlock.initializeFrom(configuration);
        boolean separateVM = !this.fJREBlock.isDefaultJRE();
        this.fWorkingDirectoryBlock.setEnabled(separateVM);
        this.fVMArgumentsBlock.setEnabled(separateVM);
    }

    public boolean isValid(ILaunchConfiguration config) {
        return this.fWorkingDirectoryBlock.isValid(config);
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.fWorkingDirectoryBlock.setLaunchConfigurationDialog(dialog);
        this.fVMArgumentsBlock.setLaunchConfigurationDialog(dialog);
    }

    public String getErrorMessage() {
        String m = super.getErrorMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getErrorMessage();
        }
        return m;
    }

    public String getMessage() {
        String m = super.getMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getMessage();
        }
        return m;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.setLaunchConfigurationWorkingCopy(workingCopy);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        IVMInstall defaultInstall = null;
        try {
            defaultInstall = JavaRuntime.computeVMInstall((ILaunchConfiguration)config);
        }
        catch (CoreException e) {
            defaultInstall = JavaRuntime.getDefaultVMInstall();
        }
        if (defaultInstall != null) {
            String vmName = defaultInstall.getName();
            String vmTypeID = defaultInstall.getVMInstallType().getId();
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, vmName);
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, vmTypeID);
            this.applySeparateVMAttributes(config);
        }
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

