/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.team.internal.ui.synchronize.actions.OpenWithActionGroup;
import org.eclipse.team.internal.ui.synchronize.actions.RefactorActionGroup;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;

public class DefaultSynchronizePageActions
extends SynchronizePageActionGroup {
    private OpenWithActionGroup openWithActions;
    private RefactorActionGroup refactorActions;

    public void initialize(ISynchronizePageConfiguration configuration) {
        super.initialize(configuration);
        ISynchronizePageSite site = configuration.getSite();
        IWorkbenchSite ws = site.getWorkbenchSite();
        if (ws instanceof IViewSite) {
            this.openWithActions = new OpenWithActionGroup(site, configuration.getParticipant().getName());
            this.refactorActions = new RefactorActionGroup(site);
            configuration.setProperty("org.eclipse.team.ui.P_OPEN_ACTION", new Action(){

                public void run() {
                    DefaultSynchronizePageActions.this.openWithActions.openInCompareEditor();
                }
            });
        }
    }

    public void fillContextMenu(IMenuManager manager) {
        IContributionItem group = this.findGroup((IContributionManager)manager, "file");
        if (this.openWithActions != null && group != null) {
            this.openWithActions.fillContextMenu(manager, group.getId());
        }
        group = this.findGroup((IContributionManager)manager, "edit");
        if (this.refactorActions != null && group != null) {
            this.refactorActions.fillContextMenu(manager, group.getId());
        }
    }

    public void dispose() {
        if (this.refactorActions != null) {
            this.refactorActions.dispose();
        }
        if (this.openWithActions != null) {
            this.openWithActions.dispose();
        }
        super.dispose();
    }
}

