/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public final class ContentDescription
implements IContentDescription {
    private static final String CHARSET_UTF_16 = "UTF-16";
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final byte FLAG_ALL_OPTIONS = 1;
    private static final byte FLAG_IMMUTABLE = 2;
    private IContentType contentType;
    private byte flags;
    private Object keys;
    private Object values;

    public ContentDescription(QualifiedName[] requested) {
        if (requested == IContentDescription.ALL) {
            this.flags = (byte)(this.flags | 1);
            return;
        }
        if (requested.length > 1) {
            this.keys = requested;
            this.values = new Object[requested.length];
        } else if (requested.length == 1) {
            this.keys = requested[0];
        }
    }

    private void assertMutable() {
        if ((this.flags & 2) != 0) {
            throw new IllegalStateException("Content description is immutable");
        }
    }

    public String getCharset() {
        byte[] bom = (byte[])this.getProperty(IContentDescription.BYTE_ORDER_MARK);
        if (bom == IContentDescription.BOM_UTF_8) {
            return CHARSET_UTF_8;
        }
        if (bom == IContentDescription.BOM_UTF_16BE || bom == IContentDescription.BOM_UTF_16LE) {
            return CHARSET_UTF_16;
        }
        return (String)this.getProperty(IContentDescription.CHARSET);
    }

    public IContentType getContentType() {
        return this.contentType;
    }

    public Object getProperty(QualifiedName key) {
        if (this.values == null) {
            return null;
        }
        if (this.keys instanceof QualifiedName) {
            return this.keys.equals(key) ? this.values : null;
        }
        QualifiedName[] tmpKeys = (QualifiedName[])this.keys;
        for (int i = 0; i < tmpKeys.length; ++i) {
            if (!tmpKeys[i].equals(key)) continue;
            return ((Object[])this.values)[i];
        }
        return null;
    }

    public boolean isRequested(QualifiedName propertyKey) {
        if ((this.flags & 1) != 0) {
            return true;
        }
        if (this.keys == null) {
            return false;
        }
        if (this.keys instanceof QualifiedName) {
            return this.keys.equals(propertyKey);
        }
        QualifiedName[] tmpKeys = (QualifiedName[])this.keys;
        for (int i = 0; i < tmpKeys.length; ++i) {
            if (!tmpKeys[i].equals(propertyKey)) continue;
            return true;
        }
        return false;
    }

    boolean isSet() {
        if (this.keys == null || this.values == null) {
            return false;
        }
        if (this.keys instanceof QualifiedName) {
            return true;
        }
        Object[] tmpValues = (Object[])this.values;
        for (int i = 0; i < tmpValues.length; ++i) {
            if (tmpValues[i] == null) continue;
            return true;
        }
        return false;
    }

    public void markImmutable() {
        this.assertMutable();
        this.flags = (byte)(this.flags | 2);
    }

    void setContentType(IContentType contentType) {
        this.markImmutable();
        this.contentType = contentType;
    }

    public void setProperty(QualifiedName newKey, Object newValue) {
        this.assertMutable();
        if (this.keys == null) {
            if ((this.flags & 1) != 0) {
                this.keys = newKey;
                this.values = newValue;
            }
            return;
        }
        if (this.keys.equals(newKey)) {
            this.values = newValue;
            return;
        }
        if (this.keys instanceof QualifiedName) {
            if ((this.flags & 1) != 0) {
                this.keys = new QualifiedName[]{(QualifiedName)this.keys, newKey};
                this.values = new Object[]{this.values, newValue};
            }
            return;
        }
        QualifiedName[] tmpKeys = (QualifiedName[])this.keys;
        for (int i = 0; i < tmpKeys.length; ++i) {
            if (!tmpKeys[i].equals(newKey)) continue;
            ((Object[])this.values)[i] = newValue;
            return;
        }
        if ((this.flags & 1) == 0) {
            return;
        }
        int currentSize = tmpKeys.length;
        tmpKeys = new QualifiedName[currentSize + 1];
        System.arraycopy(this.keys, 0, tmpKeys, 0, currentSize);
        Object[] tmpValues = new Object[currentSize + 1];
        System.arraycopy(this.values, 0, tmpValues, 0, currentSize);
        tmpKeys[tmpKeys.length - 1] = newKey;
        tmpValues[tmpValues.length - 1] = newValue;
        this.keys = tmpKeys;
        this.values = tmpValues;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("{");
        if (this.keys != null) {
            if (this.keys instanceof QualifiedName) {
                if (this.values != null) {
                    result.append(this.keys + "=" + this.values);
                }
            } else {
                QualifiedName[] tmpKeys = (QualifiedName[])this.keys;
                Object[] tmpValues = (Object[])this.values;
                boolean any = false;
                for (int i = 0; i < tmpKeys.length; ++i) {
                    if (tmpValues[i] == null) continue;
                    result.append(tmpKeys[i] + "=" + tmpValues[i] + ",");
                    any = true;
                }
                if (any) {
                    result.deleteCharAt(result.length() - 1);
                }
            }
        }
        result.append("} : ");
        result.append(this.contentType);
        return result.toString();
    }
}

