/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;

public class ConnectionThreadManager {
    private static final String CONNECT_TIMEOUT = "60000";
    private static final String READ_TIMEOUT = "60000";
    private static final int MAX_COUNT = 9;
    private Vector threads;

    public ConnectionThreadManager() {
        this.setIfNotDefaultProperty("sun.net.client.defaultConnectTimeout", "60000");
        this.setIfNotDefaultProperty("sun.net.client.defaultReadTimeout", "60000");
    }

    private void setIfNotDefaultProperty(String key, String value) {
        String oldValue = System.getProperty(key);
        if (oldValue == null || oldValue.equals("-1")) {
            System.setProperty(key, value);
        }
    }

    public Thread createThread(StreamRunnable runnable) throws CoreException {
        this.validateExistingThreads();
        if (this.threads == null) {
            this.threads = new Vector();
        }
        ConnectionThread t = new ConnectionThread(runnable);
        t.setDaemon(true);
        this.threads.add(t);
        return t;
    }

    private void validateExistingThreads() throws CoreException {
        if (this.threads == null) {
            return;
        }
        int aliveCount = this.purgeTerminatedThreads();
        if (aliveCount > 9) {
            ArrayList<Status> children = new ArrayList<Status>();
            String pluginId = UpdateCore.getPlugin().getBundle().getSymbolicName();
            for (int i = 0; i < this.threads.size(); ++i) {
                ConnectionThread t = (ConnectionThread)this.threads.get(i);
                String url = t.getRunnable().getURL().toString();
                Status status = new Status(4, pluginId, 0, Policy.bind("ConnectionThreadManager.unresponsiveURL", url), null);
                children.add(status);
            }
            MultiStatus parentStatus = new MultiStatus(pluginId, 0, children.toArray(new IStatus[children.size()]), Policy.bind("ConnectionThreadManager.tooManyConnections"), null);
            throw new CoreException((IStatus)parentStatus);
        }
    }

    private int purgeTerminatedThreads() {
        int aliveCount = 0;
        Object[] array = this.threads.toArray();
        for (int i = 0; i < array.length; ++i) {
            Thread t = (Thread)array[i];
            if (!t.isAlive()) {
                this.threads.remove(t);
                continue;
            }
            ++aliveCount;
        }
        return aliveCount;
    }

    public void shutdown() {
        this.threads.clear();
    }

    class ConnectionThread
    extends Thread {
        private StreamRunnable runnable;

        public ConnectionThread(StreamRunnable runnable) {
            super((Runnable)runnable, "update-connection");
            this.runnable = runnable;
        }

        public StreamRunnable getRunnable() {
            return this.runnable;
        }
    }

    public static class StreamRunnable
    implements Runnable {
        private HttpURLConnection urlConnection;
        private Exception exception;
        private InputStream is;
        private boolean disconnected;

        public StreamRunnable(HttpURLConnection urlConnection) {
            this.urlConnection = urlConnection;
        }

        public InputStream getInputStream() {
            return this.is;
        }

        public URL getURL() {
            return this.urlConnection.getURL();
        }

        public Exception getException() {
            return this.exception;
        }

        public void disconnect() {
            this.urlConnection.disconnect();
            this.disconnected = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block7: {
                try {
                    this.is = this.urlConnection.getInputStream();
                    if (!this.disconnected || this.is == null) break block7;
                    try {
                        this.is.close();
                    }
                    catch (IOException ex) {
                    }
                    finally {
                        this.is = null;
                    }
                }
                catch (Exception e) {
                    this.exception = e;
                }
            }
        }
    }
}

