/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.InstallRegistry;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IUninstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.standalone.ScriptedCommand;
import org.eclipse.update.standalone.StandaloneUpdateApplication;

public class UninstallCommand
extends ScriptedCommand {
    private IConfiguredSite targetSite;
    private IFeature feature;

    public UninstallCommand(String featureId, String version, String toSite, String verifyOnly) throws Exception {
        super(verifyOnly);
        try {
            IFeature[] features;
            IConfiguredSite[] sites = this.getConfiguration().getConfiguredSites();
            if (toSite != null) {
                URL toSiteURL = new File(toSite).toURL();
                if (SiteManager.getSite(toSiteURL, null) == null) {
                    throw new Exception(Policy.bind("Standalone.noSite") + toSite);
                }
                this.targetSite = SiteManager.getSite(toSiteURL, null).getCurrentConfiguredSite();
            }
            if (this.targetSite == null) {
                for (int i = 0; i < sites.length; ++i) {
                    if (!sites[i].isProductSite()) continue;
                    this.targetSite = sites[i];
                    break;
                }
            }
            if ((features = UpdateUtils.searchSite(featureId, this.targetSite, false)) == null || features.length == 0) {
                throw new Exception(Policy.bind("Standalone.noFeatures1", featureId));
            }
            if (version == null || version.trim().length() == 0) {
                this.feature = features[0];
            } else {
                for (int i = 0; features != null && i < features.length; ++i) {
                    if (!features[i].getVersionedIdentifier().getVersion().toString().equals(version) || this.targetSite.isConfigured(features[i])) continue;
                    this.feature = features[i];
                    break;
                }
            }
            if (this.feature == null) {
                throw new Exception(Policy.bind("Standalone.noFeatures2", featureId, version));
            }
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (CoreException e) {
            throw e;
        }
    }

    public boolean run(IProgressMonitor monitor) {
        IStatus status = OperationsManager.getValidator().validatePlatformConfigValid();
        if (status != null) {
            UpdateCore.log(status);
            return false;
        }
        if (InstallRegistry.getInstance().get("feature_" + this.feature.getVersionedIdentifier()) == null) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(Utilities.newCoreException(Policy.bind("UninstallCommand.featureNotInstalledByUM", this.feature.toString()), null));
            return false;
        }
        if (this.isVerifyOnly()) {
            return true;
        }
        IUninstallFeatureOperation uninstallOperation = OperationsManager.getOperationFactory().createUninstallOperation(this.targetSite, this.feature);
        try {
            uninstallOperation.execute(monitor, this);
            return true;
        }
        catch (CoreException e) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(e);
            return false;
        }
        catch (InvocationTargetException e) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(e);
            return false;
        }
    }
}

