/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.AbstractDeleteChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.Utils;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class DeleteFileChange
extends AbstractDeleteChange {
    private IPath fPath;

    public DeleteFileChange(IFile file) {
        Assert.isNotNull(file, "file");
        this.fPath = Utils.getResourcePath((IResource)file);
    }

    private IFile getFile() {
        return Utils.getFile(this.fPath);
    }

    public String getName() {
        return RefactoringCoreMessages.getFormattedString("DeleteFileChange.1", this.fPath.lastSegment());
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return super.isValid(pm, false, true);
    }

    public Object getModifiedElement() {
        return this.getFile();
    }

    protected void doDelete(IProgressMonitor pm) throws CoreException {
        IFile file = this.getFile();
        Assert.isNotNull(file);
        Assert.isTrue(file.exists());
        file.delete(false, true, pm);
    }
}

