/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.Utils;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IPackageFragmentRootManipulationQuery;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.ltk.core.refactoring.Change;

abstract class PackageFragmentRootReorgChange
extends JDTChange {
    private final String fRootHandle;
    private final IPath fDestinationPath;
    private final INewNameQuery fNewNameQuery;
    private final IPackageFragmentRootManipulationQuery fUpdateClasspathQuery;

    PackageFragmentRootReorgChange(IPackageFragmentRoot root, IProject destination, INewNameQuery newNameQuery, IPackageFragmentRootManipulationQuery updateClasspathQuery) {
        Assert.isTrue(!root.isExternal());
        this.fRootHandle = root.getHandleIdentifier();
        this.fDestinationPath = Utils.getResourcePath((IResource)destination);
        this.fNewNameQuery = newNameQuery;
        this.fUpdateClasspathQuery = updateClasspathQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask(this.getName(), 2);
        try {
            String newName = this.getNewResourceName();
            Change change = this.doPerformReorg(this.getDestinationProjectPath().append(newName), (IProgressMonitor)new SubProgressMonitor(pm, 1));
            return change;
        }
        finally {
            pm.done();
        }
    }

    protected abstract Change doPerformReorg(IPath var1, IProgressMonitor var2) throws JavaModelException;

    public Object getModifiedElement() {
        return this.getRoot();
    }

    protected IPackageFragmentRoot getRoot() {
        return (IPackageFragmentRoot)JavaCore.create((String)this.fRootHandle);
    }

    protected IPath getDestinationProjectPath() {
        return this.fDestinationPath;
    }

    protected IProject getDestinationProject() {
        return Utils.getProject(this.getDestinationProjectPath());
    }

    private String getNewResourceName() {
        if (this.fNewNameQuery == null) {
            return this.getRoot().getElementName();
        }
        String name = this.fNewNameQuery.getNewName();
        if (name == null) {
            return this.getRoot().getElementName();
        }
        return name;
    }

    protected int getUpdateModelFlags(boolean isCopy) throws JavaModelException {
        int otherProjects;
        int originating;
        int destination = 8;
        int replace = 16;
        if (isCopy) {
            originating = 0;
            otherProjects = 0;
        } else {
            originating = 2;
            otherProjects = 4;
        }
        if (!JavaCore.create((IProject)this.getDestinationProject()).exists()) {
            return 0x10 | originating;
        }
        if (this.fUpdateClasspathQuery == null) {
            return 0x10 | originating | 8;
        }
        IJavaProject[] referencingProjects = JavaElementUtil.getReferencingProjects(this.getRoot());
        if (referencingProjects.length == 0) {
            return 0x10 | originating | 8;
        }
        boolean updateOtherProjectsToo = this.fUpdateClasspathQuery.confirmManipulation(this.getRoot(), referencingProjects);
        if (updateOtherProjectsToo) {
            return 0x10 | originating | 8 | otherProjects;
        }
        return 0x10 | originating | 8;
    }

    protected int getResourceUpdateFlags() {
        return 34;
    }
}

