/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEdit;

public class RefactoringAnalyzeUtil {
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$AnonymousClassDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$TypeDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$MethodDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$Block;

    private RefactoringAnalyzeUtil() {
    }

    public static IRegion[] getNewRanges(TextEdit[] edits, TextChange change) {
        IRegion[] result = new IRegion[edits.length];
        for (int i = 0; i < edits.length; ++i) {
            result[i] = RefactoringAnalyzeUtil.getNewTextRange(edits[i], change);
        }
        return result;
    }

    public static RefactoringStatus reportProblemNodes(String modifiedWorkingCopySource, SimpleName[] problemNodes) {
        RefactoringStatus result = new RefactoringStatus();
        for (int i = 0; i < problemNodes.length; ++i) {
            JavaStringStatusContext context = new JavaStringStatusContext(modifiedWorkingCopySource, new SourceRange((ASTNode)problemNodes[i]));
            result.addError(RefactoringCoreMessages.getFormattedString("RefactoringAnalyzeUtil.name_collision", problemNodes[i].getIdentifier()), (RefactoringStatusContext)context);
        }
        return result;
    }

    public static String getFullBindingKey(VariableDeclaration decl) {
        MethodDeclaration md;
        TypeDeclaration td;
        StringBuffer buff = new StringBuffer();
        if (decl.resolveBinding() != null) {
            buff.append(decl.resolveBinding().getVariableId());
            buff.append('/');
        } else {
            buff.append(decl.getStartPosition()).append('*').append('/');
        }
        AnonymousClassDeclaration acd = (AnonymousClassDeclaration)ASTNodes.getParent((ASTNode)decl, class$org$eclipse$jdt$core$dom$AnonymousClassDeclaration == null ? (class$org$eclipse$jdt$core$dom$AnonymousClassDeclaration = RefactoringAnalyzeUtil.class$("org.eclipse.jdt.core.dom.AnonymousClassDeclaration")) : class$org$eclipse$jdt$core$dom$AnonymousClassDeclaration);
        if (acd != null && acd.resolveBinding() != null) {
            if (acd.resolveBinding().getKey() != null) {
                buff.append(acd.resolveBinding().getKey());
            } else {
                buff.append("AnonymousClassDeclaration");
            }
            buff.append('/');
        }
        if ((td = (TypeDeclaration)ASTNodes.getParent((ASTNode)decl, class$org$eclipse$jdt$core$dom$TypeDeclaration == null ? (class$org$eclipse$jdt$core$dom$TypeDeclaration = RefactoringAnalyzeUtil.class$("org.eclipse.jdt.core.dom.TypeDeclaration")) : class$org$eclipse$jdt$core$dom$TypeDeclaration)) != null && td.resolveBinding() != null) {
            if (td.resolveBinding().getKey() != null) {
                buff.append(td.resolveBinding().getKey());
            } else {
                buff.append("TypeDeclaration");
            }
            buff.append('/');
        }
        if ((md = (MethodDeclaration)ASTNodes.getParent((ASTNode)decl, class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = RefactoringAnalyzeUtil.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration)) != null && md.resolveBinding() != null) {
            if (md.resolveBinding().getKey() != null) {
                buff.append(md.resolveBinding().getKey());
            } else {
                buff.append("MethodDeclaration");
            }
        }
        return buff.toString();
    }

    public static MethodDeclaration getMethodDeclaration(TextEdit edit, TextChange change, CompilationUnit cuNode) {
        SimpleName decl = RefactoringAnalyzeUtil.findSimpleNameNode(RefactoringAnalyzeUtil.getNewTextRange(edit, change), cuNode);
        return (MethodDeclaration)ASTNodes.getParent((ASTNode)decl, class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = RefactoringAnalyzeUtil.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration);
    }

    public static Block getBlock(TextEdit edit, TextChange change, CompilationUnit cuNode) {
        SimpleName decl = RefactoringAnalyzeUtil.findSimpleNameNode(RefactoringAnalyzeUtil.getNewTextRange(edit, change), cuNode);
        return (Block)ASTNodes.getParent((ASTNode)decl, class$org$eclipse$jdt$core$dom$Block == null ? (class$org$eclipse$jdt$core$dom$Block = RefactoringAnalyzeUtil.class$("org.eclipse.jdt.core.dom.Block")) : class$org$eclipse$jdt$core$dom$Block);
    }

    public static IProblem[] getIntroducedCompileProblems(CompilationUnit newCUNode, CompilationUnit oldCuNode) {
        HashSet<IProblem> subResult = new HashSet<IProblem>();
        Set oldProblems = RefactoringAnalyzeUtil.getOldProblems(oldCuNode);
        IProblem[] newProblems = ASTNodes.getProblems((ASTNode)newCUNode, 2, 3);
        for (int i = 0; i < newProblems.length; ++i) {
            IProblem correspondingOld = RefactoringAnalyzeUtil.findCorrespondingProblem(oldProblems, newProblems[i]);
            if (correspondingOld != null) continue;
            subResult.add(newProblems[i]);
        }
        return subResult.toArray(new IProblem[subResult.size()]);
    }

    private static IProblem findCorrespondingProblem(Set oldProblems, IProblem iProblem) {
        Iterator iter = oldProblems.iterator();
        while (iter.hasNext()) {
            IProblem oldProblem = (IProblem)iter.next();
            if (!RefactoringAnalyzeUtil.isCorresponding(oldProblem, iProblem)) continue;
            return oldProblem;
        }
        return null;
    }

    private static boolean isCorresponding(IProblem oldProblem, IProblem iProblem) {
        if (oldProblem.getID() != iProblem.getID()) {
            return false;
        }
        return oldProblem.getMessage().equals(iProblem.getMessage());
    }

    private static SimpleName getSimpleName(ASTNode node) {
        if (node instanceof SimpleName) {
            return (SimpleName)node;
        }
        if (node instanceof VariableDeclaration) {
            return ((VariableDeclaration)node).getName();
        }
        return null;
    }

    private static SimpleName findSimpleNameNode(IRegion range, CompilationUnit cuNode) {
        ASTNode node = NodeFinder.perform((ASTNode)cuNode, range.getOffset(), range.getLength());
        return RefactoringAnalyzeUtil.getSimpleName(node);
    }

    private static IRegion getNewTextRange(TextEdit edit, TextChange change) {
        return change.getPreviewEdit(edit).getRegion();
    }

    private static Set getOldProblems(CompilationUnit oldCuNode) {
        return new HashSet<IProblem>(Arrays.asList(ASTNodes.getProblems((ASTNode)oldCuNode, 2, 3)));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

