/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMembersProcessor;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.MoveMembersWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class MoveStaticMembersAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    static /* synthetic */ Class class$org$eclipse$jdt$internal$corext$refactoring$structure$MoveStaticMembersProcessor;

    public MoveStaticMembersAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.getString("RefactoringGroup.move_label"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.move_action");
    }

    public MoveStaticMembersAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(MoveStaticMembersAction.canEnable(MoveStaticMembersAction.getSelectedMembers(selection)));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            this.setEnabled(false);
        }
    }

    private boolean canEnable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement element = selection.resolveEnclosingElement();
        if (!(element instanceof IMember)) {
            return false;
        }
        return MoveStaticMembersProcessor.isAvailable(new IMember[]{(IMember)element});
    }

    public void run(IStructuredSelection selection) {
        try {
            IMember[] members = MoveStaticMembersAction.getSelectedMembers(selection);
            if (MoveStaticMembersAction.canEnable(members)) {
                this.startRefactoring(members);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
    }

    public void run(ITextSelection selection) {
        try {
            if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
                return;
            }
            IMember member = this.getSelectedMember();
            IMember[] array = new IMember[]{member};
            if (member != null && MoveStaticMembersAction.canEnable(array)) {
                this.startRefactoring(array);
            } else {
                String unavailable = RefactoringMessages.getString("MoveMembersAction.unavailable");
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.getString("OpenRefactoringWizardAction.unavailable"), (String)unavailable);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
    }

    private static IMember[] getSelectedMembers(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof IMember) continue;
            return null;
        }
        return MoveStaticMembersAction.convertToMemberArray(selection.toArray());
    }

    private static IMember[] convertToMemberArray(Object[] obj) {
        if (obj == null) {
            return null;
        }
        HashSet<Object> memberSet = new HashSet<Object>();
        memberSet.addAll(Arrays.asList(obj));
        return memberSet.toArray(new IMember[memberSet.size()]);
    }

    private static boolean canEnable(IMember[] members) throws JavaModelException {
        return MoveStaticMembersProcessor.isAvailable(members);
    }

    private IMember getSelectedMember() throws JavaModelException {
        IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
        if (element == null || !(element instanceof IMember)) {
            return null;
        }
        return (IMember)element;
    }

    private void startRefactoring(IMember[] members) throws JavaModelException {
        MoveRefactoring refactoring = MoveStaticMembersAction.createNewRefactoringInstance(members);
        Assert.isNotNull(refactoring);
        if (!ActionUtil.isProcessable(this.getShell(), MoveStaticMembersAction.getSourceCompilationUnit(refactoring))) {
            return;
        }
        new RefactoringStarter().activate((Refactoring)refactoring, MoveStaticMembersAction.createWizard(refactoring), this.getShell(), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), true);
    }

    private static MoveRefactoring createNewRefactoringInstance(Object[] elements) throws JavaModelException {
        HashSet<Object> memberSet = new HashSet<Object>();
        memberSet.addAll(Arrays.asList(elements));
        IMember[] methods = memberSet.toArray(new IMember[memberSet.size()]);
        return new MoveRefactoring((MoveProcessor)MoveStaticMembersProcessor.create(methods, JavaPreferencesSettings.getCodeGenerationSettings()));
    }

    private static RefactoringWizard createWizard(MoveRefactoring refactoring) {
        return new MoveMembersWizard(refactoring);
    }

    private static ICompilationUnit getSourceCompilationUnit(MoveRefactoring refactoring) {
        return ((MoveStaticMembersProcessor)((Object)refactoring.getAdapter(class$org$eclipse$jdt$internal$corext$refactoring$structure$MoveStaticMembersProcessor == null ? (class$org$eclipse$jdt$internal$corext$refactoring$structure$MoveStaticMembersProcessor = MoveStaticMembersAction.class$("org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMembersProcessor")) : class$org$eclipse$jdt$internal$corext$refactoring$structure$MoveStaticMembersProcessor))).getMembersToMove()[0].getCompilationUnit();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

