/*
 * Decompiled with CFR 0.152.
 */
package com.grack.nanojson;

import com.grack.nanojson.JsonArray;
import com.grack.nanojson.JsonLazyNumber;
import com.grack.nanojson.JsonObject;
import com.grack.nanojson.JsonParserException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;

public final class JsonParser {
    private static final int BUFFER_ROOM = 20;
    static final int BUFFER_SIZE = 32768;
    private int linePos = 1;
    private int rowPos;
    private int charOffset;
    private int utf8adjust;
    private int tokenLinePos;
    private int tokenCharPos;
    private int tokenCharOffset;
    private Object value;
    private Token token;
    private StringBuilder reusableBuffer = new StringBuilder();
    private boolean eof;
    private int index;
    private final Reader reader;
    private final char[] buffer;
    private int bufferLength;
    private static final char[] TRUE = new char[]{'r', 'u', 'e'};
    private static final char[] FALSE = new char[]{'a', 'l', 's', 'e'};
    private static final char[] NULL = new char[]{'u', 'l', 'l'};
    private final boolean utf8;
    private boolean lazyNumbers;

    JsonParser(boolean bl, boolean bl2, Reader reader) throws JsonParserException {
        this.utf8 = bl;
        this.lazyNumbers = bl2;
        this.reader = reader;
        this.buffer = new char[32768];
        this.eof = this.refillBuffer();
    }

    public static JsonParserContext<JsonObject> object() {
        return new JsonParserContext<JsonObject>(JsonObject.class);
    }

    public static JsonParserContext<JsonArray> array() {
        return new JsonParserContext<JsonArray>(JsonArray.class);
    }

    public static JsonParserContext<Object> any() {
        return new JsonParserContext<Object>(Object.class);
    }

    <T> T parse(Class<T> clazz) throws JsonParserException {
        this.advanceToken();
        Object object = this.currentValue();
        if (this.advanceToken() != Token.EOF) {
            throw this.createParseException(null, "Expected end of input, got " + (Object)((Object)this.token), true);
        }
        if (!(clazz == Object.class || object != null && clazz.isAssignableFrom(object.getClass()))) {
            throw this.createParseException(null, "JSON did not contain the correct type, expected " + clazz.getSimpleName() + ".", true);
        }
        return clazz.cast(object);
    }

    private Object currentValue() throws JsonParserException {
        if (this.token.isValue) {
            return this.value;
        }
        throw this.createParseException(null, "Expected JSON value, got " + (Object)((Object)this.token), true);
    }

    /*
     * Unable to fully structure code
     */
    private Token advanceToken() throws JsonParserException {
        var1_1 = this.advanceChar();
        while (this.isWhitespace(var1_1)) {
            var1_1 = this.advanceChar();
        }
        this.tokenLinePos = this.linePos;
        this.tokenCharPos = this.index + this.charOffset - this.rowPos - this.utf8adjust;
        this.tokenCharOffset = this.charOffset + this.index;
        switch (var1_1) {
            case -1: {
                this.token = Token.EOF;
                return this.token;
            }
            case 91: {
                var2_2 = new JsonArray();
                if (this.advanceToken() == Token.ARRAY_END) ** GOTO lbl23
                do {
                    var2_2.add(this.currentValue());
                    if (this.advanceToken() == Token.ARRAY_END) ** GOTO lbl23
                    if (this.token == Token.COMMA) continue;
                    throw this.createParseException(null, "Expected a comma or end of the array instead of " + (Object)this.token, true);
                } while (this.advanceToken() != Token.ARRAY_END);
                throw this.createParseException(null, "Trailing comma found in array", true);
lbl23:
                // 2 sources

                this.value = var2_2;
                this.token = Token.ARRAY_START;
                return this.token;
            }
            case 93: {
                this.token = Token.ARRAY_END;
                return this.token;
            }
            case 44: {
                this.token = Token.COMMA;
                return this.token;
            }
            case 58: {
                this.token = Token.COLON;
                return this.token;
            }
            case 123: {
                var3_3 = new JsonObject();
                if (this.advanceToken() == Token.OBJECT_END) ** GOTO lbl53
                do {
                    if (this.token != Token.STRING) {
                        throw this.createParseException(null, "Expected STRING, got " + (Object)this.token, true);
                    }
                    var4_4 = (String)this.value;
                    if (this.advanceToken() != Token.COLON) {
                        throw this.createParseException(null, "Expected COLON, got " + (Object)this.token, true);
                    }
                    this.advanceToken();
                    var3_3.put(var4_4, this.currentValue());
                    if (this.advanceToken() == Token.OBJECT_END) ** GOTO lbl53
                    if (this.token == Token.COMMA) continue;
                    throw this.createParseException(null, "Expected a comma or end of the object instead of " + (Object)this.token, true);
                } while (this.advanceToken() != Token.OBJECT_END);
                throw this.createParseException(null, "Trailing object found in array", true);
lbl53:
                // 2 sources

                this.value = var3_3;
                this.token = Token.OBJECT_START;
                return this.token;
            }
            case 125: {
                this.token = Token.OBJECT_END;
                return this.token;
            }
            case 116: {
                this.consumeKeyword((char)var1_1, JsonParser.TRUE);
                this.value = Boolean.TRUE;
                this.token = Token.TRUE;
                return this.token;
            }
            case 102: {
                this.consumeKeyword((char)var1_1, JsonParser.FALSE);
                this.value = Boolean.FALSE;
                this.token = Token.FALSE;
                return this.token;
            }
            case 110: {
                this.consumeKeyword((char)var1_1, JsonParser.NULL);
                this.value = null;
                this.token = Token.NULL;
                return this.token;
            }
            case 34: {
                this.value = this.consumeTokenString();
                this.token = Token.STRING;
                return this.token;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.value = this.consumeTokenNumber((char)var1_1);
                this.token = Token.NUMBER;
                return this.token;
            }
            case 43: 
            case 46: {
                throw this.createParseException(null, "Numbers may not start with '" + (char)var1_1 + "'", true);
            }
        }
        if (this.isAsciiLetter(var1_1)) {
            throw this.createHelpfulException((char)var1_1, null, 0);
        }
        throw this.createParseException(null, "Unexpected character: " + (char)var1_1, true);
    }

    private void consumeKeyword(char c, char[] cArray) throws JsonParserException {
        if (this.ensureBuffer(cArray.length) < cArray.length) {
            throw this.createHelpfulException(c, cArray, 0);
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (this.buffer[this.index++] == cArray[i]) continue;
            throw this.createHelpfulException(c, cArray, i);
        }
        this.fixupAfterRawBufferRead();
        if (this.isAsciiLetter(this.peekChar())) {
            throw this.createHelpfulException(c, cArray, cArray.length);
        }
    }

    private Number consumeTokenNumber(char c) throws JsonParserException {
        int n;
        int n2;
        int n3;
        this.reusableBuffer.setLength(0);
        this.reusableBuffer.append(c);
        boolean bl = false;
        block2: while ((n3 = this.ensureBuffer(20)) != 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                n = this.buffer[this.index];
                if (!this.isDigitCharacter(n)) break block2;
                bl |= n == 46 || n == 101 || n == 69;
                this.reusableBuffer.append((char)n);
                ++this.index;
            }
        }
        this.fixupAfterRawBufferRead();
        String string = this.reusableBuffer.toString();
        try {
            if (bl) {
                if (string.charAt(0) == '0' && (string.charAt(1) == '.' ? string.length() == 2 : string.charAt(1) != 'e' && string.charAt(1) != 'E')) {
                    throw this.createParseException(null, "Malformed number: " + string, true);
                }
                if (string.charAt(0) == '-' && (string.charAt(1) == '0' ? (string.charAt(2) == '.' ? string.length() == 3 : string.charAt(2) != 'e' && string.charAt(2) != 'E') : string.charAt(1) == '.')) {
                    throw this.createParseException(null, "Malformed number: " + string, true);
                }
                return this.lazyNumbers ? new JsonLazyNumber(string) : Double.valueOf(Double.parseDouble(string));
            }
            if (string.charAt(0) == '0') {
                if (string.length() == 1) {
                    return 0;
                }
                throw this.createParseException(null, "Malformed number: " + string, true);
            }
            if (string.length() > 1 && string.charAt(0) == '-' && string.charAt(1) == '0') {
                if (string.length() == 2) {
                    return -0.0;
                }
                throw this.createParseException(null, "Malformed number: " + string, true);
            }
            if (this.lazyNumbers) {
                return new JsonLazyNumber(string);
            }
            n2 = string.charAt(0) == '-' ? 1 : 0;
            int n4 = n = n2 != 0 ? string.length() - 1 : string.length();
            if (n < 10 || n == 10 && string.charAt(n2 != 0 ? 1 : 0) < '2') {
                return Integer.parseInt(string);
            }
            if (n < 19 || n == 19 && string.charAt(n2 != 0 ? 1 : 0) < '9') {
                return Long.parseLong(string);
            }
            return new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.createParseException(numberFormatException, "Malformed number: " + string, true);
        }
    }

    private String consumeTokenString() throws JsonParserException {
        this.reusableBuffer.setLength(0);
        while (true) {
            if (this.ensureBuffer(20) == 0) {
                throw this.createParseException(null, "String was not terminated before end of input", true);
            }
            char c = this.stringChar();
            if (this.utf8 && (c & 0x80) != 0) {
                this.consumeTokenStringUtf8Char(c);
                continue;
            }
            block0 : switch (c) {
                case '\"': {
                    this.fixupAfterRawBufferRead();
                    return this.reusableBuffer.toString();
                }
                case '\\': {
                    char c2 = this.buffer[this.index++];
                    switch (c2) {
                        case 'b': {
                            this.reusableBuffer.append('\b');
                            break block0;
                        }
                        case 'f': {
                            this.reusableBuffer.append('\f');
                            break block0;
                        }
                        case 'n': {
                            this.reusableBuffer.append('\n');
                            break block0;
                        }
                        case 'r': {
                            this.reusableBuffer.append('\r');
                            break block0;
                        }
                        case 't': {
                            this.reusableBuffer.append('\t');
                            break block0;
                        }
                        case '\"': 
                        case '/': 
                        case '\\': {
                            this.reusableBuffer.append(c2);
                            break block0;
                        }
                        case 'u': {
                            int n = 0;
                            for (int i = 0; i < 4; ++i) {
                                char c3;
                                n <<= 4;
                                if ((c3 = this.buffer[this.index++]) >= '0' && c3 <= '9') {
                                    n |= c3 - 48;
                                    continue;
                                }
                                if (c3 >= 'A' && c3 <= 'F') {
                                    n |= c3 - 65 + 10;
                                    continue;
                                }
                                if (c3 >= 'a' && c3 <= 'f') {
                                    n |= c3 - 97 + 10;
                                    continue;
                                }
                                throw this.createParseException(null, "Expected unicode hex escape character: " + (char)c3 + " (" + c3 + ")", false);
                            }
                            this.reusableBuffer.append((char)n);
                            break block0;
                        }
                    }
                    throw this.createParseException(null, "Invalid escape: \\" + c2, false);
                }
                default: {
                    this.reusableBuffer.append(c);
                }
            }
            if (this.index > this.bufferLength) break;
        }
        this.index = this.bufferLength;
        throw this.createParseException(null, "EOF encountered in the middle of a string escape", false);
    }

    private void consumeTokenStringUtf8Char(char c) throws JsonParserException {
        this.ensureBuffer(5);
        block0 : switch (c & 0xF0) {
            case 128: 
            case 144: 
            case 160: 
            case 176: {
                throw this.createParseException(null, "Illegal UTF-8 continuation byte: 0x" + Integer.toHexString(c & 0xFF), false);
            }
            case 192: {
                if ((c & 0xE) == 0) {
                    throw this.createParseException(null, "Illegal UTF-8 byte: 0x" + Integer.toHexString(c & 0xFF), false);
                }
            }
            case 208: {
                c = (char)((c & 0x1F) << 6 | this.buffer[this.index++] & 0x3F);
                this.reusableBuffer.append(c);
                ++this.utf8adjust;
                break;
            }
            case 224: {
                c = (char)((c & 0xF) << 12 | (this.buffer[this.index++] & 0x3F) << 6 | this.buffer[this.index++] & 0x3F);
                this.reusableBuffer.append(c);
                this.utf8adjust += 2;
                break;
            }
            case 240: {
                if ((c & 0xF) >= 5) {
                    throw this.createParseException(null, "Illegal UTF-8 byte: 0x" + Integer.toHexString(c & 0xFF), false);
                }
                switch ((c & 0xC) >> 2) {
                    case 0: 
                    case 1: {
                        this.reusableBuffer.appendCodePoint((c & 7) << 18 | (this.buffer[this.index++] & 0x3F) << 12 | (this.buffer[this.index++] & 0x3F) << 6 | this.buffer[this.index++] & 0x3F);
                        this.utf8adjust += 3;
                        break block0;
                    }
                    case 2: {
                        int n = (c & 3) << 24 | (this.buffer[this.index++] & 0x3F) << 18 | (this.buffer[this.index++] & 0x3F) << 12 | (this.buffer[this.index++] & 0x3F) << 6 | this.buffer[this.index++] & 0x3F;
                        throw this.createParseException(null, "Unable to represent codepoint 0x" + Integer.toHexString(n) + " in a Java string", false);
                    }
                    case 3: {
                        int n = (c & '\u0001') << 30 | (this.buffer[this.index++] & 0x3F) << 24 | (this.buffer[this.index++] & 0x3F) << 18 | (this.buffer[this.index++] & 0x3F) << 12 | (this.buffer[this.index++] & 0x3F) << 6 | this.buffer[this.index++] & 0x3F;
                        throw this.createParseException(null, "Unable to represent codepoint 0x" + Integer.toHexString(n) + " in a Java string", false);
                    }
                }
                assert (false) : "Impossible";
                break;
            }
        }
        if (this.index > this.bufferLength) {
            throw this.createParseException(null, "UTF-8 codepoint was truncated", false);
        }
    }

    private char stringChar() throws JsonParserException {
        char c;
        if ((c = this.buffer[this.index++]) < ' ') {
            if (c == '\n') {
                ++this.linePos;
                this.rowPos = this.index + 1 + this.charOffset;
                this.utf8adjust = 0;
            }
            throw this.createParseException(null, "Strings may not contain control characters: 0x" + Integer.toString(c, 16), false);
        }
        return c;
    }

    private boolean isDigitCharacter(int n) {
        return n >= 48 && n <= 57 || n == 101 || n == 69 || n == 46 || n == 43 || n == 45;
    }

    private boolean isWhitespace(int n) {
        return n == 32 || n == 10 || n == 13 || n == 9;
    }

    private boolean isAsciiLetter(int n) {
        return n >= 65 && n <= 90 || n >= 97 && n <= 122;
    }

    private boolean refillBuffer() throws JsonParserException {
        try {
            int n = this.reader.read(this.buffer, 0, this.buffer.length);
            if (n <= 0) {
                return true;
            }
            this.charOffset += this.bufferLength;
            this.index = 0;
            this.bufferLength = n;
            return false;
        }
        catch (IOException iOException) {
            throw this.createParseException(iOException, "IOException", true);
        }
    }

    private int peekChar() {
        return this.eof ? -1 : this.buffer[this.index];
    }

    private int ensureBuffer(int n) throws JsonParserException {
        if (this.bufferLength - n >= this.index) {
            return n;
        }
        this.charOffset += this.index;
        this.bufferLength -= this.index;
        System.arraycopy(this.buffer, this.index, this.buffer, 0, this.bufferLength);
        this.index = 0;
        try {
            while (this.buffer.length > this.bufferLength) {
                int n2 = this.reader.read(this.buffer, this.bufferLength, this.buffer.length - this.bufferLength);
                if (n2 <= 0) {
                    return this.bufferLength - this.index;
                }
                this.bufferLength += n2;
                if (this.bufferLength <= n) continue;
                return this.bufferLength - this.index;
            }
            assert (false) : "Unexpected internal error";
            throw new IOException("Unexpected internal error");
        }
        catch (IOException iOException) {
            throw this.createParseException(iOException, "IOException", true);
        }
    }

    private int advanceChar() throws JsonParserException {
        if (this.eof) {
            return -1;
        }
        char c = this.buffer[this.index];
        if (c == '\n') {
            ++this.linePos;
            this.rowPos = this.index + 1 + this.charOffset;
            this.utf8adjust = 0;
        }
        ++this.index;
        if (this.index >= this.bufferLength) {
            this.eof = this.refillBuffer();
        }
        return c;
    }

    private void fixupAfterRawBufferRead() throws JsonParserException {
        if (this.index >= this.bufferLength) {
            this.eof = this.refillBuffer();
        }
    }

    private JsonParserException createHelpfulException(char c, char[] cArray, int n) throws JsonParserException {
        StringBuilder stringBuilder = new StringBuilder(c + (cArray == null ? "" : new String(cArray, 0, n)));
        while (this.isAsciiLetter(this.peekChar()) && stringBuilder.length() < 15) {
            stringBuilder.append((char)this.advanceChar());
        }
        return this.createParseException(null, "Unexpected token '" + stringBuilder + "'" + (cArray == null ? "" : ". Did you mean '" + c + new String(cArray) + "'?"), true);
    }

    private JsonParserException createParseException(Exception exception, String string, boolean bl) {
        if (bl) {
            return new JsonParserException(exception, string + " on line " + this.tokenLinePos + ", char " + this.tokenCharPos, this.tokenLinePos, this.tokenCharPos, this.tokenCharOffset);
        }
        int n = Math.max(1, this.index + this.charOffset - this.rowPos - this.utf8adjust);
        return new JsonParserException(exception, string + " on line " + this.linePos + ", char " + n, this.linePos, n, this.index + this.charOffset);
    }

    public static final class JsonParserContext<T> {
        private final Class<T> clazz;
        private boolean lazyNumbers;

        JsonParserContext(Class<T> clazz) {
            this.clazz = clazz;
        }

        public JsonParserContext<T> withLazyNumbers() {
            this.lazyNumbers = true;
            return this;
        }

        public T from(String string) throws JsonParserException {
            return new JsonParser(false, this.lazyNumbers, new StringReader(string)).parse(this.clazz);
        }

        public T from(Reader reader) throws JsonParserException {
            return new JsonParser(false, this.lazyNumbers, reader).parse(this.clazz);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public T from(URL uRL) throws JsonParserException {
            try {
                InputStream inputStream = uRL.openStream();
                try {
                    T t = this.from(inputStream);
                    return t;
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new JsonParserException(iOException, "IOException opening URL", 1, 1, 0);
            }
        }

        public T from(InputStream inputStream) throws JsonParserException {
            BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
            bufferedInputStream.mark(4);
            try {
                Charset charset;
                int[] nArray = new int[]{bufferedInputStream.read(), bufferedInputStream.read(), bufferedInputStream.read(), bufferedInputStream.read()};
                if (nArray[0] == 239 && nArray[1] == 187 && nArray[2] == 191) {
                    bufferedInputStream.reset();
                    bufferedInputStream.read();
                    bufferedInputStream.read();
                    bufferedInputStream.read();
                    return new JsonParser(true, this.lazyNumbers, new PseudoUtf8Reader(bufferedInputStream)).parse(this.clazz);
                }
                if (nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 254 && nArray[3] == 255) {
                    charset = Charset.forName("UTF-32BE");
                } else if (nArray[0] == 255 && nArray[1] == 254 && nArray[2] == 0 && nArray[3] == 0) {
                    charset = Charset.forName("UTF-32LE");
                } else if (nArray[0] == 254 && nArray[1] == 255) {
                    charset = Charset.forName("UTF-16BE");
                    bufferedInputStream.reset();
                    bufferedInputStream.read();
                    bufferedInputStream.read();
                } else if (nArray[0] == 255 && nArray[1] == 254) {
                    charset = Charset.forName("UTF-16LE");
                    bufferedInputStream.reset();
                    bufferedInputStream.read();
                    bufferedInputStream.read();
                } else if (nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 0 && nArray[3] != 0) {
                    charset = Charset.forName("UTF-32BE");
                    bufferedInputStream.reset();
                } else if (nArray[0] != 0 && nArray[1] == 0 && nArray[2] == 0 && nArray[3] == 0) {
                    charset = Charset.forName("UTF-32LE");
                    bufferedInputStream.reset();
                } else if (nArray[0] == 0 && nArray[1] != 0 && nArray[2] == 0 && nArray[3] != 0) {
                    charset = Charset.forName("UTF-16BE");
                    bufferedInputStream.reset();
                } else if (nArray[0] != 0 && nArray[1] == 0 && nArray[2] != 0 && nArray[3] == 0) {
                    charset = Charset.forName("UTF-16LE");
                    bufferedInputStream.reset();
                } else {
                    bufferedInputStream.reset();
                    return new JsonParser(true, this.lazyNumbers, new PseudoUtf8Reader(bufferedInputStream)).parse(this.clazz);
                }
                return new JsonParser(false, this.lazyNumbers, new InputStreamReader((InputStream)bufferedInputStream, charset)).parse(this.clazz);
            }
            catch (IOException iOException) {
                throw new JsonParserException(iOException, "IOException while detecting charset", 1, 1, 0);
            }
        }
    }

    private static final class PseudoUtf8Reader
    extends Reader {
        private final BufferedInputStream buffered;
        private byte[] buf = new byte[32768];

        PseudoUtf8Reader(BufferedInputStream bufferedInputStream) {
            this.buffered = bufferedInputStream;
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = this.buffered.read(this.buf, n, n2);
            for (int i = n; i < n + n3; ++i) {
                cArray[i] = (char)this.buf[i];
            }
            return n3;
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static enum Token {
        EOF(false),
        NULL(true),
        TRUE(true),
        FALSE(true),
        STRING(true),
        NUMBER(true),
        COMMA(false),
        COLON(false),
        OBJECT_START(true),
        OBJECT_END(false),
        ARRAY_START(true),
        ARRAY_END(false);

        public boolean isValue;

        private Token(boolean bl) {
            this.isValue = bl;
        }
    }
}

