/*
 * Decompiled with CFR 0.152.
 */
package com.bfo.json;

import com.bfo.json.CharSequenceReader;
import com.bfo.json.Core;
import com.bfo.json.IBoolean;
import com.bfo.json.IList;
import com.bfo.json.IMap;
import com.bfo.json.INull;
import com.bfo.json.INumber;
import com.bfo.json.IString;
import com.bfo.json.JsonEvent;
import com.bfo.json.JsonFactory;
import com.bfo.json.JsonListener;
import com.bfo.json.JsonPathProviderBFO;
import com.bfo.json.JsonReadOptions;
import com.bfo.json.JsonReader;
import com.bfo.json.JsonWriteOptions;
import com.bfo.json.SerializerState;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Json {
    private static final JsonWriteOptions DEFAULTWRITEOPTIONS = new JsonWriteOptions();
    private static final JsonReadOptions DEFAULTREADOPTIONS = new JsonReadOptions();
    private Core core;
    private Json parent;
    private Object parentkey;
    private List<JsonListener> listeners;
    private static final Object DOT = new Object(){

        public String toString() {
            return ".";
        }
    };
    private static final Object LB = new Object(){

        public String toString() {
            return "[";
        }
    };
    private static final Object RB = new Object(){

        public String toString() {
            return "]";
        }
    };

    public Json(Object object) {
        this(object, null);
    }

    public Json(Object object, JsonFactory factory) {
        if (object == null) {
            this.core = INull.INSTANCE;
        } else if (object instanceof Core) {
            this.core = (Core)object;
        } else if (object instanceof Json) {
            this.core = ((Json)object).core;
        } else {
            Json json;
            if (factory != null && (json = factory.toJson(object)) != null) {
                this.core = json.core;
            }
            if (this.core == null) {
                if (object instanceof CharSequence) {
                    this.core = new IString(object.toString(), 0);
                } else if (object instanceof Boolean) {
                    this.core = new IBoolean((Boolean)object, 0);
                } else if (object instanceof Number) {
                    this.core = new INumber((Number)object, 0);
                } else if (object instanceof Map) {
                    this.core = new IMap();
                    Map map = (Map)object;
                    for (Map.Entry e : map.entrySet()) {
                        String key = e.getKey().toString();
                        Json value = new Json(e.getValue(), factory);
                        ((IMap)this.core).put(key, value);
                    }
                } else if (object instanceof Collection) {
                    this.core = new IList();
                    Collection list = (Collection)object;
                    for (Object o : list) {
                        Json value = new Json(o, factory);
                        ((IList)this.core).add(value);
                    }
                }
            }
        }
        if (this.core == null) {
            throw new IllegalArgumentException(object.getClass().getName());
        }
    }

    Core getCore() {
        return this.core;
    }

    private void setCore(Core core) {
        this.core = core;
    }

    public static Json read(CharSequence in) {
        if (in == null) {
            throw new IllegalArgumentException("Can't read from a null string");
        }
        if (in.length() == 0) {
            throw new IllegalArgumentException("Can't read from an empty string");
        }
        if (in.length() == 2 && in.toString().equals("{}")) {
            return new Json(new IMap());
        }
        if (in.length() == 2 && in.toString().equals("[]")) {
            return new Json(new IList());
        }
        try {
            return Json.read(new CharSequenceReader(in), DEFAULTREADOPTIONS);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Json read(InputStream in, JsonReadOptions options) throws IOException {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        in.mark(3);
        int v = in.read();
        if (v < 0) {
            throw new EOFException("Empty file");
        }
        if (v == 239) {
            v = in.read();
            if (v == 187) {
                v = in.read();
                if (v == 191) {
                    return Json.read(new InputStreamReader(in, "UTF-8"), options);
                }
                throw new IOException("Invalid Json (begins with 0xEF 0xBB 0x" + Integer.toHexString(v));
            }
            throw new IOException("Invalid Json (begins with 0xEF 0x" + Integer.toHexString(v));
        }
        if (v == 254) {
            v = in.read();
            if (v == 255) {
                return Json.read(new InputStreamReader(in, "UTF-16BE"), options);
            }
            throw new IOException("Invalid Json (begins with 0xFE 0x" + Integer.toHexString(v));
        }
        if (v == 255) {
            v = in.read();
            if (v == 254) {
                return Json.read(new InputStreamReader(in, "UTF-16LE"), options);
            }
            throw new IOException("Invalid Json (begins with 0xFF 0x" + Integer.toHexString(v));
        }
        if (v == 0) {
            v = in.read();
            if (v >= 32) {
                in.reset();
                return Json.read(new InputStreamReader(in, "UTF-16BE"), options);
            }
            throw new IOException("Invalid Json (begins with 0x0 0x" + Integer.toHexString(v));
        }
        int v2 = in.read();
        if (v2 == 0) {
            in.reset();
            return Json.read(new InputStreamReader(in, "UTF-16LE"), options);
        }
        in.reset();
        return Json.read(new InputStreamReader(in, "UTF-8"), options);
    }

    public static Json read(Reader in, JsonReadOptions options) throws IOException {
        if (options == null) {
            options = DEFAULTREADOPTIONS;
        }
        if (!in.markSupported()) {
            in = new BufferedReader(in);
        }
        return (Json)JsonReader.read(in, options);
    }

    public Json addListener(JsonListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<JsonListener>();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        return this;
    }

    public Json removeListener(JsonListener listener) {
        if (this.listeners != null && this.listeners.remove(listener) && this.listeners.isEmpty()) {
            this.listeners = null;
        }
        return this;
    }

    public Collection<JsonListener> getListeners() {
        return this.listeners == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.listeners);
    }

    protected void fireEvent(JsonEvent event) {
        Json j = this;
        do {
            if (j.listeners == null) continue;
            for (JsonListener l : j.listeners) {
                l.jsonEvent(j, event);
            }
        } while ((j = j.parent) != null);
    }

    public Appendable write(Appendable out, JsonWriteOptions options) throws IOException {
        if (options == null) {
            options = DEFAULTWRITEOPTIONS;
        }
        SerializerState state = new SerializerState(this, options);
        this.core.write(out, state);
        if (out instanceof Flushable) {
            ((Flushable)((Object)out)).flush();
        }
        return out;
    }

    public Json duplicate() {
        Json json;
        if (this.isMap()) {
            json = new Json(new IMap());
            Map<String, Json> om = json._mapValue();
            for (Map.Entry<String, Json> e : this._mapValue().entrySet()) {
                om.put(e.getKey(), e.getValue().duplicate());
            }
        } else if (this.isList()) {
            json = new Json(new IList());
            List<Json> il = this._listValue();
            List<Json> ol = json._listValue();
            for (int i = 0; i < il.size(); ++i) {
                ol.add(il.get(i).duplicate());
            }
        } else {
            json = new Json(this.core);
        }
        return json;
    }

    public Json parent() {
        return this.parent;
    }

    Object getParentKey() {
        return this.parentkey;
    }

    static void notify(Json parent, Object parentkey, Json oldvalue, Json newvalue) {
        if (newvalue == null) {
            oldvalue.fireEvent(new JsonEvent(oldvalue, null));
            oldvalue.parent = null;
            oldvalue.parentkey = null;
        } else {
            if (oldvalue != null) {
                oldvalue.parent = null;
                oldvalue.parentkey = null;
            }
            newvalue.parent = parent;
            newvalue.parentkey = parentkey;
            newvalue.fireEvent(new JsonEvent(oldvalue, newvalue));
        }
    }

    public String find(Json descendant) {
        if (descendant == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (descendant.getPath(sb, this)) {
            return sb.toString();
        }
        return null;
    }

    private boolean getPath(StringBuilder sb, Json to) {
        if (this == to) {
            return true;
        }
        if (this.parent != null && this.parent.getPath(sb, to)) {
            boolean stringok = false;
            if (this.parentkey instanceof String) {
                String pk = (String)this.parentkey;
                stringok = true;
                for (int i = 0; i < pk.length(); ++i) {
                    char c = pk.charAt(i);
                    if (Character.isAlphabetic(c) || c == '_' || c >= '0' && c <= '9' && i > 0) continue;
                    stringok = false;
                    break;
                }
                if (stringok) {
                    if (sb.length() > 0) {
                        sb.append('.');
                    }
                    sb.append(this.parentkey);
                } else {
                    sb.append("[");
                    try {
                        IString.write(pk, sb);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    sb.append("]");
                }
            } else {
                sb.append('[');
                sb.append(this.parentkey);
                sb.append(']');
            }
            return true;
        }
        return false;
    }

    public Json put(String path, Object value) {
        Json object;
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (value instanceof Json) {
            object = (Json)value;
            Json t = this;
            while (t != null) {
                if (t == value) {
                    throw new IllegalArgumentException("value is this or an ancestor");
                }
                t = t.parent;
            }
        } else {
            object = new Json(value);
        }
        boolean convert = true;
        if (this.core instanceof IList) {
            try {
                convert = !Character.isDigit(path.charAt(0)) || Integer.parseInt(path) < 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (convert) {
            this.convertToMap();
        }
        if (path.length() >= 2 && path.charAt(0) == '\"' && path.charAt(path.length() - 1) == '\"' && this.core instanceof IMap) {
            path = Json.readQuotedPath(path);
            Map<String, Json> m = this._mapValue();
            Json oldvalue = m.get(path);
            m.put(path, object);
            Json.notify(this, path, oldvalue, object);
            return oldvalue;
        }
        return this.traverse(path, object);
    }

    private static String readQuotedPath(String path) {
        return path.substring(1, path.length() - 1);
    }

    public Json put(int path, Object value) {
        if (this.core instanceof IList && path >= 0) {
            Json object;
            if (value == null) {
                throw new IllegalArgumentException("value is null");
            }
            if (value instanceof Json) {
                object = (Json)value;
                Json t = this;
                while (t != null) {
                    if (t == value) {
                        throw new IllegalArgumentException("value is this or an ancestor");
                    }
                    t = t.parent;
                }
            } else {
                object = new Json(value);
            }
            return Json.buildlist(path, (IList)this.core, this, object);
        }
        this.convertToMap();
        return this.put(Integer.toString(path), value);
    }

    public Json remove(String path) {
        Json json = this.traverse(path, null);
        if (json != null) {
            boolean removed = false;
            Json parent = json.parent();
            if (parent != null) {
                if (parent.isList()) {
                    int ix = (Integer)json.getParentKey();
                    IList list = (IList)parent.core;
                    Json oldvalue = list.get(ix);
                    Json.notify(parent, ix, oldvalue, null);
                    list.remove(ix);
                    removed = true;
                } else if (parent.isMap()) {
                    IMap map = (IMap)parent.core;
                    String key = (String)json.getParentKey();
                    Json oldvalue = map.get(key);
                    Json.notify(parent, key, oldvalue, null);
                    map.remove(key);
                    boolean bl = true;
                }
            }
        }
        return json;
    }

    public Json remove(Json json) {
        block3: {
            block2: {
                if (!this.isList()) break block2;
                IList list = (IList)this.core;
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i) != json) continue;
                    Json.notify(this, i, json, null);
                    list.remove(i);
                    return json;
                }
                break block3;
            }
            if (!this.isMap()) break block3;
            IMap map = (IMap)this.core;
            Iterator<Map.Entry<String, Json>> i = map.mapValue().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, Json> e = i.next();
                if (e.getValue() != json) continue;
                Json.notify(this, e.getKey(), json, null);
                i.remove();
                return json;
            }
        }
        return null;
    }

    public Json remove(int path) {
        if (this.isList()) {
            return ((IList)this.core).remove(path);
        }
        if (this.isMap()) {
            return ((IMap)this.core).remove(Integer.toString(path));
        }
        return null;
    }

    public boolean has(String path) {
        if (this.isList() || this.isMap()) {
            boolean full = false;
            if (path.length() >= 2 && path.charAt(0) == '\"' && path.charAt(path.length() - 1) == '\"') {
                path = Json.readQuotedPath(path);
            } else {
                for (int i = 0; i < path.length(); ++i) {
                    char c = path.charAt(i);
                    if (c != '.' && c != '[' && c != ']') continue;
                    full = true;
                    break;
                }
            }
            Json json = null;
            if (full) {
                json = this.traverse(path, null);
            } else if (this.isMap()) {
                json = this._mapValue().get(path);
            } else if (this.isList()) {
                try {
                    int ix = Integer.parseInt(path);
                    json = ((IList)this.core).get(ix);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return json != null && !json.isNull();
        }
        return false;
    }

    public boolean has(int path) {
        if (this.isList()) {
            Json j = ((IList)this.core).remove(path);
            return j != null && !j.isNull();
        }
        if (this.isMap()) {
            Json j = ((IMap)this.core).get(Integer.toString(path));
            return j != null && !j.isNull();
        }
        return false;
    }

    public Json get(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        if (this.isList() || this.isMap()) {
            boolean full = false;
            if (path.length() >= 2 && path.charAt(0) == '\"' && path.charAt(path.length() - 1) == '\"') {
                path = Json.readQuotedPath(path);
            } else {
                for (int i = 0; i < path.length(); ++i) {
                    char c = path.charAt(i);
                    if (c != '.' && c != '[' && c != ']') continue;
                    full = true;
                    break;
                }
            }
            if (full) {
                return this.traverse(path, null);
            }
            if (this.isMap()) {
                return ((IMap)this.core).get(path);
            }
            if (this.isList()) {
                try {
                    int ix = Integer.parseInt(path);
                    return ((IList)this.core).get(ix);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public Json get(int path) {
        if (this.isList()) {
            return ((IList)this.core).get(path);
        }
        if (this.isMap()) {
            return ((IMap)this.core).get(Integer.toString(path));
        }
        return null;
    }

    public int size() {
        if (this.isList()) {
            return ((IList)this.core).size();
        }
        if (this.isMap()) {
            return ((IMap)this.core).size();
        }
        return 0;
    }

    public boolean isEmpty() {
        if (this.isMap()) {
            return ((IMap)this.core).size() == 0;
        }
        if (this.isList()) {
            return ((IList)this.core).size() == 0;
        }
        return true;
    }

    public Iterator<Map.Entry<String, Json>> leafIterator() {
        if (!this.isMap() && !this.isList()) {
            return Collections.emptyIterator();
        }
        return new Iterator<Map.Entry<String, Json>>(){
            List<Iterator> stack = new ArrayList<Iterator>();
            List<Object> string = new ArrayList<Object>();
            Json last = Json.this;
            {
                if (Json.this.isMap()) {
                    this.stack.add(Json.this._mapValue().entrySet().iterator());
                } else {
                    this.stack.add(Json.this._listValue().listIterator());
                }
                this.string.add(null);
            }

            private boolean hasDown() {
                boolean ret = this.last != null && (this.last.isMap() || this.last.isList());
                return ret;
            }

            private boolean hasUp() {
                boolean ret = !this.stack.isEmpty();
                return ret;
            }

            private boolean hasAcross() {
                boolean ret = !this.stack.isEmpty() && this.stack.get(this.stack.size() - 1).hasNext();
                return ret;
            }

            private void down() {
                if (this.last.isMap()) {
                    this.stack.add(this.last._mapValue().entrySet().iterator());
                    this.string.add(null);
                } else if (this.last.isList()) {
                    this.stack.add(this.last._listValue().listIterator());
                    this.string.add(null);
                } else {
                    throw new NoSuchElementException();
                }
                this.last = null;
            }

            private void up() {
                if (this.stack.isEmpty()) {
                    throw new NoSuchElementException();
                }
                this.stack.remove(this.stack.size() - 1);
                this.string.remove(this.string.size() - 1);
                this.last = null;
            }

            private void across() {
                Iterator i = this.stack.get(this.stack.size() - 1);
                if (i instanceof ListIterator) {
                    this.string.set(this.string.size() - 1, ((ListIterator)i).nextIndex());
                    this.last = (Json)i.next();
                } else {
                    Map.Entry e = (Map.Entry)i.next();
                    this.string.set(this.string.size() - 1, e.getKey());
                    this.last = (Json)e.getValue();
                }
            }

            @Override
            public boolean hasNext() {
                if (this.hasAcross()) {
                    this.across();
                    if (!this.hasDown()) {
                        return true;
                    }
                }
                while (this.hasDown()) {
                    this.down();
                }
                if (this.hasAcross()) {
                    return this.hasNext();
                }
                while (this.hasUp()) {
                    this.up();
                    if (!this.hasAcross()) continue;
                    return this.hasNext();
                }
                return false;
            }

            @Override
            public Map.Entry<String, Json> next() {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.string.size(); ++i) {
                    if (this.string.get(i) instanceof String) {
                        sb.append('.');
                        sb.append(this.string.get(i));
                        continue;
                    }
                    sb.append('[');
                    sb.append(this.string.get(i));
                    sb.append(']');
                }
                return new AbstractMap.SimpleImmutableEntry<String, Json>(sb.toString(), this.last);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void convertToMap() {
        if (!this.isMap()) {
            IMap imap = new IMap();
            if (this.core instanceof IList) {
                IList list = (IList)this.core;
                List<JsonListener> tlisteners = this.listeners;
                this.listeners = null;
                for (int i = 0; i < list.size(); ++i) {
                    Json item = list.get(i);
                    String key = Integer.toString(i);
                    imap.put(key, item);
                    item.parent = this;
                    item.parentkey = key;
                }
                this.listeners = tlisteners;
            } else if (!(this.core instanceof INull)) {
                Json.notify(this.parent, null, this, null);
            }
            this.setCore(imap);
        }
    }

    private void convertToList() {
        if (!this.isList() && !this.isMap()) {
            IList ilist = new IList();
            Json.notify(this.parent, null, this, null);
            this.setCore(ilist);
        }
    }

    private static Json buildlist(int ix, IList ilist, Json ctx, Json child) {
        Json out = null;
        while (ilist.size() < ix) {
            Json t = new Json(null);
            int s = ilist.size();
            ilist.add(t);
            Json.notify(ctx, s, null, t);
        }
        if (ix == ilist.size()) {
            if (child == null) {
                child = new Json(null);
            }
            ilist.add(child);
            Json.notify(ctx, ix, null, child);
        } else if (child != null) {
            out = ilist.set(ix, child);
            Json.notify(ctx, ix, out, child);
        }
        return out;
    }

    private Json traverse(String path, Json finalchild) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        Json output = null;
        Json ctx = this;
        Object[] stack = new Object[5];
        int lasti = 0;
        int stacklen = 0;
        stack[stacklen++] = DOT;
        int len = path.length();
        for (int i = 0; ctx != null && i <= len; ++i) {
            Json t;
            Json newctx;
            String p;
            boolean last;
            char c = i == len ? (char)'.' : (char)path.charAt(i);
            boolean bl = last = i == len || i == len - 1 && c == ']';
            if (c == '\'' || c == '\"') {
                StringBuilder sb = new StringBuilder();
                StringReader r = new StringReader(path);
                try {
                    r.skip(i + 1);
                    i += IString.parseString(c, r, sb);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (c == '.') {
                p = path.substring(lasti, i);
                if (p.length() > 0) {
                    stack[stacklen++] = p;
                }
                stack[stacklen++] = DOT;
                lasti = i + 1;
            } else if (c == '[') {
                p = path.substring(lasti, i);
                if (p.length() > 0) {
                    stack[stacklen++] = p;
                }
                stack[stacklen++] = LB;
                lasti = i + 1;
            } else {
                if (c != 93) continue;
                p = path.substring(lasti, i);
                if (p.length() > 1 && (c = p.charAt(0)) == p.charAt(p.length() - 1) && c == '\"') {
                    stack[stacklen++] = p.substring(1, p.length() - 1);
                } else if (p.length() > 0) {
                    if (Character.isDigit(p.charAt(0))) {
                        try {
                            stack[stacklen++] = Integer.valueOf(p);
                        }
                        catch (NumberFormatException e) {
                            stack[stacklen++] = p;
                        }
                    } else {
                        stack[stacklen++] = p;
                    }
                }
                stack[stacklen++] = RB;
                lasti = i + 1;
            }
            if (stack[0] == DOT && stack[1] instanceof String) {
                newctx = null;
                String key = (String)stack[1];
                if (ctx.isList()) {
                    try {
                        int ix = Integer.parseInt(key);
                        IList ilist = (IList)ctx.core;
                        if (finalchild != null) {
                            Json t2 = Json.buildlist(ix, ilist, ctx, last ? finalchild : null);
                            if (output == null) {
                                output = t2;
                            }
                        }
                        newctx = ilist.get(ix);
                    }
                    catch (NumberFormatException ix) {
                        // empty catch block
                    }
                }
                if (newctx == null) {
                    if (finalchild != null) {
                        ctx.convertToMap();
                    }
                    if (ctx.isMap()) {
                        IMap imap = (IMap)ctx.core;
                        newctx = imap.get(key);
                        if (finalchild != null && (newctx == null || last)) {
                            newctx = last ? finalchild : new Json(null);
                            t = imap.put(key, newctx);
                            if (output == null) {
                                output = t;
                            }
                            Json.notify(ctx, key, t, newctx);
                        }
                    }
                }
                ctx = newctx;
                stack[0] = stack[2];
                stack[1] = stack[3];
                stack[2] = null;
                stack[3] = null;
                stacklen -= 2;
                continue;
            }
            if (stack[0] == LB && stack[2] == RB) {
                newctx = null;
                if (stack[1] instanceof Integer) {
                    int ix = (Integer)stack[1];
                    if (finalchild != null) {
                        if (output == null) {
                            output = new Json(ctx.core);
                        }
                        ctx.convertToList();
                    }
                    if (ctx.isList()) {
                        IList ilist = (IList)ctx.core;
                        if (finalchild != null) {
                            t = Json.buildlist(ix, ilist, ctx, last ? finalchild : null);
                            if (output == null) {
                                output = t;
                            }
                        }
                        newctx = ilist.get(ix);
                    }
                }
                if (newctx == null) {
                    String key = stack[1].toString();
                    if (finalchild != null) {
                        ctx.convertToMap();
                    }
                    if (ctx.isMap()) {
                        IMap imap = (IMap)ctx.core;
                        newctx = imap.get(key);
                        if (finalchild != null && (newctx == null || last)) {
                            newctx = last ? finalchild : new Json(null);
                            t = imap.put(key, newctx);
                            if (output == null) {
                                output = t;
                            }
                            Json.notify(ctx, key, t, newctx);
                        }
                    }
                }
                ctx = newctx;
                stack[0] = stack[3];
                stack[1] = stack[4];
                stack[2] = null;
                stack[3] = null;
                stack[4] = null;
                stacklen -= 3;
                continue;
            }
            if (stacklen > 3) break;
        }
        if (stacklen != 1 && ctx != null) {
            throw new IllegalArgumentException("Invalid path \"" + path + "\"");
        }
        if (finalchild != null) {
            return output;
        }
        return ctx;
    }

    public String type() {
        return this.core.type();
    }

    public boolean isNull() {
        return this.core instanceof INull;
    }

    public boolean isNumber() {
        return this.core instanceof INumber;
    }

    public boolean isBoolean() {
        return this.core instanceof IBoolean;
    }

    public boolean isString() {
        return this.core instanceof IString;
    }

    public boolean isMap() {
        return this.core instanceof IMap;
    }

    public boolean isList() {
        return this.core instanceof IList;
    }

    public Object value() {
        return this.core.value();
    }

    public String stringValue() {
        return this.core.stringValue();
    }

    public Number numberValue() {
        return this.core.numberValue();
    }

    public int intValue() {
        return this.core.intValue();
    }

    public long longValue() {
        return this.core.longValue();
    }

    public float floatValue() {
        return this.core.floatValue();
    }

    public double doubleValue() {
        return this.core.doubleValue();
    }

    public boolean booleanValue() {
        return this.core.booleanValue();
    }

    public Map<String, Json> mapValue() {
        return Collections.unmodifiableMap(this._mapValue());
    }

    Map<String, Json> _mapValue() {
        return this.core.mapValue();
    }

    public List<Json> listValue() {
        return Collections.unmodifiableList(this._listValue());
    }

    List<Json> _listValue() {
        return this.core.listValue();
    }

    public Object objectValue(JsonFactory factory) {
        Object o;
        if (this.isNull()) {
            return null;
        }
        if (factory != null && (o = factory.fromJson(this)) != null) {
            return o;
        }
        if (this.isMap()) {
            LinkedHashMap<String, Json> out = new LinkedHashMap<String, Json>(this.core.mapValue());
            for (Map.Entry entry : out.entrySet()) {
                entry.setValue(((Json)entry.getValue()).objectValue(factory));
            }
            return out;
        }
        if (this.isList()) {
            List<Json> list = this.core.listValue();
            ArrayList<Object> out = new ArrayList<Object>(list.size());
            for (Json o2 : list) {
                out.add(o2.objectValue(factory));
            }
            return out;
        }
        return this.value();
    }

    public int hashCode() {
        return this.core.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Json && this.core.equals(((Json)o).core);
    }

    public String toString() {
        try {
            return this.write(new StringBuilder(), null).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Json eval(String path) {
        Object o = JsonPathProviderBFO.read(path, this);
        if (o instanceof List) {
            return (Json)((List)o).get(0);
        }
        return (Json)o;
    }

    public List<Json> evalAll(String path) {
        List<Object> o = JsonPathProviderBFO.read(path, this);
        if (o instanceof Json) {
            o = Collections.singletonList(o);
        }
        return o;
    }
}

