/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyThreadGroup
extends RubyObject {
    private Map rubyThreadList = new HashMap();
    private boolean enclosed = false;

    public static RubyClass createThreadGroupClass(Ruby runtime) {
        RubyClass threadGroupClass = runtime.defineClass("ThreadGroup", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyThreadGroup.class);
        threadGroupClass.defineMethod("add", callbackFactory.getMethod("add", RubyThread.class));
        threadGroupClass.defineMethod("enclose", callbackFactory.getMethod("enclose"));
        threadGroupClass.defineMethod("enclosed?", callbackFactory.getMethod("isEnclosed"));
        threadGroupClass.defineMethod("list", callbackFactory.getMethod("list"));
        threadGroupClass.getMetaClass().defineMethod("new", callbackFactory.getSingletonMethod("newInstance"));
        RubyThreadGroup defaultThreadGroup = new RubyThreadGroup(runtime, threadGroupClass);
        threadGroupClass.defineConstant("Default", defaultThreadGroup);
        return threadGroupClass;
    }

    public static IRubyObject newInstance(IRubyObject recv, Block block) {
        return new RubyThreadGroup(recv.getRuntime(), (RubyClass)recv);
    }

    public IRubyObject add(RubyThread rubyThread, Block block) {
        if (this.isFrozen()) {
            throw this.getRuntime().newTypeError("can't add to frozen ThreadGroup");
        }
        if (rubyThread.group() != this.getRuntime().getNil()) {
            RubyThreadGroup threadGroup = (RubyThreadGroup)rubyThread.group();
            threadGroup.rubyThreadList.remove(new Integer(System.identityHashCode(rubyThread)));
        }
        rubyThread.setThreadGroup(this);
        this.rubyThreadList.put(new Integer(System.identityHashCode(rubyThread)), rubyThread);
        return this;
    }

    public void remove(RubyThread rubyThread) {
        rubyThread.setThreadGroup(null);
        this.rubyThreadList.remove(new Integer(System.identityHashCode(rubyThread)));
    }

    public IRubyObject enclose(Block block) {
        this.enclosed = true;
        return this;
    }

    public IRubyObject isEnclosed(Block block) {
        return new RubyBoolean(this.getRuntime(), this.enclosed);
    }

    public IRubyObject list(Block block) {
        return this.getRuntime().newArrayNoCopy(this.rubyThreadList.values().toArray(new IRubyObject[this.rubyThreadList.size()]));
    }

    private RubyThreadGroup(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }
}

