/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;

public class MethodCache {
    private static int CACHE_SIZE = 2048;
    private static int CACHE_MASK = 2047;
    private boolean initialized = false;
    private CacheEntry[] cache = new CacheEntry[CACHE_SIZE];

    public MethodCache() {
        this.clearAllEntries();
    }

    public void initialized() {
        this.initialized = true;
    }

    public void clearCache() {
        if (!this.initialized) {
            return;
        }
        this.clearAllEntries();
    }

    private void clearAllEntries() {
        for (int i = 0; i < CACHE_SIZE; ++i) {
            this.cache[i] = new CacheEntry();
            this.cache[i].klass = null;
            this.cache[i].mid = null;
            this.cache[i].method = null;
        }
    }

    private int cacheIndex(RubyModule c, String id) {
        return (c.hashCode() >> 3 ^ id.hashCode()) & CACHE_MASK;
    }

    public CacheEntry getMethod(RubyModule c, String id) {
        int index = this.cacheIndex(c, id);
        return this.cache[index];
    }

    public void putMethod(RubyModule c, String id, DynamicMethod m) {
        int index = this.cacheIndex(c, id);
        this.cache[index].klass = c;
        this.cache[index].mid = id;
        this.cache[index].method = m;
    }

    public void removeMethod(RubyClass c, String id) {
        if (!this.initialized) {
            return;
        }
        for (int i = 0; i < CACHE_SIZE; ++i) {
            CacheEntry entry = this.cache[i];
            if (!id.equals(entry.mid) || entry.klass != c) continue;
            entry.mid = null;
        }
    }

    public void removeMethod(String id) {
        if (!this.initialized) {
            return;
        }
        for (int i = 0; i < CACHE_SIZE; ++i) {
            CacheEntry entry = this.cache[i];
            if (!id.equals(entry.mid)) continue;
            entry.mid = null;
        }
    }

    public void removeClass(RubyClass c) {
        if (!this.initialized) {
            return;
        }
        for (int i = 0; i < CACHE_SIZE; ++i) {
            CacheEntry entry = this.cache[i];
            if (entry.klass != c) continue;
            entry.mid = null;
        }
    }

    public static class CacheEntry {
        public RubyModule klass;
        public String mid;
        public DynamicMethod method;
    }
}

