/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;

public abstract class CompoundExpression
extends Expression {
    protected ExpressionOperator operator;
    protected transient ExpressionOperator platformOperator;
    protected Expression firstChild;
    protected Expression secondChild;
    protected ExpressionBuilder builder;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        CompoundExpression expression = (CompoundExpression)object;
        return (this.getOperator() == expression.getOperator() || this.getOperator() != null && this.getOperator().equals(expression.getOperator())) && (this.getFirstChild() == expression.getFirstChild() || this.getFirstChild() != null && this.getFirstChild().equals(expression.getFirstChild())) && (this.getSecondChild() == expression.getSecondChild() || this.getSecondChild() != null && this.getSecondChild().equals(expression.getSecondChild()));
    }

    public int computeHashCode() {
        int hashCode = super.computeHashCode();
        if (this.getOperator() != null) {
            hashCode += this.getOperator().hashCode();
        }
        if (this.getFirstChild() != null) {
            hashCode += this.getFirstChild().hashCode();
        }
        if (this.getSecondChild() != null) {
            hashCode += this.getSecondChild().hashCode();
        }
        return hashCode;
    }

    public DatabaseTable aliasForTable(DatabaseTable table) {
        DatabaseTable alias = null;
        if (this.getFirstChild() != null) {
            alias = this.getFirstChild().aliasForTable(table);
        }
        if (alias == null && this.getSecondChild() != null) {
            alias = this.getSecondChild().aliasForTable(table);
        }
        return alias;
    }

    public Expression asOf(AsOfClause clause) {
        final AsOfClause finalClause = clause;
        ExpressionIterator iterator = new ExpressionIterator(){

            public void iterate(Expression each) {
                if (each.isDataExpression()) {
                    each.asOf(finalClause);
                }
            }

            public boolean shouldIterateOverSubSelects() {
                return true;
            }
        };
        iterator.iterateOn(this);
        return this;
    }

    public Expression create(Expression base, Object singleArgument, ExpressionOperator operator) {
        this.setFirstChild(base);
        Expression argument = Expression.from(singleArgument, base);
        this.setSecondChild(argument);
        this.setOperator(operator);
        return this;
    }

    public Expression create(Expression base, Vector arguments, ExpressionOperator operator) {
        this.setFirstChild(base);
        if (!arguments.isEmpty()) {
            this.setSecondChild((Expression)arguments.firstElement());
        }
        this.setOperator(operator);
        return this;
    }

    public String descriptionOfNodeType() {
        return "Compound Expression";
    }

    public ExpressionBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = this.getFirstChild().getBuilder();
            if (this.builder == null) {
                this.builder = this.getSecondChild().getBuilder();
            }
        }
        return this.builder;
    }

    public Expression getFirstChild() {
        return this.firstChild;
    }

    public ExpressionOperator getOperator() {
        return this.operator;
    }

    public ExpressionOperator getPlatformOperator(DatabasePlatform platform) {
        if (this.platformOperator == null) {
            this.initializePlatformOperator(platform);
        }
        return this.platformOperator;
    }

    public Expression getSecondChild() {
        return this.secondChild;
    }

    public void initializePlatformOperator(DatabasePlatform platform) {
        if (this.getOperator().isComplete()) {
            this.platformOperator = this.getOperator();
            return;
        }
        this.platformOperator = platform.getOperator(this.getOperator().getSelector());
        if (this.platformOperator == null) {
            throw QueryException.invalidOperator(this.getOperator().toString());
        }
    }

    public boolean isCompoundExpression() {
        return true;
    }

    public void iterateOn(ExpressionIterator iterator) {
        super.iterateOn(iterator);
        if (this.getFirstChild() != null) {
            this.getFirstChild().iterateOn(iterator);
        }
        if (this.getSecondChild() != null) {
            this.getSecondChild().iterateOn(iterator);
        }
    }

    public Expression normalize(ExpressionNormalizer normalizer) {
        ExpressionBuilder builder;
        this.validateNode();
        if (this.getFirstChild() != null) {
            builder = this.getFirstChild().getBuilder();
            if (builder != null) {
                builder.setSession(normalizer.getSession().getRootSession(null));
            }
            this.setFirstChild(this.getFirstChild().normalize(normalizer));
        }
        if (this.getSecondChild() != null) {
            builder = this.getSecondChild().getBuilder();
            if (builder != null) {
                builder.setSession(normalizer.getSession().getRootSession(null));
            }
            this.setSecondChild(this.getSecondChild().normalize(normalizer));
        }
        if (this.getFirstChild() == null) {
            return this.getSecondChild();
        }
        if (this.getSecondChild() == null) {
            return this.getFirstChild();
        }
        return this;
    }

    public void validateNode() {
        if (this.getFirstChild() != null && (this.getFirstChild().isDataExpression() || this.getFirstChild().isConstantExpression())) {
            throw QueryException.invalidExpression(this);
        }
        if (this.getSecondChild() != null && (this.getSecondChild().isDataExpression() || this.getSecondChild().isConstantExpression())) {
            throw QueryException.invalidExpression(this);
        }
    }

    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        if (this.getFirstChild() != null) {
            this.setFirstChild(this.getFirstChild().copiedVersionFrom(alreadyDone));
        }
        if (this.getSecondChild() != null) {
            this.setSecondChild(this.getSecondChild().copiedVersionFrom(alreadyDone));
        }
    }

    public void printSQL(ExpressionSQLPrinter printer) {
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        printer.printString("(");
        realOperator.printDuo(this.getFirstChild(), this.getSecondChild(), printer);
        printer.printString(")");
    }

    public void printJava(ExpressionJavaPrinter printer) {
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        realOperator.printJavaDuo(this.getFirstChild(), this.getSecondChild(), printer);
    }

    public Expression rebuildOn(Expression newBase) {
        NonSynchronizedVector arguments;
        Expression first = this.getFirstChild().rebuildOn(newBase);
        if (this.getSecondChild() == null) {
            arguments = NonSynchronizedVector.newInstance(0);
        } else {
            arguments = NonSynchronizedVector.newInstance(1);
            ((Vector)arguments).addElement(this.getSecondChild().rebuildOn(newBase));
        }
        return first.performOperator(this.getOperator(), arguments);
    }

    protected void setFirstChild(Expression firstChild) {
        this.firstChild = firstChild;
        this.builder = null;
    }

    public void setOperator(ExpressionOperator newOperator) {
        this.operator = newOperator;
    }

    protected void setSecondChild(Expression secondChild) {
        this.secondChild = secondChild;
        this.builder = null;
    }

    public Expression twistedForBaseAndContext(Expression newBase, Expression context) {
        NonSynchronizedVector arguments;
        if (this.getSecondChild() == null) {
            arguments = NonSynchronizedVector.newInstance(0);
        } else {
            arguments = NonSynchronizedVector.newInstance(1);
            ((Vector)arguments).addElement(this.getSecondChild().twistedForBaseAndContext(newBase, context));
        }
        Expression first = this.getFirstChild().twistedForBaseAndContext(newBase, context);
        return first.performOperator(this.getOperator(), arguments);
    }

    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(this.operator.toString());
    }

    public void writeSubexpressionsTo(BufferedWriter writer, int indent) throws IOException {
        if (this.getFirstChild() != null) {
            this.getFirstChild().toString(writer, indent);
        }
        if (this.getSecondChild() != null) {
            this.getSecondChild().toString(writer, indent);
        }
    }

    public Expression shallowClone() {
        CompoundExpression clone = (CompoundExpression)super.shallowClone();
        clone.builder = null;
        return clone;
    }
}

