/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataHelper;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;

public class TypeConverterMetadata
extends AbstractConverterMetadata {
    private Class m_dataType;
    private Class m_objectType;
    private String m_dataTypeName;
    private String m_objectTypeName;

    public TypeConverterMetadata() {
        super("<type-converter>");
    }

    public TypeConverterMetadata(String xmlElement) {
        super(xmlElement);
    }

    public TypeConverterMetadata(Annotation typeConverter, MetadataAccessibleObject accessibleObject) {
        super(typeConverter, accessibleObject);
        this.m_dataType = (Class)MetadataHelper.invokeMethod("dataType", typeConverter);
        this.m_objectType = (Class)MetadataHelper.invokeMethod("objectType", typeConverter);
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof TypeConverterMetadata) {
            TypeConverterMetadata typeConverter = (TypeConverterMetadata)objectToCompare;
            if (!this.valuesMatch(this.getName(), typeConverter.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_dataType, typeConverter.getDataType())) {
                return false;
            }
            return this.valuesMatch(this.m_objectType, typeConverter.getObjectType());
        }
        return false;
    }

    public Class getDataType() {
        return this.m_dataType;
    }

    public Class getDataType(DirectAccessor accessor) {
        if (this.m_dataType == Void.TYPE) {
            Class dataType = accessor.getReferenceClass();
            if (dataType == null) {
                throw ValidationException.noConverterDataTypeSpecified(accessor.getJavaClass(), accessor.getAttributeName(), this.getName());
            }
            accessor.getLogger().logConfigMessage("metadata_default_converter_data_type", accessor, this.getName(), dataType);
            return dataType;
        }
        return this.m_dataType;
    }

    public String getDataTypeName() {
        return this.m_dataTypeName;
    }

    public Class getObjectType(DirectAccessor accessor) {
        if (this.m_objectType == Void.TYPE) {
            Class objectType = accessor.getReferenceClass();
            if (objectType == null) {
                throw ValidationException.noConverterObjectTypeSpecified(accessor.getJavaClass(), accessor.getAttributeName(), this.getName());
            }
            accessor.getLogger().logConfigMessage("metadata_default_converter_object_type", accessor, this.getName(), objectType);
            return objectType;
        }
        return this.m_objectType;
    }

    public Class getObjectType() {
        return this.m_objectType;
    }

    public String getObjectTypeName() {
        return this.m_objectTypeName;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        super.initXMLObject(accessibleObject);
        this.m_dataType = this.initXMLClassName(this.m_dataTypeName);
        this.m_objectType = this.initXMLClassName(this.m_objectTypeName);
    }

    public void process(DatabaseMapping mapping, DirectAccessor accessor) {
        TypeConversionConverter converter = new TypeConversionConverter(mapping);
        converter.setDataClassName(this.getDataType(accessor).getName());
        converter.setObjectClassName(this.getObjectType(accessor).getName());
        accessor.setConverter(mapping, converter);
        accessor.setFieldClassification(mapping, this.m_dataType);
    }

    public void setDataType(Class dataType) {
        this.m_dataType = dataType;
    }

    public void setDataTypeName(String dataTypeName) {
        this.m_dataTypeName = dataTypeName;
    }

    public void setObjectType(Class objectType) {
        this.m_objectType = objectType;
    }

    public void setObjectTypeName(String objectTypeName) {
        this.m_objectTypeName = objectTypeName;
    }
}

