/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.attrs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.libraries.asm.ByteVector;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.Type;

public class Annotation {
    public String type;
    public List elementValues = new ArrayList();

    public Annotation() {
    }

    public Annotation(String type) {
        this.type = type;
    }

    public void add(String name, Object value) {
        this.elementValues.add(new Object[]{name, value});
    }

    public int read(ClassReader cr, int off, char[] buf) {
        this.type = cr.readUTF8(off, buf);
        int numElementValuePairs = cr.readUnsignedShort(off + 2);
        int[] aoff = new int[]{off += 4};
        int i = 0;
        while (i < numElementValuePairs) {
            String elementName = cr.readUTF8(aoff[0], buf);
            aoff[0] = aoff[0] + 2;
            this.elementValues.add(new Object[]{elementName, Annotation.readValue(cr, aoff, buf)});
            ++i;
        }
        return aoff[0];
    }

    public void write(ByteVector bv, ClassWriter cw) {
        bv.putShort(cw.newUTF8(this.type));
        bv.putShort(this.elementValues.size());
        int i = 0;
        while (i < this.elementValues.size()) {
            Object[] value = (Object[])this.elementValues.get(i);
            bv.putShort(cw.newUTF8((String)value[0]));
            Annotation.writeValue(bv, value[1], cw);
            ++i;
        }
    }

    public static int readAnnotations(List annotations, ClassReader cr, int off, char[] buf) {
        int size = cr.readUnsignedShort(off);
        off += 2;
        int i = 0;
        while (i < size) {
            Annotation ann = new Annotation();
            off = ann.read(cr, off, buf);
            annotations.add(ann);
            ++i;
        }
        return off;
    }

    public static void readParameterAnnotations(List parameters, ClassReader cr, int off, char[] buf) {
        int numParameters = cr.b[off++] & 0xFF;
        int i = 0;
        while (i < numParameters) {
            ArrayList annotations = new ArrayList();
            off = Annotation.readAnnotations(annotations, cr, off, buf);
            parameters.add(annotations);
            ++i;
        }
    }

    public static ByteVector writeAnnotations(ByteVector bv, List annotations, ClassWriter cw) {
        bv.putShort(annotations.size());
        int i = 0;
        while (i < annotations.size()) {
            ((Annotation)annotations.get(i)).write(bv, cw);
            ++i;
        }
        return bv;
    }

    public static ByteVector writeParametersAnnotations(ByteVector bv, List parameters, ClassWriter cw) {
        bv.putByte(parameters.size());
        int i = 0;
        while (i < parameters.size()) {
            Annotation.writeAnnotations(bv, (List)parameters.get(i), cw);
            ++i;
        }
        return bv;
    }

    public static String stringAnnotations(List annotations) {
        StringBuffer sb = new StringBuffer();
        if (annotations.size() > 0) {
            int i = 0;
            while (i < annotations.size()) {
                sb.append('\n').append(annotations.get(i));
                ++i;
            }
        } else {
            sb.append("<none>");
        }
        return sb.toString();
    }

    public static String stringParameterAnnotations(List parameters) {
        StringBuffer sb = new StringBuffer();
        String sep = "";
        int i = 0;
        while (i < parameters.size()) {
            sb.append(sep).append(Annotation.stringAnnotations((List)parameters.get(i)));
            sep = ", ";
            ++i;
        }
        return sb.toString();
    }

    protected static Object readValue(ClassReader cr, int[] off, char[] buf) {
        Object[] value = null;
        int n = off[0];
        off[0] = n + 1;
        int tag = cr.readByte(n);
        block0 : switch (tag) {
            case 68: 
            case 70: 
            case 73: 
            case 74: {
                value = cr.readConst(cr.readUnsignedShort(off[0]), buf);
                off[0] = off[0] + 2;
                break;
            }
            case 66: {
                value = new Byte((byte)cr.readInt(cr.getItem(cr.readUnsignedShort(off[0]))));
                off[0] = off[0] + 2;
                break;
            }
            case 67: {
                value = new Character((char)cr.readInt(cr.getItem(cr.readUnsignedShort(off[0]))));
                off[0] = off[0] + 2;
                break;
            }
            case 83: {
                value = new Short((short)cr.readInt(cr.getItem(cr.readUnsignedShort(off[0]))));
                off[0] = off[0] + 2;
                break;
            }
            case 90: {
                value = cr.readInt(cr.getItem(cr.readUnsignedShort(off[0]))) == 0 ? Boolean.FALSE : Boolean.TRUE;
                off[0] = off[0] + 2;
                break;
            }
            case 115: {
                value = cr.readUTF8(off[0], buf);
                off[0] = off[0] + 2;
                break;
            }
            case 101: {
                value = new EnumConstValue(cr.readUTF8(off[0], buf), cr.readUTF8(off[0] + 2, buf));
                off[0] = off[0] + 4;
                break;
            }
            case 99: {
                value = Type.getType(cr.readUTF8(off[0], buf));
                off[0] = off[0] + 2;
                break;
            }
            case 64: {
                value = new Annotation();
                off[0] = ((Annotation)value).read(cr, off[0], buf);
                break;
            }
            case 91: {
                Object[] v;
                int size = cr.readUnsignedShort(off[0]);
                off[0] = off[0] + 2;
                if (size == 0) {
                    return new Object[0];
                }
                int childTag = cr.readByte(off[0]);
                switch (childTag) {
                    case 73: {
                        int[] v2 = new int[size];
                        int i = 0;
                        while (i < size) {
                            off[0] = off[0] + 1;
                            v2[i] = cr.readInt(cr.getItem(cr.readUnsignedShort(off[0])));
                            off[0] = off[0] + 2;
                            ++i;
                        }
                        value = v2;
                        break block0;
                    }
                    case 74: {
                        long[] v3 = new long[size];
                        int i = 0;
                        while (i < size) {
                            off[0] = off[0] + 1;
                            v3[i] = cr.readLong(cr.getItem(cr.readUnsignedShort(off[0])));
                            off[0] = off[0] + 2;
                            ++i;
                        }
                        value = v3;
                        break block0;
                    }
                    case 68: {
                        double[] v4 = new double[size];
                        int i = 0;
                        while (i < size) {
                            off[0] = off[0] + 1;
                            v4[i] = Double.longBitsToDouble(cr.readLong(cr.getItem(cr.readUnsignedShort(off[0]))));
                            off[0] = off[0] + 2;
                            ++i;
                        }
                        value = v4;
                        break block0;
                    }
                    case 70: {
                        float[] v5 = new float[size];
                        int i = 0;
                        while (i < size) {
                            off[0] = off[0] + 1;
                            v5[i] = Float.intBitsToFloat(cr.readInt(cr.getItem(cr.readUnsignedShort(off[0]))));
                            off[0] = off[0] + 2;
                            ++i;
                        }
                        value = v5;
                        break block0;
                    }
                    case 66: {
                        byte[] v6 = new byte[size];
                        int i = 0;
                        while (i < size) {
                            off[0] = off[0] + 1;
                            v6[i] = (byte)cr.readInt(cr.getItem(cr.readUnsignedShort(off[0])));
                            off[0] = off[0] + 2;
                            ++i;
                        }
                        value = v6;
                        break block0;
                    }
                    case 67: {
                        char[] v7 = new char[size];
                        int i = 0;
                        while (i < size) {
                            off[0] = off[0] + 1;
                            v7[i] = (char)cr.readInt(cr.getItem(cr.readUnsignedShort(off[0])));
                            off[0] = off[0] + 2;
                            ++i;
                        }
                        value = v7;
                        break block0;
                    }
                    case 83: {
                        short[] v8 = new short[size];
                        int i = 0;
                        while (i < size) {
                            off[0] = off[0] + 1;
                            v8[i] = (short)cr.readInt(cr.getItem(cr.readUnsignedShort(off[0])));
                            off[0] = off[0] + 2;
                            ++i;
                        }
                        value = v8;
                        break block0;
                    }
                    case 90: {
                        boolean[] v9 = new boolean[size];
                        int i = 0;
                        while (i < size) {
                            off[0] = off[0] + 1;
                            v9[i] = cr.readInt(cr.getItem(cr.readUnsignedShort(off[0]))) != 0;
                            off[0] = off[0] + 2;
                            ++i;
                        }
                        value = v9;
                        break block0;
                    }
                }
                value = v = new Object[size];
                int i = 0;
                while (i < size) {
                    v[i] = Annotation.readValue(cr, off, buf);
                    ++i;
                }
                break;
            }
        }
        return value;
    }

    protected static ByteVector writeValue(ByteVector bv, Object value, ClassWriter cw) {
        if (value instanceof String) {
            bv.putByte(115);
            bv.putShort(cw.newUTF8((String)value));
        } else if (value instanceof EnumConstValue) {
            bv.putByte(101);
            bv.putShort(cw.newUTF8(((EnumConstValue)value).typeName));
            bv.putShort(cw.newUTF8(((EnumConstValue)value).constName));
        } else if (value instanceof Type) {
            bv.putByte(99);
            bv.putShort(cw.newUTF8(((Type)value).getDescriptor()));
        } else if (value instanceof Annotation) {
            bv.putByte(64);
            ((Annotation)value).write(bv, cw);
        } else if (value instanceof Object[]) {
            bv.putByte(91);
            Object[] v = (Object[])value;
            bv.putShort(v.length);
            int i = 0;
            while (i < v.length) {
                Annotation.writeValue(bv, v[i], cw);
                ++i;
            }
        } else if (value instanceof byte[]) {
            bv.putByte(91);
            byte[] v = (byte[])value;
            bv.putShort(v.length);
            int i = 0;
            while (i < v.length) {
                bv.putByte(66);
                bv.putShort(cw.newConstInt(v[i]));
                ++i;
            }
        } else if (value instanceof short[]) {
            bv.putByte(91);
            short[] v = (short[])value;
            bv.putShort(v.length);
            int i = 0;
            while (i < v.length) {
                bv.putByte(83);
                bv.putShort(cw.newConstInt(v[i]));
                ++i;
            }
        } else if (value instanceof int[]) {
            bv.putByte(91);
            int[] v = (int[])value;
            bv.putShort(v.length);
            int i = 0;
            while (i < v.length) {
                bv.putByte(73);
                bv.putShort(cw.newConstInt(v[i]));
                ++i;
            }
        } else if (value instanceof char[]) {
            bv.putByte(91);
            char[] v = (char[])value;
            bv.putShort(v.length);
            int i = 0;
            while (i < v.length) {
                bv.putByte(67);
                bv.putShort(cw.newConstInt(v[i]));
                ++i;
            }
        } else if (value instanceof boolean[]) {
            bv.putByte(91);
            boolean[] v = (boolean[])value;
            bv.putShort(v.length);
            int i = 0;
            while (i < v.length) {
                bv.putByte(90);
                bv.putShort(cw.newConstInt(v[i] ? 1 : 0));
                ++i;
            }
        } else if (value instanceof long[]) {
            bv.putByte(91);
            long[] v = (long[])value;
            bv.putShort(v.length);
            int i = 0;
            while (i < v.length) {
                bv.putByte(74);
                bv.putShort(cw.newConstLong(v[i]));
                ++i;
            }
        } else if (value instanceof float[]) {
            bv.putByte(91);
            float[] v = (float[])value;
            bv.putShort(v.length);
            int i = 0;
            while (i < v.length) {
                bv.putByte(70);
                bv.putShort(cw.newConstFloat(v[i]));
                ++i;
            }
        } else if (value instanceof double[]) {
            bv.putByte(91);
            double[] v = (double[])value;
            bv.putShort(v.length);
            int i = 0;
            while (i < v.length) {
                bv.putByte(68);
                bv.putShort(cw.newConstDouble(v[i]));
                ++i;
            }
        } else {
            int tag = -1;
            if (value instanceof Integer) {
                tag = 73;
            } else if (value instanceof Byte) {
                tag = 66;
            } else if (value instanceof Character) {
                tag = 67;
            } else if (value instanceof Double) {
                tag = 68;
            } else if (value instanceof Float) {
                tag = 70;
            } else if (value instanceof Long) {
                tag = 74;
            } else if (value instanceof Short) {
                tag = 83;
            } else if (value instanceof Boolean) {
                tag = 90;
            }
            bv.putByte(tag);
            bv.putShort(cw.newConst(value));
        }
        return bv;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("@").append(this.type);
        if (this.elementValues.size() > 0) {
            sb.append(" ( ");
            String sep = "";
            int i = 0;
            while (i < this.elementValues.size()) {
                Object[] value = (Object[])this.elementValues.get(i);
                if (this.elementValues.size() != 1 && !"value".equals(this.elementValues.get(0))) {
                    sb.append(sep).append(value[0]).append(" = ");
                }
                if (value[1] instanceof Object[]) {
                    Object[] v = (Object[])value[1];
                    sb.append("{");
                    String sep2 = "";
                    int j = 0;
                    while (j < v.length) {
                        sb.append(sep2).append(v[j]);
                        sep2 = ", ";
                        ++j;
                    }
                    sb.append("}");
                } else {
                    sb.append(value[1]);
                }
                sep = ", ";
                ++i;
            }
            sb.append(" )");
        }
        return sb.toString();
    }

    public static class EnumConstValue {
        public String typeName;
        public String constName;

        public EnumConstValue(String typeName, String constName) {
            this.typeName = typeName;
            this.constName = constName;
        }

        public String toString() {
            return String.valueOf(this.typeName) + ":" + this.constName;
        }
    }
}

