/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;

public class JAXBIntrospector
extends javax.xml.bind.JAXBIntrospector {
    private XMLContext context;

    public JAXBIntrospector(XMLContext context) {
        this.context = context;
    }

    public boolean isElement(Object obj) {
        if (obj instanceof JAXBElement) {
            return true;
        }
        AbstractSession session = this.context.getSession(obj);
        if (session == null) {
            return false;
        }
        XMLDescriptor descriptor = (XMLDescriptor)session.getDescriptor(obj);
        if (descriptor == null) {
            return false;
        }
        return descriptor.getDefaultRootElement() != null;
    }

    public QName getElementName(Object obj) {
        if (!this.isElement(obj)) {
            return null;
        }
        XMLDescriptor descriptor = (XMLDescriptor)this.context.getSession(obj).getDescriptor(obj);
        String rootElem = descriptor.getDefaultRootElement();
        int prefixIndex = rootElem.indexOf(":");
        if (prefixIndex == -1) {
            return new QName(rootElem);
        }
        String prefix = rootElem.substring(0, prefixIndex);
        String localPart = rootElem.substring(prefixIndex + 1);
        String URI2 = descriptor.getNamespaceResolver().resolveNamespacePrefix(prefix);
        return new QName(URI2, localPart);
    }
}

