/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.plsql;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.ComplexDatabaseType;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.jdbc.JDBCTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PLSQLStoredProcedureCall
extends StoredProcedureCall {
    public static final String BEGIN_DECLARE_BLOCK = "\nDECLARE\n";
    public static final String BEGIN_BEGIN_BLOCK = "BEGIN\n";
    public static final String END_BEGIN_BLOCK = "END;";
    protected List<PLSQLargument> arguments = new ArrayList<PLSQLargument>();
    protected int originalIndex = 0;
    protected AbstractRecord translationRow;

    public void addNamedArgument(String procedureParameterName, DatabaseType databaseType) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, IN, databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType));
    }

    public void addNamedArgument(String procedureParameterName, DatabaseType databaseType, int length) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, IN, databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType, length));
    }

    public void addNamedArgument(String procedureParameterName, DatabaseType databaseType, int precision, int scale) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, IN, databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType, precision, scale));
    }

    @Override
    public void addNamedArgument(String procedureParameterName, String argumentFieldName, int type) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, IN, JDBCTypes.getDatabaseTypeForCode(type)));
    }

    @Override
    public void addNamedArgument(String procedureParameterName, String argumentFieldName, int type, String typeName) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, IN, JDBCTypes.getDatabaseTypeForCode(type)));
    }

    public void addNamedInOutputArgument(String procedureParameterName, DatabaseType databaseType) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, INOUT, databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType));
    }

    public void addNamedInOutputArgument(String procedureParameterName, DatabaseType databaseType, int length) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, INOUT, databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType, length));
    }

    public void addNamedInOutputArgument(String procedureParameterName, DatabaseType databaseType, int precision, int scale) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, INOUT, databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType, precision, scale));
    }

    @Override
    public void addNamedInOutputArgument(String procedureParameterName, String inArgumentFieldName, String outArgumentFieldName, int type) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, INOUT, JDBCTypes.getDatabaseTypeForCode(type)));
    }

    @Override
    public void addNamedInOutputArgument(String procedureParameterName, String inArgumentFieldName, String outArgumentFieldName, int type, String typeName) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, INOUT, JDBCTypes.getDatabaseTypeForCode(type)));
    }

    @Override
    public void addNamedInOutputArgument(String procedureParameterName, String inArgumentFieldName, String outArgumentFieldName, int type, String typeName, Class classType) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, INOUT, JDBCTypes.getDatabaseTypeForCode(type)));
    }

    @Override
    public void addNamedInOutputArgument(String procedureParameterName, String inArgumentFieldName, String outArgumentFieldName, int type, String typeName, Class javaType, DatabaseField nestedType) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, INOUT, JDBCTypes.getDatabaseTypeForCode(type)));
    }

    public void addNamedOutputArgument(String procedureParameterName, DatabaseType databaseType) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, OUT, databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType));
    }

    public void addNamedOutputArgument(String procedureParameterName, DatabaseType databaseType, int length) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, OUT, databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType, length));
    }

    public void addNamedOutputArgument(String procedureParameterName, DatabaseType databaseType, int precision, int scale) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, OUT, databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType, precision, scale));
    }

    @Override
    public void addNamedOutputArgument(String procedureParameterName, String argumentFieldName, int jdbcType, String typeName, Class javaType) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, OUT, JDBCTypes.getDatabaseTypeForCode(jdbcType)));
    }

    @Override
    public void addNamedOutputArgument(String procedureParameterName, String argumentFieldName, int jdbcType, String typeName, Class javaType, DatabaseField nestedType) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, OUT, JDBCTypes.getDatabaseTypeForCode(jdbcType)));
    }

    @Override
    public void addNamedOutputArgument(String procedureParameterName, String argumentFieldName, int type, String typeName) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, OUT, JDBCTypes.getDatabaseTypeForCode(type)));
    }

    @Override
    public void addNamedOutputArgument(String procedureParameterName, String argumentFieldName, int type) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, OUT, JDBCTypes.getDatabaseTypeForCode(type)));
    }

    @Override
    public void addNamedArgument(String procedureParameterAndArgumentFieldName) {
        throw QueryException.addArgumentsNotSupported("named arguments without DatabaseType classification");
    }

    @Override
    public void addNamedArgumentValue(String procedureParameterName, Object argumentValue) {
        throw QueryException.addArgumentsNotSupported("named argument values without DatabaseType classification");
    }

    @Override
    public void addNamedArgument(String procedureParameterName, String argumentFieldName) {
        throw QueryException.addArgumentsNotSupported("named argument values without DatabaseType classification");
    }

    @Override
    public void addNamedInOutputArgument(String procedureParameterAndArgumentFieldName) {
        throw QueryException.addArgumentsNotSupported("named IN OUT argument without DatabaseType classification");
    }

    @Override
    public void addNamedInOutputArgument(String procedureParameterName, String argumentFieldName) {
        throw QueryException.addArgumentsNotSupported("named IN OUT arguments without DatabaseType classification");
    }

    @Override
    public void addNamedInOutputArgument(String procedureParameterName, String argumentFieldName, Class type) {
        throw QueryException.addArgumentsNotSupported("named IN OUT arguments without DatabaseType classification");
    }

    @Override
    public void addNamedInOutputArgument(String procedureParameterName, String inArgumentFieldName, String outArgumentFieldName, Class type) {
        throw QueryException.addArgumentsNotSupported("named IN OUT arguments without DatabaseType classification");
    }

    @Override
    public void addNamedInOutputArgumentValue(String procedureParameterName, Object inArgumentValue, String outArgumentFieldName, Class type) {
        throw QueryException.addArgumentsNotSupported("named IN OUT argument values without DatabaseType classification");
    }

    @Override
    public void addNamedOutputArgument(String procedureParameterAndArgumentFieldName) {
        throw QueryException.addArgumentsNotSupported("named OUT arguments without DatabaseType classification");
    }

    @Override
    public void addNamedOutputArgument(String procedureParameterName, String argumentFieldName) {
        throw QueryException.addArgumentsNotSupported("named OUT arguments without DatabaseType classification");
    }

    @Override
    public void addNamedOutputArgument(String procedureParameterName, String argumentFieldName, Class type) {
        throw QueryException.addArgumentsNotSupported("named OUT arguments without DatabaseType classification");
    }

    @Override
    public void useNamedCursorOutputAsResultSet(String argumentName) {
        throw QueryException.addArgumentsNotSupported("named OUT cursor arguments without DatabaseType classification");
    }

    @Override
    public void addUnamedArgument(String argumentFieldName, Class type) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedArgument(String argumentFieldName, int type, String typeName, DatabaseField nestedType) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedArgument(String argumentFieldName, int type, String typeName) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedArgument(String argumentFieldName, int type) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedArgument(String argumentFieldName) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedArgumentValue(Object argumentValue) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String argumentFieldName, Class type) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String inArgumentFieldName, String outArgumentFieldName, Class type) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String inArgumentFieldName, String outArgumentFieldName, int type, String typeName, Class collection, DatabaseField nestedType) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String inArgumentFieldName, String outArgumentFieldName, int type, String typeName, Class collection) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String inArgumentFieldName, String outArgumentFieldName, int type, String typeName) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String inArgumentFieldName, String outArgumentFieldName, int type) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String argumentFieldName) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgumentValue(Object inArgumentValue, String outArgumentFieldName, Class type) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedOutputArgument(String argumentFieldName, Class type) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedOutputArgument(String argumentFieldName, int jdbcType, String typeName, Class javaType, DatabaseField nestedType) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedOutputArgument(String argumentFieldName, int jdbcType, String typeName, Class javaType) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedOutputArgument(String argumentFieldName, int type, String typeName) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedOutputArgument(String argumentFieldName, int type) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedOutputArgument(String argumentFieldName) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void useUnnamedCursorOutputAsResultSet() {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    public void useNamedCursorOutputAsResultSet(String argumentName, DatabaseType databaseType) {
        PLSQLargument newArg = new PLSQLargument(argumentName, this.originalIndex++, OUT, databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType);
        newArg.cursorOutput = true;
        this.arguments.add(newArg);
    }

    protected void assignIndices() {
        List<PLSQLargument> inArguments = PLSQLStoredProcedureCall.getArguments(this.arguments, IN);
        List<PLSQLargument> inOutArguments = PLSQLStoredProcedureCall.getArguments(this.arguments, INOUT);
        inArguments.addAll(inOutArguments);
        int newIndex = 1;
        ListIterator<PLSQLargument> inArgsIter = inArguments.listIterator();
        while (inArgsIter.hasNext()) {
            PLSQLargument inArg = inArgsIter.next();
            newIndex = inArg.databaseTypeWrapper.getWrappedType().computeInIndex(inArg, newIndex, inArgsIter);
        }
        for (PLSQLargument inArg : inArguments) {
            if (!inArg.databaseTypeWrapper.getWrappedType().isComplexDatabaseType()) {
                super.addNamedArgument(inArg.name, inArg.name, inArg.databaseTypeWrapper.getWrappedType().getConversionCode());
                continue;
            }
            if (inArg.inIndex == Integer.MIN_VALUE) continue;
            super.addNamedArgument(inArg.name, inArg.name, inArg.databaseTypeWrapper.getWrappedType().getConversionCode());
        }
        List<PLSQLargument> outArguments = PLSQLStoredProcedureCall.getArguments(this.arguments, OUT);
        outArguments.addAll(inOutArguments);
        ListIterator<PLSQLargument> outArgsIter = outArguments.listIterator();
        while (outArgsIter.hasNext()) {
            PLSQLargument outArg = outArgsIter.next();
            newIndex = outArg.databaseTypeWrapper.getWrappedType().computeOutIndex(outArg, newIndex, outArgsIter);
        }
        for (PLSQLargument outArg : outArguments) {
            if (!outArg.databaseTypeWrapper.getWrappedType().isComplexDatabaseType()) {
                super.addNamedOutputArgument(outArg.name, outArg.name, outArg.databaseTypeWrapper.getWrappedType().getConversionCode());
                continue;
            }
            if (outArg.outIndex == Integer.MIN_VALUE) continue;
            super.addNamedOutputArgument(outArg.name, outArg.name, outArg.databaseTypeWrapper.getWrappedType().getConversionCode(), ((ComplexDatabaseType)outArg.databaseTypeWrapper.getWrappedType()).getCompatibleType());
        }
    }

    protected void buildDeclareBlock(StringBuilder sb) {
        List<PLSQLargument> inArguments = PLSQLStoredProcedureCall.getArguments(this.arguments, IN);
        List<PLSQLargument> inOutArguments = PLSQLStoredProcedureCall.getArguments(this.arguments, INOUT);
        inArguments.addAll(inOutArguments);
        List<PLSQLargument> outArguments = PLSQLStoredProcedureCall.getArguments(this.arguments, OUT);
        for (PLSQLargument arg : inArguments) {
            arg.databaseTypeWrapper.getWrappedType().buildInDeclare(sb, arg);
        }
        for (PLSQLargument arg : outArguments) {
            arg.databaseTypeWrapper.getWrappedType().buildOutDeclare(sb, arg);
        }
    }

    protected void buildBeginBlock(StringBuilder sb) {
        List<PLSQLargument> inArguments = PLSQLStoredProcedureCall.getArguments(this.arguments, IN);
        inArguments.addAll(PLSQLStoredProcedureCall.getArguments(this.arguments, INOUT));
        for (PLSQLargument arg : inArguments) {
            arg.databaseTypeWrapper.getWrappedType().buildBeginBlock(sb, arg);
        }
    }

    protected void buildProcedureInvocation(StringBuilder sb) {
        sb.append("  ");
        sb.append(this.getProcedureName());
        sb.append("(");
        int size = this.arguments.size();
        int idx = 1;
        for (PLSQLargument arg : this.arguments) {
            sb.append(arg.name);
            sb.append("=>");
            sb.append(DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(arg));
            if (idx >= size) continue;
            sb.append(", ");
            ++idx;
        }
        sb.append(");\n");
    }

    protected void buildOutAssignments(StringBuilder sb) {
        List<PLSQLargument> outArguments = PLSQLStoredProcedureCall.getArguments(this.arguments, OUT);
        outArguments.addAll(PLSQLStoredProcedureCall.getArguments(this.arguments, INOUT));
        for (PLSQLargument arg : outArguments) {
            arg.databaseTypeWrapper.getWrappedType().buildOutAssignment(sb, arg);
        }
    }

    @Override
    protected void prepareInternal(AbstractSession session) {
        this.assignIndices();
        StringBuilder sb = new StringBuilder();
        sb.append(BEGIN_DECLARE_BLOCK);
        this.buildDeclareBlock(sb);
        sb.append(BEGIN_BEGIN_BLOCK);
        this.buildBeginBlock(sb);
        this.buildProcedureInvocation(sb);
        this.buildOutAssignments(sb);
        sb.append(END_BEGIN_BLOCK);
        this.setSQLStringInternal(sb.toString());
        super.prepareInternalParameters(session);
    }

    @Override
    public void translate(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        AbstractRecord copyOfTranslationRow = (AbstractRecord)translationRow.clone();
        int len = copyOfTranslationRow.size();
        Vector copyOfTranslationFields = copyOfTranslationRow.getFields();
        translationRow.clear();
        Vector translationRowFields = translationRow.getFields();
        translationRowFields.setSize(len);
        Vector translationRowValues = translationRow.getValues();
        translationRowValues.setSize(len);
        for (PLSQLargument arg : this.arguments) {
            if (arg.direction != IN && arg.direction != INOUT) continue;
            arg.databaseTypeWrapper.getWrappedType().translate(arg, translationRow, copyOfTranslationRow, copyOfTranslationFields, translationRowFields, translationRowValues);
        }
        this.translationRow = translationRow;
        super.translate(translationRow, modifyRow, session);
    }

    @Override
    public AbstractRecord buildOutputRow(CallableStatement statement) throws SQLException {
        AbstractRecord outputRow = super.buildOutputRow(statement);
        Vector outputRowFields = outputRow.getFields();
        Vector outputRowValues = outputRow.getValues();
        DatabaseRecord newOutputRow = new DatabaseRecord();
        List<PLSQLargument> outArguments = PLSQLStoredProcedureCall.getArguments(this.arguments, OUT);
        outArguments.addAll(PLSQLStoredProcedureCall.getArguments(this.arguments, INOUT));
        Collections.sort(outArguments, new Comparator<PLSQLargument>(){

            @Override
            public int compare(PLSQLargument o1, PLSQLargument o2) {
                return o1.originalIndex - o2.originalIndex;
            }
        });
        for (PLSQLargument outArg : outArguments) {
            if (outArg.databaseTypeWrapper.getWrappedType().isComplexDatabaseType()) {
                ((ComplexDatabaseType)outArg.databaseTypeWrapper.getWrappedType()).setCall(this);
            }
            outArg.databaseTypeWrapper.getWrappedType().buildOutputRow(outArg, outputRow, newOutputRow, outputRowFields, outputRowValues);
        }
        return newOutputRow;
    }

    @Override
    public String getLogString(Accessor accessor) {
        StringBuilder sb = new StringBuilder(this.getSQLString());
        sb.append(Helper.cr());
        sb.append("\tbind => [");
        List<PLSQLargument> inArguments = PLSQLStoredProcedureCall.getArguments(this.arguments, IN);
        inArguments.addAll(PLSQLStoredProcedureCall.getArguments(this.arguments, INOUT));
        Collections.sort(inArguments, new Comparator<PLSQLargument>(){

            @Override
            public int compare(PLSQLargument o1, PLSQLargument o2) {
                return o1.inIndex - o2.inIndex;
            }
        });
        Iterator<PLSQLargument> i = inArguments.iterator();
        while (i.hasNext()) {
            PLSQLargument inArg = i.next();
            inArg.databaseTypeWrapper.getWrappedType().logParameter(sb, IN, inArg, this.translationRow, this.getQuery().getSession().getPlatform());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        List<PLSQLargument> outArguments = PLSQLStoredProcedureCall.getArguments(this.arguments, OUT);
        outArguments.addAll(PLSQLStoredProcedureCall.getArguments(this.arguments, INOUT));
        Collections.sort(outArguments, new Comparator<PLSQLargument>(){

            @Override
            public int compare(PLSQLargument o1, PLSQLargument o2) {
                return o1.outIndex - o2.outIndex;
            }
        });
        if (!inArguments.isEmpty() && !outArguments.isEmpty()) {
            sb.append(", ");
        }
        for (PLSQLargument outArg : outArguments) {
            outArg.databaseTypeWrapper.getWrappedType().logParameter(sb, OUT, outArg, this.translationRow, this.getQuery().getSession().getPlatform());
        }
        sb.append("]");
        return sb.toString();
    }

    protected static List<PLSQLargument> getArguments(List<PLSQLargument> args, Integer direction) {
        ArrayList<PLSQLargument> inArgs = new ArrayList<PLSQLargument>();
        for (PLSQLargument arg : args) {
            if (arg.direction != direction) continue;
            inArgs.add(arg);
        }
        return inArgs;
    }
}

