/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sessions;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.sessions.Session;
import oracle.toplink.sessions.SessionLog;
import oracle.toplink.sessions.SessionLogEntry;

public class DefaultSessionLog
implements SessionLog,
Serializable {
    protected Writer writer;
    protected boolean shouldPrintDate;
    protected boolean shouldPrintSession;
    protected boolean shouldPrintThread;
    protected boolean shouldPrintConnection;
    protected DateFormat dateFormat;
    protected String fileName;
    protected boolean shouldLogDebug = false;
    protected boolean shouldLogExceptions = false;
    protected boolean shouldLogExceptionStackTrace = true;

    public DefaultSessionLog() {
        this.initialize();
    }

    public DefaultSessionLog(Writer writer) {
        this();
        this.initialize(writer);
    }

    protected DateFormat buildDefaultDateFormat() {
        return new SimpleDateFormat("yyyy.MM.dd hh:mm:ss.SSS");
    }

    public void dontLogDebug() {
        this.setShouldLogDebug(false);
    }

    public void dontLogExceptions() {
        this.setShouldLogExceptions(false);
    }

    public void dontLogExceptionStackTrace() {
        this.setShouldLogExceptionStackTrace(false);
    }

    public void dontPrintConnection() {
        this.setShouldPrintConnection(false);
    }

    public void dontPrintDate() {
        this.setShouldPrintDate(false);
    }

    public void dontPrintSession() {
        this.setShouldPrintSession(false);
    }

    public void dontPrintThread() {
        this.setShouldPrintThread(false);
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = this.buildDefaultDateFormat();
        }
        return this.dateFormat;
    }

    public Writer getWriter() {
        if (this.writer == null) {
            this.writer = new PrintWriter(System.out);
        }
        return this.writer;
    }

    protected void initialize() {
        this.printSession();
        this.printConnection();
    }

    protected void initialize(Writer writer) {
        this.writer = writer;
    }

    public synchronized void log(SessionLogEntry entry) {
    }

    public void logDebug() {
        this.setShouldLogDebug(true);
    }

    public void logExceptions() {
        this.setShouldLogExceptions(true);
    }

    public void logExceptionStackTrace() {
        this.setShouldLogExceptionStackTrace(true);
    }

    public void printConnection() {
        this.setShouldPrintConnection(true);
    }

    public void printDate() {
        this.setShouldPrintDate(true);
    }

    public void printSession() {
        this.setShouldPrintSession(true);
    }

    public void printThread() {
        this.setShouldPrintThread(true);
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setShouldLogDebug(boolean shouldLogDebug) {
        this.shouldLogDebug = shouldLogDebug;
    }

    public void setShouldLogExceptions(boolean shouldLogExceptions) {
        this.shouldLogExceptions = shouldLogExceptions;
    }

    public void setShouldLogExceptionStackTrace(boolean shouldLogExceptionStackTrace) {
        this.shouldLogExceptionStackTrace = shouldLogExceptionStackTrace;
    }

    public void setShouldPrintConnection(boolean shouldPrintConnection) {
        this.shouldPrintConnection = shouldPrintConnection;
    }

    public void setShouldPrintDate(boolean shouldPrintDate) {
        this.shouldPrintDate = shouldPrintDate;
    }

    public void setShouldPrintSession(boolean shouldPrintSession) {
        this.shouldPrintSession = shouldPrintSession;
    }

    public void setShouldPrintThread(boolean shouldPrintThread) {
        this.shouldPrintThread = shouldPrintThread;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void setWriter(String aFileName) {
        if (aFileName != null) {
            try {
                this.writer = new FileWriter(aFileName);
                this.fileName = aFileName;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getWriterFilename() {
        return this.fileName;
    }

    public boolean shouldLogDebug() {
        return this.shouldLogDebug;
    }

    public boolean shouldLogExceptions() {
        return this.shouldLogExceptions;
    }

    public boolean shouldLogExceptionStackTrace() {
        return this.shouldLogExceptionStackTrace;
    }

    public boolean shouldPrintConnection() {
        return this.shouldPrintConnection;
    }

    public boolean shouldPrintDate() {
        return this.shouldPrintDate;
    }

    public boolean shouldPrintSession() {
        return this.shouldPrintSession;
    }

    public boolean shouldPrintThread() {
        return this.shouldPrintThread;
    }

    protected void writeConnection(Accessor connection) throws IOException {
    }

    protected void writeDate(Date date) throws IOException {
        this.getWriter().write(this.getDateFormat().format(date));
    }

    protected void writeMessage(String message) throws IOException {
        this.getWriter().write(message);
    }

    protected void writeSeparator() throws IOException {
        this.getWriter().write("--");
    }

    protected void writeSession(Session session) throws IOException {
        String sessionName = "Session";
        if (session.isUnitOfWork()) {
            sessionName = "UnitOfWork";
        } else if (session.isServerSession()) {
            sessionName = "ServerSession";
        } else if (session.isClientSession()) {
            sessionName = "ClientSession";
        } else if (session.isSessionBroker()) {
            sessionName = "SessionBroker";
        } else if (session.isRemoteSession()) {
            sessionName = "RemoteSession";
        } else if (session.isDatabaseSession()) {
            sessionName = "DatabaseSession";
        }
        this.getWriter().write(sessionName);
        this.getWriter().write("(");
        this.getWriter().write(String.valueOf(System.identityHashCode(session)));
        this.getWriter().write(")");
    }

    protected void writeThread(Thread thread) throws IOException {
        this.getWriter().write(String.valueOf(thread));
    }
}

