/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import org.springframework.aop.aspectj.AspectInstanceFactory;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class SingletonAspectInstanceFactory
implements AspectInstanceFactory {
    private final Object aspectInstance;

    public SingletonAspectInstanceFactory(Object aspectInstance) {
        Assert.notNull((Object)aspectInstance, (String)"Aspect instance must not be null");
        this.aspectInstance = aspectInstance;
    }

    public final Object getAspectInstance() {
        return this.aspectInstance;
    }

    public ClassLoader getAspectClassLoader() {
        return this.aspectInstance.getClass().getClassLoader();
    }

    public int getOrder() {
        if (this.aspectInstance instanceof Ordered) {
            return ((Ordered)this.aspectInstance).getOrder();
        }
        return this.getOrderForAspectClass(this.aspectInstance.getClass());
    }

    protected int getOrderForAspectClass(Class aspectClass) {
        return Integer.MAX_VALUE;
    }
}

