/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.UnavailableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.i18n.SimpleLocaleContext;
import org.springframework.core.JdkVersion;
import org.springframework.core.OrderComparator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.portlet.FrameworkPortlet;
import org.springframework.web.portlet.HandlerAdapter;
import org.springframework.web.portlet.HandlerExceptionResolver;
import org.springframework.web.portlet.HandlerExecutionChain;
import org.springframework.web.portlet.HandlerInterceptor;
import org.springframework.web.portlet.HandlerMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.context.PortletRequestAttributes;
import org.springframework.web.portlet.multipart.MultipartActionRequest;
import org.springframework.web.portlet.multipart.PortletMultipartResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewRendererServlet;
import org.springframework.web.servlet.ViewResolver;

public class DispatcherPortlet
extends FrameworkPortlet {
    public static final String MULTIPART_RESOLVER_BEAN_NAME = "portletMultipartResolver";
    public static final String HANDLER_MAPPING_BEAN_NAME = "handlerMapping";
    public static final String HANDLER_ADAPTER_BEAN_NAME = "handlerAdapter";
    public static final String HANDLER_EXCEPTION_RESOLVER_BEAN_NAME = "handlerExceptionResolver";
    public static final String VIEW_RESOLVER_BEAN_NAME = "viewResolver";
    public static final String DEFAULT_VIEW_RENDERER_URL = "/WEB-INF/servlet/view";
    public static final String HANDLER_EXECUTION_CHAIN_ATTRIBUTE = DispatcherPortlet.class.getName() + ".HANDLER";
    public static final String ACTION_EXCEPTION_SESSION_ATTRIBUTE = DispatcherPortlet.class.getName() + ".ACTION_EXCEPTION";
    public static final String ACTION_EXCEPTION_RENDER_PARAMETER = "actionException";
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.portlet.PageNotFound";
    private static final String DEFAULT_STRATEGIES_PATH = "DispatcherPortlet.properties";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.portlet.PageNotFound");
    private static final Properties defaultStrategies;
    private boolean detectAllHandlerMappings = true;
    private boolean detectAllHandlerAdapters = true;
    private boolean detectAllHandlerExceptionResolvers = true;
    private boolean detectAllViewResolvers = true;
    private String viewRendererUrl = "/WEB-INF/servlet/view";
    private boolean threadContextInheritable = false;
    private PortletMultipartResolver multipartResolver;
    private List handlerMappings;
    private List handlerAdapters;
    private List handlerExceptionResolvers;
    private List viewResolvers;

    public void setDetectAllHandlerMappings(boolean detectAllHandlerMappings) {
        this.detectAllHandlerMappings = detectAllHandlerMappings;
    }

    public void setDetectAllHandlerAdapters(boolean detectAllHandlerAdapters) {
        this.detectAllHandlerAdapters = detectAllHandlerAdapters;
    }

    public void setDetectAllHandlerExceptionResolvers(boolean detectAllHandlerExceptionResolvers) {
        this.detectAllHandlerExceptionResolvers = detectAllHandlerExceptionResolvers;
    }

    public void setDetectAllViewResolvers(boolean detectAllViewResolvers) {
        this.detectAllViewResolvers = detectAllViewResolvers;
    }

    public void setViewRendererUrl(String viewRendererUrl) {
        this.viewRendererUrl = viewRendererUrl;
    }

    public void setThreadContextInheritable(boolean threadContextInheritable) {
        this.threadContextInheritable = threadContextInheritable;
    }

    public void onRefresh(ApplicationContext context) {
        this.initStrategies(context);
    }

    protected void initStrategies(ApplicationContext context) {
        this.initMultipartResolver(context);
        this.initHandlerMappings(context);
        this.initHandlerAdapters(context);
        this.initHandlerExceptionResolvers(context);
        this.initViewResolvers(context);
    }

    private void initMultipartResolver(ApplicationContext context) {
        block3: {
            try {
                this.multipartResolver = (PortletMultipartResolver)context.getBean(MULTIPART_RESOLVER_BEAN_NAME, PortletMultipartResolver.class);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Using MultipartResolver [" + this.multipartResolver + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.multipartResolver = null;
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)"Unable to locate PortletMultipartResolver with name 'portletMultipartResolver': no multipart request handling provided");
            }
        }
    }

    private void initHandlerMappings(ApplicationContext context) {
        this.handlerMappings = null;
        if (this.detectAllHandlerMappings) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, (Class)HandlerMapping.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.handlerMappings = new ArrayList(matchingBeans.values());
                Collections.sort(this.handlerMappings, new OrderComparator());
            }
        } else {
            try {
                Object hm = context.getBean(HANDLER_MAPPING_BEAN_NAME, HandlerMapping.class);
                this.handlerMappings = Collections.singletonList(hm);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.handlerMappings == null) {
            this.handlerMappings = this.getDefaultStrategies(context, HandlerMapping.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No HandlerMappings found in portlet '" + this.getPortletName() + "': using default"));
            }
        }
    }

    private void initHandlerAdapters(ApplicationContext context) {
        this.handlerAdapters = null;
        if (this.detectAllHandlerAdapters) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, (Class)HandlerAdapter.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.handlerAdapters = new ArrayList(matchingBeans.values());
                Collections.sort(this.handlerAdapters, new OrderComparator());
            }
        } else {
            try {
                Object ha = context.getBean(HANDLER_ADAPTER_BEAN_NAME, HandlerAdapter.class);
                this.handlerAdapters = Collections.singletonList(ha);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.handlerAdapters == null) {
            this.handlerAdapters = this.getDefaultStrategies(context, HandlerAdapter.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No HandlerAdapters found in portlet '" + this.getPortletName() + "': using default"));
            }
        }
    }

    private void initHandlerExceptionResolvers(ApplicationContext context) {
        this.handlerExceptionResolvers = null;
        if (this.detectAllHandlerExceptionResolvers) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, (Class)HandlerExceptionResolver.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.handlerExceptionResolvers = new ArrayList(matchingBeans.values());
                Collections.sort(this.handlerExceptionResolvers, new OrderComparator());
            }
        } else {
            try {
                Object her = context.getBean(HANDLER_EXCEPTION_RESOLVER_BEAN_NAME, HandlerExceptionResolver.class);
                this.handlerExceptionResolvers = Collections.singletonList(her);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.handlerExceptionResolvers == null) {
            this.handlerExceptionResolvers = this.getDefaultStrategies(context, HandlerExceptionResolver.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No HandlerExceptionResolvers found in portlet '" + this.getPortletName() + "': using default"));
            }
        }
    }

    private void initViewResolvers(ApplicationContext context) {
        this.viewResolvers = null;
        if (this.detectAllViewResolvers) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, (Class)ViewResolver.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.viewResolvers = new ArrayList(matchingBeans.values());
                Collections.sort(this.viewResolvers, new OrderComparator());
            }
        } else {
            try {
                Object vr = context.getBean(VIEW_RESOLVER_BEAN_NAME, ViewResolver.class);
                this.viewResolvers = Collections.singletonList(vr);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.viewResolvers == null) {
            this.viewResolvers = this.getDefaultStrategies(context, ViewResolver.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No ViewResolvers found in portlet '" + this.getPortletName() + "': using default"));
            }
        }
    }

    protected Object getDefaultStrategy(ApplicationContext context, Class strategyInterface) throws BeansException {
        List strategies = this.getDefaultStrategies(context, strategyInterface);
        if (strategies.size() != 1) {
            throw new BeanInitializationException("DispatcherPortlet needs exactly 1 strategy for interface [" + strategyInterface.getName() + "]");
        }
        return strategies.get(0);
    }

    protected List getDefaultStrategies(ApplicationContext context, Class strategyInterface) throws BeansException {
        String key = strategyInterface.getName();
        ArrayList<Object> strategies = null;
        String value = defaultStrategies.getProperty(key);
        if (value != null) {
            String[] classNames = StringUtils.commaDelimitedListToStringArray((String)value);
            strategies = new ArrayList<Object>(classNames.length);
            for (int i = 0; i < classNames.length; ++i) {
                String className = classNames[i];
                if (JdkVersion.getMajorJavaVersion() < 2 && className.indexOf("Annotation") != -1) continue;
                try {
                    Class clazz = ClassUtils.forName((String)className, (ClassLoader)(class$org$springframework$web$portlet$DispatcherPortlet == null ? DispatcherPortlet.class$("org.springframework.web.portlet.DispatcherPortlet") : class$org$springframework$web$portlet$DispatcherPortlet).getClassLoader());
                    Object strategy = this.createDefaultStrategy(context, clazz);
                    strategies.add(strategy);
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    throw new BeanInitializationException("Could not find DispatcherPortlet's default strategy class [" + className + "] for interface [" + key + "]", (Throwable)ex);
                }
                catch (LinkageError err) {
                    throw new BeanInitializationException("Error loading DispatcherPortlet's default strategy class [" + className + "] for interface [" + key + "]: problem with class file or dependent class", (Throwable)err);
                }
            }
        } else {
            strategies = Collections.EMPTY_LIST;
        }
        return strategies;
    }

    protected Object createDefaultStrategy(ApplicationContext context, Class clazz) throws BeansException {
        return context.getAutowireCapableBeanFactory().createBean(clazz);
    }

    public PortletMultipartResolver getMultipartResolver() {
        return this.multipartResolver;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doActionService(ActionRequest request, ActionResponse response) throws Exception {
        ActionRequest processedRequest;
        PortletRequestAttributes requestAttributes;
        RequestAttributes previousRequestAttributes;
        LocaleContext previousLocaleContext;
        block21: {
            block20: {
                block19: {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("DispatcherPortlet with name '" + this.getPortletName() + "' received action request"));
                    }
                    previousLocaleContext = LocaleContextHolder.getLocaleContext();
                    LocaleContextHolder.setLocaleContext((LocaleContext)this.buildLocaleContext((PortletRequest)request), (boolean)this.threadContextInheritable);
                    previousRequestAttributes = RequestContextHolder.getRequestAttributes();
                    requestAttributes = new PortletRequestAttributes((PortletRequest)request);
                    RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes, (boolean)this.threadContextInheritable);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Bound action request context to thread: " + request));
                    }
                    processedRequest = request;
                    HandlerExecutionChain mappedHandler = null;
                    int interceptorIndex = -1;
                    try {
                        try {
                            processedRequest = this.checkMultipart(request);
                            mappedHandler = this.getHandler((PortletRequest)processedRequest, false);
                            if (mappedHandler == null || mappedHandler.getHandler() == null) {
                                this.noHandlerFound((PortletRequest)processedRequest, (PortletResponse)response);
                                Object var13_9 = null;
                                break block19;
                            }
                            HandlerInterceptor[] interceptors = mappedHandler.getInterceptors();
                            if (interceptors != null) {
                                int i = 0;
                                while (i < interceptors.length) {
                                    HandlerInterceptor interceptor = interceptors[i];
                                    if (!interceptor.preHandleAction(processedRequest, response, mappedHandler.getHandler())) {
                                        this.triggerAfterActionCompletion(mappedHandler, interceptorIndex, processedRequest, response, null);
                                        break block20;
                                    }
                                    interceptorIndex = i++;
                                }
                            }
                            HandlerAdapter ha = this.getHandlerAdapter(mappedHandler.getHandler());
                            ha.handleAction(processedRequest, response, mappedHandler.getHandler());
                            this.triggerAfterActionCompletion(mappedHandler, interceptorIndex, processedRequest, response, null);
                            break block21;
                        }
                        catch (Exception ex) {
                            this.triggerAfterActionCompletion(mappedHandler, interceptorIndex, processedRequest, response, ex);
                            try {
                                response.setRenderParameter(ACTION_EXCEPTION_RENDER_PARAMETER, ex.toString());
                                request.getPortletSession().setAttribute(ACTION_EXCEPTION_SESSION_ATTRIBUTE, (Object)ex);
                                this.logger.debug((Object)"Caught exception during action phase - forwarding to render phase", (Throwable)ex);
                            }
                            catch (IllegalStateException ex2) {
                                throw ex;
                            }
                            Object var13_12 = null;
                            if (processedRequest instanceof MultipartActionRequest && processedRequest != request) {
                                this.multipartResolver.cleanupMultipart((MultipartActionRequest)processedRequest);
                            }
                            RequestContextHolder.setRequestAttributes((RequestAttributes)previousRequestAttributes, (boolean)this.threadContextInheritable);
                            LocaleContextHolder.setLocaleContext((LocaleContext)previousLocaleContext, (boolean)this.threadContextInheritable);
                            requestAttributes.requestCompleted();
                            if (!this.logger.isDebugEnabled()) return;
                            this.logger.debug((Object)("Cleared thread-bound action request context: " + request));
                            return;
                        }
                        catch (Error err) {
                            PortletException ex = new PortletException("Error occured during request processing: " + err.getMessage(), (Throwable)err);
                            this.triggerAfterActionCompletion(mappedHandler, interceptorIndex, processedRequest, response, (Exception)ex);
                            throw ex;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_13 = null;
                        if (processedRequest instanceof MultipartActionRequest && processedRequest != request) {
                            this.multipartResolver.cleanupMultipart((MultipartActionRequest)processedRequest);
                        }
                        RequestContextHolder.setRequestAttributes((RequestAttributes)previousRequestAttributes, (boolean)this.threadContextInheritable);
                        LocaleContextHolder.setLocaleContext((LocaleContext)previousLocaleContext, (boolean)this.threadContextInheritable);
                        requestAttributes.requestCompleted();
                        if (!this.logger.isDebugEnabled()) throw throwable;
                        this.logger.debug((Object)("Cleared thread-bound action request context: " + request));
                        throw throwable;
                    }
                }
                if (processedRequest instanceof MultipartActionRequest && processedRequest != request) {
                    this.multipartResolver.cleanupMultipart((MultipartActionRequest)processedRequest);
                }
                RequestContextHolder.setRequestAttributes((RequestAttributes)previousRequestAttributes, (boolean)this.threadContextInheritable);
                LocaleContextHolder.setLocaleContext((LocaleContext)previousLocaleContext, (boolean)this.threadContextInheritable);
                requestAttributes.requestCompleted();
                if (!this.logger.isDebugEnabled()) return;
                this.logger.debug((Object)("Cleared thread-bound action request context: " + request));
                return;
            }
            Object var13_10 = null;
            if (processedRequest instanceof MultipartActionRequest && processedRequest != request) {
                this.multipartResolver.cleanupMultipart((MultipartActionRequest)processedRequest);
            }
            RequestContextHolder.setRequestAttributes((RequestAttributes)previousRequestAttributes, (boolean)this.threadContextInheritable);
            LocaleContextHolder.setLocaleContext((LocaleContext)previousLocaleContext, (boolean)this.threadContextInheritable);
            requestAttributes.requestCompleted();
            if (!this.logger.isDebugEnabled()) return;
            this.logger.debug((Object)("Cleared thread-bound action request context: " + request));
            return;
        }
        Object var13_11 = null;
        if (processedRequest instanceof MultipartActionRequest && processedRequest != request) {
            this.multipartResolver.cleanupMultipart((MultipartActionRequest)processedRequest);
        }
        RequestContextHolder.setRequestAttributes((RequestAttributes)previousRequestAttributes, (boolean)this.threadContextInheritable);
        LocaleContextHolder.setLocaleContext((LocaleContext)previousLocaleContext, (boolean)this.threadContextInheritable);
        requestAttributes.requestCompleted();
        if (!this.logger.isDebugEnabled()) return;
        this.logger.debug((Object)("Cleared thread-bound action request context: " + request));
    }

    /*
     * Exception decompiling
     */
    protected void doRenderService(RenderRequest request, RenderResponse response) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected LocaleContext buildLocaleContext(PortletRequest request) {
        return new SimpleLocaleContext(request.getLocale());
    }

    protected ActionRequest checkMultipart(ActionRequest request) throws MultipartException {
        if (this.multipartResolver != null && this.multipartResolver.isMultipart(request)) {
            if (request instanceof MultipartActionRequest) {
                this.logger.debug((Object)"Request is already a MultipartActionRequest - probably in a forward");
            } else {
                return this.multipartResolver.resolveMultipart(request);
            }
        }
        return request;
    }

    protected HandlerExecutionChain getHandler(PortletRequest request, boolean cache) throws Exception {
        HandlerExecutionChain handler = (HandlerExecutionChain)request.getAttribute(HANDLER_EXECUTION_CHAIN_ATTRIBUTE);
        if (handler != null) {
            if (!cache) {
                request.removeAttribute(HANDLER_EXECUTION_CHAIN_ATTRIBUTE);
            }
            return handler;
        }
        Iterator it = this.handlerMappings.iterator();
        while (it.hasNext()) {
            HandlerMapping hm = (HandlerMapping)it.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Testing handler map [" + hm + "] in DispatcherPortlet with name '" + this.getPortletName() + "'"));
            }
            if ((handler = hm.getHandler(request)) == null) continue;
            if (cache) {
                request.setAttribute(HANDLER_EXECUTION_CHAIN_ATTRIBUTE, (Object)handler);
            }
            return handler;
        }
        return null;
    }

    protected void noHandlerFound(PortletRequest request, PortletResponse response) throws Exception {
        if (pageNotFoundLogger.isWarnEnabled()) {
            pageNotFoundLogger.warn((Object)("No mapping found for current request in DispatcherPortlet with name '" + this.getPortletName() + "'" + ", mode '" + request.getPortletMode() + "'" + ", type '" + (response instanceof ActionResponse ? "action" : "render") + "'" + ", session '" + request.getRequestedSessionId() + "'" + ", user '" + this.getUsernameForRequest(request) + "'"));
        }
        throw new UnavailableException("No handler found for request");
    }

    protected HandlerAdapter getHandlerAdapter(Object handler) throws PortletException {
        Iterator it = this.handlerAdapters.iterator();
        while (it.hasNext()) {
            HandlerAdapter ha = (HandlerAdapter)it.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Testing handler adapter [" + ha + "]"));
            }
            if (!ha.supports(handler)) continue;
            return ha;
        }
        throw new PortletException("No adapter for handler [" + handler + "]: Does your handler implement a supported interface like Controller?");
    }

    protected ModelAndView processHandlerException(RenderRequest request, RenderResponse response, Object handler, Exception ex) throws Exception {
        ModelAndView exMv = null;
        Iterator it = this.handlerExceptionResolvers.iterator();
        while (exMv == null && it.hasNext()) {
            HandlerExceptionResolver resolver = (HandlerExceptionResolver)it.next();
            exMv = resolver.resolveException(request, response, handler, ex);
        }
        if (exMv != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("HandlerExceptionResolver returned ModelAndView [" + exMv + "] for exception"));
            }
            this.logger.warn((Object)"Handler execution resulted in exception - forwarding to resolved error view", (Throwable)ex);
            return exMv;
        }
        throw ex;
    }

    private void triggerAfterActionCompletion(HandlerExecutionChain mappedHandler, int interceptorIndex, ActionRequest request, ActionResponse response, Exception ex) throws Exception {
        HandlerInterceptor[] interceptors;
        if (mappedHandler != null && (interceptors = mappedHandler.getInterceptors()) != null) {
            for (int i = interceptorIndex; i >= 0; --i) {
                HandlerInterceptor interceptor = interceptors[i];
                try {
                    interceptor.afterActionCompletion(request, response, mappedHandler.getHandler(), ex);
                    continue;
                }
                catch (Throwable ex2) {
                    this.logger.error((Object)"HandlerInterceptor.afterCompletion threw exception", ex2);
                }
            }
        }
    }

    protected void render(ModelAndView mv, RenderRequest request, RenderResponse response) throws Exception {
        View view = null;
        if (mv.isReference()) {
            view = this.resolveViewName(mv.getViewName(), mv.getModelInternal(), request);
            if (view == null) {
                throw new PortletException("Could not resolve view with name '" + mv.getViewName() + "' in portlet with name '" + this.getPortletName() + "'");
            }
        } else {
            Object viewObject = mv.getView();
            if (viewObject == null) {
                throw new PortletException("ModelAndView [" + mv + "] neither contains a view name nor a " + "View object in portlet with name '" + this.getPortletName() + "'");
            }
            if (!(viewObject instanceof View)) {
                throw new PortletException("View object [" + viewObject + "] is not an instance of [org.springframework.web.servlet.View] - " + "DispatcherPortlet does not support any other view types");
            }
            view = (View)viewObject;
        }
        if (view == null) {
            throw new PortletException("Could not resolve view with name '" + mv.getViewName() + "' in portlet with name '" + this.getPortletName() + "'");
        }
        if (response.getContentType() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Portlet response content type already set to [" + response.getContentType() + "]"));
            }
        } else {
            String contentType = view.getContentType();
            if (contentType != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Setting portlet response content type to view-determined type [" + contentType + "]"));
                }
                response.setContentType(contentType);
            }
        }
        this.doRender(view, mv.getModelInternal(), request, response);
    }

    protected View resolveViewName(String viewName, Map model, RenderRequest request) throws Exception {
        Iterator it = this.viewResolvers.iterator();
        while (it.hasNext()) {
            ViewResolver viewResolver = (ViewResolver)it.next();
            View view = viewResolver.resolveViewName(viewName, request.getLocale());
            if (view == null) continue;
            return view;
        }
        return null;
    }

    protected void doRender(View view, Map model, RenderRequest request, RenderResponse response) throws Exception {
        request.setAttribute(ViewRendererServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this.getPortletApplicationContext());
        request.setAttribute(ViewRendererServlet.VIEW_ATTRIBUTE, (Object)view);
        request.setAttribute(ViewRendererServlet.MODEL_ATTRIBUTE, (Object)model);
        this.getPortletContext().getRequestDispatcher(this.viewRendererUrl).include(request, response);
    }

    private void triggerAfterRenderCompletion(HandlerExecutionChain mappedHandler, int interceptorIndex, RenderRequest request, RenderResponse response, Exception ex) throws Exception {
        HandlerInterceptor[] interceptors;
        if (mappedHandler != null && (interceptors = mappedHandler.getInterceptors()) != null) {
            for (int i = interceptorIndex; i >= 0; --i) {
                HandlerInterceptor interceptor = interceptors[i];
                try {
                    interceptor.afterRenderCompletion(request, response, mappedHandler.getHandler(), ex);
                    continue;
                }
                catch (Throwable ex2) {
                    this.logger.error((Object)"HandlerInterceptor.afterCompletion threw exception", ex2);
                }
            }
        }
    }

    static {
        try {
            ClassPathResource resource = new ClassPathResource(DEFAULT_STRATEGIES_PATH, DispatcherPortlet.class);
            defaultStrategies = PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not load 'DispatcherPortlet.properties': " + ex.getMessage());
        }
    }
}

