/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.mvc.annotation;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.UnavailableException;
import javax.portlet.WindowState;
import org.springframework.beans.BeanUtils;
import org.springframework.core.Conventions;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.style.StylerUtils;
import org.springframework.ui.ExtendedModelMap;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.validation.support.BindingAwareModelMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.annotation.support.HandlerMethodInvoker;
import org.springframework.web.bind.annotation.support.HandlerMethodResolver;
import org.springframework.web.bind.support.DefaultSessionAttributeStore;
import org.springframework.web.bind.support.SessionAttributeStore;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.portlet.HandlerAdapter;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.MissingPortletRequestParameterException;
import org.springframework.web.portlet.bind.PortletRequestDataBinder;
import org.springframework.web.portlet.context.PortletWebRequest;
import org.springframework.web.portlet.handler.PortletContentGenerator;
import org.springframework.web.portlet.handler.PortletSessionRequiredException;
import org.springframework.web.portlet.mvc.annotation.PortletAnnotationMappingUtils;
import org.springframework.web.portlet.util.PortletUtils;
import org.springframework.web.servlet.View;

public class AnnotationMethodHandlerAdapter
extends PortletContentGenerator
implements HandlerAdapter {
    private static final String IMPLICIT_MODEL_ATTRIBUTE = "org.springframework.web.portlet.mvc.ImplicitModel";
    private WebBindingInitializer webBindingInitializer;
    private SessionAttributeStore sessionAttributeStore = new DefaultSessionAttributeStore();
    private int cacheSecondsForSessionAttributeHandlers = 0;
    private boolean synchronizeOnSession = false;
    private ParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private WebArgumentResolver[] customArgumentResolvers;
    private final Map<Class<?>, PortletHandlerMethodResolver> methodResolverCache = new ConcurrentHashMap();

    public void setWebBindingInitializer(WebBindingInitializer webBindingInitializer) {
        this.webBindingInitializer = webBindingInitializer;
    }

    public void setSessionAttributeStore(SessionAttributeStore sessionAttributeStore) {
        Assert.notNull((Object)sessionAttributeStore, (String)"SessionAttributeStore must not be null");
        this.sessionAttributeStore = sessionAttributeStore;
    }

    public void setCacheSecondsForSessionAttributeHandlers(int cacheSecondsForSessionAttributeHandlers) {
        this.cacheSecondsForSessionAttributeHandlers = cacheSecondsForSessionAttributeHandlers;
    }

    public void setSynchronizeOnSession(boolean synchronizeOnSession) {
        this.synchronizeOnSession = synchronizeOnSession;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public void setCustomArgumentResolver(WebArgumentResolver argumentResolver) {
        this.customArgumentResolvers = new WebArgumentResolver[]{argumentResolver};
    }

    public void setCustomArgumentResolvers(WebArgumentResolver[] argumentResolvers) {
        this.customArgumentResolvers = argumentResolvers;
    }

    public boolean supports(Object handler) {
        return this.getMethodResolver(handler).hasHandlerMethods();
    }

    public void handleAction(ActionRequest request, ActionResponse response, Object handler) throws Exception {
        ModelAndView returnValue = this.doHandle((PortletRequest)request, (PortletResponse)response, handler);
        if (returnValue != null) {
            throw new IllegalStateException("Invalid action method return value: " + returnValue);
        }
    }

    public ModelAndView handleRender(RenderRequest request, RenderResponse response, Object handler) throws Exception {
        this.checkAndPrepare(request, response);
        return this.doHandle((PortletRequest)request, (PortletResponse)response, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView doHandle(PortletRequest request, PortletResponse response, Object handler) throws Exception {
        PortletSession session;
        BindingAwareModelMap implicitModel = null;
        if (request instanceof RenderRequest && response instanceof RenderResponse) {
            PortletSession session2;
            RenderRequest renderRequest = (RenderRequest)request;
            RenderResponse renderResponse = (RenderResponse)response;
            if (renderRequest.getParameter(IMPLICIT_MODEL_ATTRIBUTE) != null && (session2 = request.getPortletSession(false)) != null) {
                implicitModel = (ExtendedModelMap)session2.getAttribute(IMPLICIT_MODEL_ATTRIBUTE);
            }
            if (handler.getClass().getAnnotation(SessionAttributes.class) != null) {
                this.checkAndPrepare(renderRequest, renderResponse, this.cacheSecondsForSessionAttributeHandlers);
            } else {
                this.checkAndPrepare(renderRequest, renderResponse);
            }
        }
        if (implicitModel == null) {
            implicitModel = new BindingAwareModelMap();
        }
        if (this.synchronizeOnSession && (session = request.getPortletSession(false)) != null) {
            Object mutex;
            Object object = mutex = PortletUtils.getSessionMutex(session);
            synchronized (object) {
                return this.invokeHandlerMethod(request, response, handler, (ExtendedModelMap)implicitModel);
            }
        }
        return this.invokeHandlerMethod(request, response, handler, (ExtendedModelMap)implicitModel);
    }

    private ModelAndView invokeHandlerMethod(PortletRequest request, PortletResponse response, Object handler, ExtendedModelMap implicitModel) throws Exception {
        PortletWebRequest webRequest = new PortletWebRequest(request, response);
        PortletHandlerMethodResolver methodResolver = this.getMethodResolver(handler);
        Method handlerMethod = methodResolver.resolveHandlerMethod(request, response);
        PortletHandlerMethodInvoker methodInvoker = new PortletHandlerMethodInvoker(methodResolver);
        Object result = methodInvoker.invokeHandlerMethod(handlerMethod, handler, webRequest, implicitModel);
        ModelAndView mav = methodInvoker.getModelAndView(handlerMethod, handler.getClass(), result, implicitModel);
        methodInvoker.updateModelAttributes(handler, mav != null ? mav.getModel() : null, implicitModel, webRequest);
        if (response instanceof ActionResponse && !implicitModel.isEmpty()) {
            ActionResponse actionResponse = (ActionResponse)response;
            try {
                actionResponse.setRenderParameter(IMPLICIT_MODEL_ATTRIBUTE, Boolean.TRUE.toString());
                request.getPortletSession().setAttribute(IMPLICIT_MODEL_ATTRIBUTE, (Object)implicitModel);
            }
            catch (IllegalStateException ex) {
                // empty catch block
            }
        }
        return mav;
    }

    protected PortletRequestDataBinder createBinder(PortletRequest request, Object target, String objectName) throws Exception {
        return new PortletRequestDataBinder(target, objectName);
    }

    private PortletHandlerMethodResolver getMethodResolver(Object handler) {
        Class handlerClass = ClassUtils.getUserClass((Object)handler);
        PortletHandlerMethodResolver resolver = this.methodResolverCache.get(handlerClass);
        if (resolver == null) {
            resolver = new PortletHandlerMethodResolver(handlerClass);
            this.methodResolverCache.put(handlerClass, resolver);
        }
        return resolver;
    }

    private static class RequestMappingInfo {
        public String[] modes = new String[0];
        public String[] params = new String[0];
        private boolean action = false;
        private boolean render = false;

        private RequestMappingInfo() {
        }

        public boolean equals(Object obj) {
            RequestMappingInfo other = (RequestMappingInfo)obj;
            return this.action == other.action && this.render == other.render && Arrays.equals(this.modes, other.modes) && Arrays.equals(this.params, other.params);
        }

        public int hashCode() {
            return Arrays.hashCode(this.modes) * 29 + Arrays.hashCode(this.params);
        }
    }

    private class PortletHandlerMethodInvoker
    extends HandlerMethodInvoker {
        public PortletHandlerMethodInvoker(HandlerMethodResolver resolver) {
            super(resolver, AnnotationMethodHandlerAdapter.this.webBindingInitializer, AnnotationMethodHandlerAdapter.this.sessionAttributeStore, AnnotationMethodHandlerAdapter.this.parameterNameDiscoverer, AnnotationMethodHandlerAdapter.this.customArgumentResolvers);
        }

        protected void raiseMissingParameterException(String paramName, Class paramType) throws Exception {
            throw new MissingPortletRequestParameterException(paramName, paramType.getName());
        }

        protected void raiseSessionRequiredException(String message) throws Exception {
            throw new PortletSessionRequiredException(message);
        }

        protected WebDataBinder createBinder(NativeWebRequest webRequest, Object target, String objectName) throws Exception {
            return AnnotationMethodHandlerAdapter.this.createBinder((PortletRequest)webRequest.getNativeRequest(), target, objectName);
        }

        protected void doBind(NativeWebRequest webRequest, WebDataBinder binder, boolean failOnErrors) throws Exception {
            PortletRequestDataBinder servletBinder = (PortletRequestDataBinder)binder;
            servletBinder.bind((PortletRequest)webRequest.getNativeRequest());
            if (failOnErrors) {
                servletBinder.closeNoCatch();
            }
        }

        protected Object resolveStandardArgument(Class parameterType, NativeWebRequest webRequest) throws Exception {
            PortletRequest request = (PortletRequest)webRequest.getNativeRequest();
            PortletResponse response = (PortletResponse)webRequest.getNativeResponse();
            if (PortletRequest.class.isAssignableFrom(parameterType)) {
                return request;
            }
            if (PortletResponse.class.isAssignableFrom(parameterType)) {
                return response;
            }
            if (PortletSession.class.isAssignableFrom(parameterType)) {
                return request.getPortletSession();
            }
            if (PortletPreferences.class.isAssignableFrom(parameterType)) {
                return request.getPreferences();
            }
            if (PortletMode.class.isAssignableFrom(parameterType)) {
                return request.getPortletMode();
            }
            if (WindowState.class.isAssignableFrom(parameterType)) {
                return request.getWindowState();
            }
            if (PortalContext.class.isAssignableFrom(parameterType)) {
                return request.getPortalContext();
            }
            if (Principal.class.isAssignableFrom(parameterType)) {
                return request.getUserPrincipal();
            }
            if (Locale.class.equals((Object)parameterType)) {
                return request.getLocale();
            }
            if (InputStream.class.isAssignableFrom(parameterType)) {
                if (!(request instanceof ActionRequest)) {
                    throw new IllegalStateException("InputStream can only get obtained for ActionRequest");
                }
                return ((ActionRequest)request).getPortletInputStream();
            }
            if (Reader.class.isAssignableFrom(parameterType)) {
                if (!(request instanceof ActionRequest)) {
                    throw new IllegalStateException("Reader can only get obtained for ActionRequest");
                }
                return ((ActionRequest)request).getReader();
            }
            if (OutputStream.class.isAssignableFrom(parameterType)) {
                if (!(response instanceof RenderResponse)) {
                    throw new IllegalStateException("OutputStream can only get obtained for RenderResponse");
                }
                return ((RenderResponse)response).getPortletOutputStream();
            }
            if (Writer.class.isAssignableFrom(parameterType)) {
                if (!(response instanceof RenderResponse)) {
                    throw new IllegalStateException("Writer can only get obtained for RenderResponse");
                }
                return ((RenderResponse)response).getWriter();
            }
            return super.resolveStandardArgument(parameterType, webRequest);
        }

        public ModelAndView getModelAndView(Method handlerMethod, Class handlerType, Object returnValue, ExtendedModelMap implicitModel) {
            if (returnValue instanceof ModelAndView) {
                ModelAndView mav = (ModelAndView)returnValue;
                mav.getModelMap().mergeAttributes((Map)implicitModel);
                return mav;
            }
            if (returnValue instanceof org.springframework.web.servlet.ModelAndView) {
                org.springframework.web.servlet.ModelAndView smav = (org.springframework.web.servlet.ModelAndView)returnValue;
                ModelAndView mav = smav.isReference() ? new ModelAndView(smav.getViewName(), (Map)smav.getModelMap()) : new ModelAndView(smav.getView(), (Map)smav.getModelMap());
                mav.getModelMap().mergeAttributes((Map)implicitModel);
                return mav;
            }
            if (returnValue instanceof Model) {
                return new ModelAndView().addAllObjects((Map)implicitModel).addAllObjects(((Model)returnValue).asMap());
            }
            if (returnValue instanceof Map) {
                return new ModelAndView().addAllObjects((Map)implicitModel).addAllObjects((Map)returnValue);
            }
            if (returnValue instanceof View) {
                return new ModelAndView(returnValue).addAllObjects((Map)implicitModel);
            }
            if (returnValue instanceof String) {
                return new ModelAndView((String)returnValue).addAllObjects((Map)implicitModel);
            }
            if (returnValue == null) {
                return null;
            }
            if (!BeanUtils.isSimpleProperty(returnValue.getClass())) {
                ModelAttribute attr = (ModelAttribute)AnnotationUtils.findAnnotation((Method)handlerMethod, ModelAttribute.class);
                String attrName = attr != null ? attr.value() : "";
                ModelAndView mav = new ModelAndView().addAllObjects((Map)implicitModel);
                if ("".equals(attrName)) {
                    Class resolvedType = GenericTypeResolver.resolveReturnType((Method)handlerMethod, (Class)handlerType);
                    attrName = Conventions.getVariableNameForReturnType((Method)handlerMethod, (Class)resolvedType, (Object)returnValue);
                }
                return mav.addObject(attrName, returnValue);
            }
            throw new IllegalArgumentException("Invalid handler method return value: " + returnValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PortletHandlerMethodResolver
    extends HandlerMethodResolver {
        public PortletHandlerMethodResolver(Class<?> handlerType) {
            super(handlerType);
        }

        public Method resolveHandlerMethod(PortletRequest request, PortletResponse response) throws PortletException {
            String lookupMode = request.getPortletMode().toString();
            LinkedHashMap<RequestMappingInfo, Method> targetHandlerMethods = new LinkedHashMap<RequestMappingInfo, Method>();
            for (Method handlerMethod : this.getHandlerMethods()) {
                Method oldMappedMethod;
                Object mapping = (RequestMapping)AnnotationUtils.findAnnotation((Method)handlerMethod, RequestMapping.class);
                RequestMappingInfo mappingInfo = new RequestMappingInfo();
                mappingInfo.modes = mapping.value();
                mappingInfo.params = mapping.params();
                mappingInfo.action = this.isActionMethod(handlerMethod);
                mappingInfo.render = this.isRenderMethod(handlerMethod);
                boolean match = false;
                if (mappingInfo.modes.length > 0) {
                    for (String mappedMode : mappingInfo.modes) {
                        if (!mappedMode.equalsIgnoreCase(lookupMode)) continue;
                        if (this.checkParameters(request, response, mappingInfo)) {
                            match = true;
                            continue;
                        }
                        break;
                    }
                } else {
                    match = this.checkParameters(request, response, mappingInfo);
                }
                if (!match || (oldMappedMethod = targetHandlerMethods.put(mappingInfo, handlerMethod)) == null || oldMappedMethod == handlerMethod) continue;
                throw new IllegalStateException("Ambiguous handler methods mapped for portlet mode '" + lookupMode + "': {" + oldMappedMethod + ", " + handlerMethod + "}. If you intend to handle the same mode in multiple methods, then factor " + "them out into a dedicated handler class with that mode mapped at the type level!");
            }
            if (!targetHandlerMethods.isEmpty()) {
                if (targetHandlerMethods.size() == 1) {
                    return (Method)targetHandlerMethods.values().iterator().next();
                }
                Object bestMappingMatch = null;
                for (Object mapping : targetHandlerMethods.keySet()) {
                    if (bestMappingMatch == null) {
                        bestMappingMatch = mapping;
                        continue;
                    }
                    if ((bestMappingMatch.modes.length != 0 || mapping.modes.length <= 0) && bestMappingMatch.params.length >= mapping.params.length) continue;
                    bestMappingMatch = mapping;
                }
                return (Method)targetHandlerMethods.get(bestMappingMatch);
            }
            throw new UnavailableException("No matching handler method found for portlet request: mode '" + request.getPortletMode() + "', type '" + (response instanceof ActionResponse ? "action" : "render") + "', parameters " + StylerUtils.style((Object)request.getParameterMap()));
        }

        private boolean checkParameters(PortletRequest request, PortletResponse response, RequestMappingInfo mapping) {
            if (response instanceof RenderResponse ? mapping.action : response instanceof ActionResponse && mapping.render) {
                return false;
            }
            return PortletAnnotationMappingUtils.checkParameters(mapping.params, request);
        }

        private boolean isActionMethod(Method handlerMethod) {
            if (!Void.TYPE.equals(handlerMethod.getReturnType())) {
                return false;
            }
            for (Class<?> argType : handlerMethod.getParameterTypes()) {
                if (!ActionRequest.class.isAssignableFrom(argType) && !ActionResponse.class.isAssignableFrom(argType) && !InputStream.class.isAssignableFrom(argType) && !Reader.class.isAssignableFrom(argType)) continue;
                return true;
            }
            return false;
        }

        private boolean isRenderMethod(Method handlerMethod) {
            if (!Void.TYPE.equals(handlerMethod.getReturnType())) {
                return true;
            }
            for (Class<?> argType : handlerMethod.getParameterTypes()) {
                if (!RenderRequest.class.isAssignableFrom(argType) && !RenderResponse.class.isAssignableFrom(argType) && !OutputStream.class.isAssignableFrom(argType) && !Writer.class.isAssignableFrom(argType)) continue;
                return true;
            }
            return false;
        }
    }
}

