/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.utils;

import java.util.Arrays;

class ArraySorter {
    private Object[][] array;
    private int sortCol;
    private String sortOrder;

    private static void display(Object[][] array) {
        int rows = array.length;
        int cols = array[0].length;
        for (int i = 0; i < rows; ++i) {
            String rowData = "";
            for (int j = 0; j < cols; ++j) {
                rowData = rowData + array[i][j] + " ";
            }
            System.out.println(rowData);
        }
    }

    public ArraySorter(Object[][] array, int sortCol, String sortOrder) {
        this.array = array;
        this.sortCol = sortCol;
        this.sortOrder = sortOrder;
    }

    private int getRows() {
        return this.array.length;
    }

    private int getCols() {
        return this.array[0].length;
    }

    private Object[] getArrayToSort() {
        Object[] arrayToSort = new Object[this.getRows()];
        for (int i = 0; i < this.getRows(); ++i) {
            arrayToSort[i] = this.array[i];
        }
        return arrayToSort;
    }

    private ArraySorterEntry[] getArraySorterEntries() {
        Object[] arrayToSort = this.getArrayToSort();
        ArraySorterEntry[] arraySorterEntries = new ArraySorterEntry[this.getRows()];
        for (int i = 0; i < this.getRows(); ++i) {
            arraySorterEntries[i] = new ArraySorterEntry(arrayToSort[i], (Comparable)this.array[i][this.sortCol]);
        }
        return arraySorterEntries;
    }

    public Object[][] sort() {
        Object[] arraySorterEntries = this.getArraySorterEntries();
        Arrays.sort(arraySorterEntries);
        Object[][] returnArray = new Object[this.getRows()][this.getCols()];
        for (int i = 0; i < this.getRows(); ++i) {
            returnArray[i] = (Object[])((ArraySorterEntry)arraySorterEntries[i]).getSortedObject();
        }
        return returnArray;
    }

    public static void main(String[] args) throws Exception {
        Object[][] array = new Object[][]{{"7", "8", "9"}, {"1", "2", "3"}, {"4", "5", "6"}};
        System.out.println("unsorted array");
        ArraySorter.display(array);
        System.out.println("sorted array: asc on col 0");
        ArraySorter sorter = new ArraySorter(array, 0, "asc");
        ArraySorter.display(sorter.sort());
        System.out.println("sorted array: desc on col 0");
        sorter = new ArraySorter(array, 0, "desc");
        ArraySorter.display(sorter.sort());
        array = new Double[][]{{new Double(10.0), new Double(30.0)}, {new Double(20.0), new Double(40.0)}};
        System.out.println("sorted double array: desc on col 1");
        sorter = new ArraySorter(array, 1, "desc");
        ArraySorter.display(sorter.sort());
    }

    private class ArraySorterEntry
    implements Comparable {
        private Object arrayValueToSort;
        private Comparable valueToSortBy;

        public ArraySorterEntry(Object arrayValueToSort, Comparable valueToSortBy) {
            this.arrayValueToSort = arrayValueToSort;
            this.valueToSortBy = valueToSortBy;
        }

        public int compareTo(Object o) {
            ArraySorterEntry sorter = (ArraySorterEntry)o;
            int compare = this.valueToSortBy.compareTo(sorter.valueToSortBy);
            if (compare == 0 || "asc".equalsIgnoreCase(ArraySorter.this.sortOrder)) {
                return compare;
            }
            if ("desc".equalsIgnoreCase(ArraySorter.this.sortOrder)) {
                return -compare;
            }
            throw new RuntimeException("Programming error: The only valid sort orders are 'asc' and 'desc', but '" + ArraySorter.this.sortOrder + "' was passed");
        }

        public Object getSortedObject() {
            return this.arrayValueToSort;
        }
    }
}

