/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice.jdbc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.JDBCStoreQuery;
import org.apache.openjpa.kernel.ExpressionStoreQuery;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.OrderingMergedResultObjectProvider;
import org.apache.openjpa.kernel.QueryContext;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.exps.ExpressionParser;
import org.apache.openjpa.lib.rop.MergedResultObjectProvider;
import org.apache.openjpa.lib.rop.RangeResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.slice.jdbc.DistributedJDBCConfiguration;
import org.apache.openjpa.slice.jdbc.DistributedStoreManager;
import org.apache.openjpa.slice.jdbc.SliceStoreManager;
import org.apache.openjpa.slice.jdbc.UniqueResultObjectProvider;
import org.apache.openjpa.util.StoreException;

class DistributedStoreQuery
extends JDBCStoreQuery {
    private List<StoreQuery> _queries = new ArrayList<StoreQuery>();
    private ExpressionParser _parser;

    public DistributedStoreQuery(JDBCStore store, ExpressionParser parser) {
        super(store, parser);
        this._parser = parser;
    }

    void add(StoreQuery q) {
        this._queries.add(q);
    }

    public StoreQuery.Executor newDataStoreExecutor(ClassMetaData meta, boolean subs) {
        ParallelExecutor ex = new ParallelExecutor(this, meta, subs, this._parser, this.ctx.getCompilation());
        FetchConfiguration fetch = this.getContext().getFetchConfiguration();
        DistributedStoreManager store = (DistributedStoreManager)this.getContext().getStoreContext().getStoreManager().getInnermostDelegate();
        List<SliceStoreManager> targets = store.getTargets(fetch);
        for (StoreQuery q : this._queries) {
            if (!targets.contains(((JDBCStoreQuery)q).getStore())) continue;
            ex.addExecutor(q.newDataStoreExecutor(meta, subs));
        }
        return ex;
    }

    public void setContext(QueryContext ctx) {
        super.setContext(ctx);
        for (StoreQuery q : this._queries) {
            q.setContext(ctx);
        }
    }

    public ExecutorService getExecutorServiceInstance() {
        DistributedJDBCConfiguration conf = (DistributedJDBCConfiguration)this.getStore().getConfiguration();
        return conf.getExecutorServiceInstance();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UpdateExecutor
    implements Callable<Number> {
        StoreQuery query;
        StoreQuery.Executor executor;
        Object[] params;

        UpdateExecutor() {
        }

        @Override
        public Number call() throws Exception {
            return this.executor.executeDelete(this.query, this.params);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DeleteExecutor
    implements Callable<Number> {
        StoreQuery query;
        StoreQuery.Executor executor;
        Object[] params;

        DeleteExecutor() {
        }

        @Override
        public Number call() throws Exception {
            return this.executor.executeDelete(this.query, this.params);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class QueryExecutor
    implements Callable<ResultObjectProvider> {
        StoreQuery query;
        StoreQuery.Executor executor;
        Object[] params;
        StoreQuery.Range range;

        QueryExecutor() {
        }

        @Override
        public ResultObjectProvider call() throws Exception {
            return this.executor.executeQuery(this.query, this.params, this.range);
        }
    }

    public static class ParallelExecutor
    extends ExpressionStoreQuery.DataStoreExecutor {
        private List<StoreQuery.Executor> executors = new ArrayList<StoreQuery.Executor>();
        private DistributedStoreQuery owner = null;
        private ExecutorService threadPool = null;

        public void addExecutor(StoreQuery.Executor ex) {
            this.executors.add(ex);
        }

        public ParallelExecutor(DistributedStoreQuery dsq, ClassMetaData meta, boolean subclasses, ExpressionParser parser, Object parsed) {
            super(dsq, meta, subclasses, parser, parsed);
            this.owner = dsq;
            this.threadPool = dsq.getExecutorServiceInstance();
        }

        public ResultObjectProvider executeQuery(StoreQuery q, Object[] params, StoreQuery.Range range) {
            ResultObjectProvider[] tmp = new ResultObjectProvider[this.executors.size()];
            Iterator qs = this.owner._queries.iterator();
            ArrayList<Future<ResultObjectProvider>> futures = new ArrayList<Future<ResultObjectProvider>>();
            int i = 0;
            for (StoreQuery.Executor executor : this.executors) {
                QueryExecutor call = new QueryExecutor();
                call.executor = executor;
                call.query = (StoreQuery)qs.next();
                call.params = params;
                call.range = range;
                futures.add(this.threadPool.submit(call));
            }
            for (Future future : futures) {
                try {
                    tmp[i++] = (ResultObjectProvider)future.get();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new StoreException(e.getCause());
                }
            }
            boolean[] ascending = this.getAscending(q);
            boolean bl = ascending.length > 0;
            boolean isUnique = q.getContext().isUnique();
            boolean hasRange = q.getContext().getEndRange() != Long.MAX_VALUE;
            ResultObjectProvider result = null;
            result = isUnique ? new UniqueResultObjectProvider(tmp, q, this.getQueryExpressions()) : (bl ? new OrderingMergedResultObjectProvider(tmp, ascending, this.executors.toArray(new StoreQuery.Executor[this.executors.size()]), q, params) : new MergedResultObjectProvider(tmp));
            if (hasRange) {
                result = new RangeResultObjectProvider(result, q.getContext().getStartRange(), q.getContext().getEndRange());
            }
            return result;
        }

        public Number executeDelete(StoreQuery q, Object[] params) {
            Iterator qs = this.owner._queries.iterator();
            ArrayList<Future<Number>> futures = new ArrayList<Future<Number>>();
            for (StoreQuery.Executor ex : this.executors) {
                DeleteExecutor deleteExecutor = new DeleteExecutor();
                deleteExecutor.executor = ex;
                deleteExecutor.query = (StoreQuery)qs.next();
                deleteExecutor.params = params;
                futures.add(this.threadPool.submit(deleteExecutor));
            }
            int N = 0;
            for (Future future : futures) {
                try {
                    Number n = (Number)future.get();
                    if (n == null) continue;
                    N += n.intValue();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new StoreException(e.getCause());
                }
            }
            return new Integer(N);
        }

        public Number executeUpdate(StoreQuery q, Object[] params) {
            Iterator qs = this.owner._queries.iterator();
            ArrayList<Future<Number>> futures = new ArrayList<Future<Number>>();
            for (StoreQuery.Executor ex : this.executors) {
                UpdateExecutor updateExecutor = new UpdateExecutor();
                updateExecutor.executor = ex;
                updateExecutor.query = (StoreQuery)qs.next();
                updateExecutor.params = params;
                futures.add(this.threadPool.submit(updateExecutor));
            }
            int N = 0;
            for (Future future : futures) {
                try {
                    Number n = (Number)future.get();
                    if (n == null) continue;
                    N += n.intValue();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new StoreException(e.getCause());
                }
            }
            return new Integer(N);
        }
    }
}

