/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.context;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.context.TilesContextFactory;
import org.apache.tiles.context.TilesRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedTilesContextFactory
implements TilesContextFactory {
    public static final String FACTORY_CLASS_NAMES = "org.apache.tiles.context.ChainTilesContextFactory.FACTORY_CLASS_NAMES";
    public static final String[] DEFAULT_FACTORY_CLASS_NAMES = new String[]{"org.apache.tiles.servlet.context.ServletTilesContextFactory", "org.apache.tiles.portlet.context.PortletTilesContextFactory", "org.apache.tiles.jsp.context.JspTilesContextFactory"};
    private static final Log LOG = LogFactory.getLog(ChainedTilesContextFactory.class);
    private TilesContextFactory[] factories;

    @Override
    public void init(Map<String, String> configParameters) {
        String[] classNames = null;
        String classNamesString = configParameters.get(FACTORY_CLASS_NAMES);
        if (classNamesString != null) {
            classNames = classNamesString.split("\\s*,\\s*");
        }
        if (classNames == null || classNames.length <= 0) {
            classNames = DEFAULT_FACTORY_CLASS_NAMES;
        }
        ArrayList<TilesContextFactory> factoryList = new ArrayList<TilesContextFactory>();
        for (int i = 0; i < classNames.length; ++i) {
            try {
                Class<?> clazz = Class.forName(classNames[i]);
                if (!TilesContextFactory.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException("The class " + classNames[i] + " does not implement TilesContextFactory");
                }
                TilesContextFactory factory = (TilesContextFactory)clazz.newInstance();
                factoryList.add(factory);
                continue;
            }
            catch (ClassNotFoundException e) {
                LOG.warn((Object)("Cannot find TilesContextFactory class " + classNames[i]));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Cannot find TilesContextFactory class " + classNames[i]), (Throwable)e);
                continue;
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Cannot instantiate TilesFactoryClass " + classNames[i], e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot access TilesFactoryClass " + classNames[i] + " default constructor", e);
            }
        }
        this.factories = new TilesContextFactory[factoryList.size()];
        factoryList.toArray(this.factories);
    }

    @Override
    public TilesApplicationContext createApplicationContext(Object context) {
        TilesApplicationContext retValue = null;
        for (int i = 0; i < this.factories.length && retValue == null; ++i) {
            retValue = this.factories[i].createApplicationContext(context);
        }
        if (retValue == null) {
            throw new IllegalArgumentException("Cannot find a factory to create the application context");
        }
        return retValue;
    }

    @Override
    public TilesRequestContext createRequestContext(TilesApplicationContext context, Object ... requestItems) {
        TilesRequestContext retValue = null;
        for (int i = 0; i < this.factories.length && retValue == null; ++i) {
            retValue = this.factories[i].createRequestContext(context, requestItems);
        }
        if (retValue == null) {
            throw new IllegalArgumentException("Cannot find a factory to create the request context");
        }
        return retValue;
    }
}

