/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.internal.ProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.util.PartialOrder;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AsmRelationshipUtils;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.DeclareErrorOrWarning;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;

public abstract class ShadowMunger
implements PartialOrder.PartialComparable,
IHasPosition {
    protected Pointcut pointcut;
    protected int start;
    protected int end;
    protected ISourceContext sourceContext;
    private ISourceLocation sourceLocation;
    private ISourceLocation binarySourceLocation;
    private File binaryFile;
    private String handle = null;
    private ResolvedType declaringType;
    public static final ShadowMunger[] NONE = new ShadowMunger[0];
    private boolean isBinary;
    private boolean checkedIsBinary;

    public ShadowMunger(Pointcut pointcut, int start, int end, ISourceContext sourceContext) {
        this.pointcut = pointcut;
        this.start = start;
        this.end = end;
        this.sourceContext = sourceContext;
    }

    public abstract ShadowMunger concretize(ResolvedType var1, World var2, PerClause var3);

    public abstract void specializeOn(Shadow var1);

    public abstract void implementOn(Shadow var1);

    public boolean match(Shadow shadow, World world) {
        return this.pointcut.match(shadow).maybeTrue();
    }

    public abstract ShadowMunger parameterizeWith(ResolvedType var1, Map var2);

    public int fallbackCompareTo(Object other) {
        return this.toString().compareTo(this.toString());
    }

    public int getEnd() {
        return this.end;
    }

    public int getStart() {
        return this.start;
    }

    public ISourceLocation getSourceLocation() {
        if (this.sourceLocation == null && this.sourceContext != null) {
            this.sourceLocation = this.sourceContext.makeSourceLocation(this);
        }
        if (this.isBinary()) {
            if (this.binarySourceLocation == null) {
                this.binarySourceLocation = this.getBinarySourceLocation(this.sourceLocation);
            }
            return this.binarySourceLocation;
        }
        return this.sourceLocation;
    }

    public String getHandle() {
        ISourceLocation sl;
        if (null == this.handle && (sl = this.getSourceLocation()) != null) {
            IProgramElement ipe = AsmManager.getDefault().getHierarchy().findElementForSourceLine(sl);
            this.handle = AsmManager.getDefault().getHandleProvider().createHandleIdentifier(ipe);
        }
        return this.handle;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public void setPointcut(Pointcut pointcut) {
        this.pointcut = pointcut;
    }

    public void setDeclaringType(ResolvedType aType) {
        this.declaringType = aType;
    }

    public ResolvedType getDeclaringType() {
        return this.declaringType;
    }

    public abstract Collection getThrownExceptions();

    public abstract boolean mustCheckExceptions();

    public void createHierarchy() {
        if (!this.isBinary()) {
            return;
        }
        IProgramElement sourceFileNode = AsmManager.getDefault().getHierarchy().findElementForSourceLine(this.getSourceLocation());
        if (!sourceFileNode.getKind().equals(IProgramElement.Kind.FILE_JAVA)) {
            return;
        }
        ResolvedType aspect = this.getDeclaringType();
        ProgramElement classFileNode = new ProgramElement(sourceFileNode.getName(), IProgramElement.Kind.FILE, this.getBinarySourceLocation(aspect.getSourceLocation()), 0, null, null);
        IProgramElement root = AsmManager.getDefault().getHierarchy().getRoot();
        IProgramElement binaries = AsmManager.getDefault().getHierarchy().findElementForLabel(root, IProgramElement.Kind.SOURCE_FOLDER, "binaries");
        if (binaries == null) {
            binaries = new ProgramElement("binaries", IProgramElement.Kind.SOURCE_FOLDER, new ArrayList());
            root.addChild(binaries);
        }
        String packagename = aspect.getPackageName() == null ? "" : aspect.getPackageName();
        IProgramElement pkgNode = AsmManager.getDefault().getHierarchy().findElementForLabel(binaries, IProgramElement.Kind.PACKAGE, packagename);
        if (pkgNode == null) {
            pkgNode = new ProgramElement(packagename, IProgramElement.Kind.PACKAGE, new ArrayList());
            binaries.addChild(pkgNode);
            pkgNode.addChild(classFileNode);
        } else {
            pkgNode.addChild(classFileNode);
            Iterator iter = pkgNode.getChildren().iterator();
            while (iter.hasNext()) {
                IProgramElement element = (IProgramElement)iter.next();
                if (element.equals(classFileNode) || !element.getHandleIdentifier().equals(classFileNode.getHandleIdentifier())) continue;
                pkgNode.removeChild(classFileNode);
                return;
            }
        }
        classFileNode.addChild(new ProgramElement("import declarations", IProgramElement.Kind.IMPORT_REFERENCE, null, 0, null, null));
        ProgramElement aspectNode = new ProgramElement(aspect.getSimpleName(), IProgramElement.Kind.ASPECT, this.getBinarySourceLocation(aspect.getSourceLocation()), aspect.getModifiers(), null, null);
        classFileNode.addChild(aspectNode);
        this.addChildNodes((IProgramElement)aspectNode, aspect.getDeclaredPointcuts());
        this.addChildNodes((IProgramElement)aspectNode, aspect.getDeclaredAdvice());
        this.addChildNodes((IProgramElement)aspectNode, aspect.getDeclares());
    }

    private void addChildNodes(IProgramElement parent, ResolvedMember[] children) {
        for (int i = 0; i < children.length; ++i) {
            ResolvedMember pcd = children[i];
            if (!(pcd instanceof ResolvedPointcutDefinition)) continue;
            ResolvedPointcutDefinition rpcd = (ResolvedPointcutDefinition)pcd;
            ISourceLocation sLoc = rpcd.getPointcut().getSourceLocation();
            if (sLoc == null) {
                sLoc = rpcd.getSourceLocation();
            }
            parent.addChild(new ProgramElement(pcd.getName(), IProgramElement.Kind.POINTCUT, this.getBinarySourceLocation(sLoc), pcd.getModifiers(), null, Collections.EMPTY_LIST));
        }
    }

    private void addChildNodes(IProgramElement parent, Collection children) {
        int deCtr = 1;
        int dwCtr = 1;
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof DeclareErrorOrWarning) {
                DeclareErrorOrWarning decl = (DeclareErrorOrWarning)element;
                int counter = 0;
                counter = decl.isError() ? deCtr++ : dwCtr++;
                parent.addChild(this.createDeclareErrorOrWarningChild(decl, counter));
                continue;
            }
            if (!(element instanceof Advice)) continue;
            Advice advice = (Advice)element;
            parent.addChild(this.createAdviceChild(advice));
        }
    }

    private IProgramElement createDeclareErrorOrWarningChild(DeclareErrorOrWarning decl, int count) {
        ProgramElement deowNode = new ProgramElement(decl.getName(), decl.isError() ? IProgramElement.Kind.DECLARE_ERROR : IProgramElement.Kind.DECLARE_WARNING, this.getBinarySourceLocation(decl.getSourceLocation()), decl.getDeclaringType().getModifiers(), null, null);
        deowNode.setDetails("\"" + AsmRelationshipUtils.genDeclareMessage(decl.getMessage()) + "\"");
        if (count != -1) {
            deowNode.setBytecodeName(decl.getName() + "_" + count);
        }
        return deowNode;
    }

    private IProgramElement createAdviceChild(Advice advice) {
        ProgramElement adviceNode = new ProgramElement(advice.kind.getName(), IProgramElement.Kind.ADVICE, this.getBinarySourceLocation(advice.getSourceLocation()), advice.signature.getModifiers(), null, Collections.EMPTY_LIST);
        adviceNode.setDetails(AsmRelationshipUtils.genPointcutDetails(advice.getPointcut()));
        adviceNode.setBytecodeName(advice.getSignature().getName());
        return adviceNode;
    }

    private ISourceLocation getBinarySourceLocation(ISourceLocation sl) {
        if (sl == null) {
            return null;
        }
        String sourceFileName = null;
        if (this.getDeclaringType() instanceof ReferenceType) {
            String s = ((ReferenceType)this.getDeclaringType()).getDelegate().getSourcefilename();
            int i = s.lastIndexOf(47);
            sourceFileName = i != -1 ? s.substring(i + 1) : s;
        }
        SourceLocation sLoc = new SourceLocation(this.getBinaryFile(), sl.getLine(), sl.getEndLine(), sl.getColumn() == 0 ? -2147483647 : sl.getColumn(), sl.getContext(), sourceFileName);
        return sLoc;
    }

    private File getBinaryFile() {
        if (this.binaryFile == null) {
            String s = this.getDeclaringType().getBinaryPath();
            File f = this.getDeclaringType().getSourceLocation().getSourceFile();
            int i = f.getPath().lastIndexOf(46);
            String path = f.getPath().substring(0, i) + ".class";
            this.binaryFile = new File(s + "!" + path);
        }
        return this.binaryFile;
    }

    protected boolean isBinary() {
        if (!this.checkedIsBinary) {
            ResolvedType rt = this.getDeclaringType();
            if (rt != null) {
                this.isBinary = rt.getBinaryPath() != null;
            }
            this.checkedIsBinary = true;
        }
        return this.isBinary;
    }

    public abstract /* synthetic */ int compareTo(Object var1);
}

