/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.brooklyn.core.mgmt.persist;

import static org.testng.Assert.assertEquals;

import org.testng.annotations.Test;

public class DeserializingJcloudsRenamesProviderTest {

    @Test
    public void testRenameNoop() throws Exception {
        assertEquals(rename("aws-ec2"), "aws-ec2");
    }

    @Test
    public void testRenamesDefinedInClasspathFile() throws Exception {
        assertEquals(rename("openstack-mitaka-nova"), "openstack-nova");
        assertEquals(rename("openstack-devtest-compute"), "openstack-nova");
    }
    
    protected String rename(String val) throws Exception {
        return DeserializingJcloudsRenamesProvider.INSTANCE.applyJcloudsRenames(val);
    }
}
