/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.converters.InetAddressConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class InetAddressConverterTest {
    private InetAddressConverter converter;

    @BeforeEach
    public void before() {
        this.converter = new InetAddressConverter();
    }

    @Test
    public void testConvertingIpv4() throws UnknownHostException {
        InetAddress expected = InetAddress.getByName("192.168.0.1");
        InetAddress actual = (InetAddress)this.converter.convert(InetAddress.class, (Object)"192.168.0.1");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testConvertingIpv6() throws UnknownHostException {
        InetAddress expected = InetAddress.getByName("2001:db8:0:1234:0:567:8:1");
        InetAddress actual = (InetAddress)this.converter.convert(InetAddress.class, (Object)"2001:db8:0:1234:0:567:8:1");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testConvertingLocalhost() throws UnknownHostException {
        InetAddress expected = InetAddress.getByName("127.0.0.1");
        InetAddress actual = (InetAddress)this.converter.convert(InetAddress.class, (Object)"localhost");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testInvalidIp() {
        Assertions.assertThrows(ConversionException.class, () -> this.converter.convert(InetAddress.class, (Object)"512.512.512.512"));
    }

    @Test
    public void testText() {
        Assertions.assertThrows(ConversionException.class, () -> this.converter.convert(InetAddress.class, (Object)"Hello, world!"));
    }
}

