/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.time.OffsetTime;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.OffsetTimeConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OffsetTimeConverterTest {
    private Converter<OffsetTime> converter;

    protected Class<?> getExpectedType() {
        return OffsetTime.class;
    }

    protected Converter<OffsetTime> makeConverter() {
        return new OffsetTimeConverter();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.converter = this.makeConverter();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Test
    public void testSimpleConversion() throws Exception {
        int i;
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from String"};
        Object[] input = new Object[]{"10:15+01:00", "08:45:30+14:00"};
        OffsetTime[] expected = new OffsetTime[]{OffsetTime.parse("10:15+01:00"), OffsetTime.parse("08:45:30+14:00")};
        for (i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)this.converter.convert(OffsetTime.class, input[i]), (String)(message[i] + " to URI"));
            Assertions.assertEquals((Object)expected[i], (Object)this.converter.convert(null, input[i]), (String)(message[i] + " to null type"));
        }
        for (i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)input[i], (Object)this.converter.convert(String.class, (Object)expected[i]), (String)(input[i] + " to String"));
        }
    }

    @Test
    public void testUnsupportedType() {
        Assertions.assertThrows(ConversionException.class, () -> this.converter.convert(Integer.class, (Object)"http://www.apache.org"));
    }
}

