/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import org.apache.commons.jxpath.AbstractJXPathTest;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Variables;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CoreOperationTest
extends AbstractJXPathTest {
    private JXPathContext context;

    @Override
    @BeforeEach
    public void setUp() {
        if (this.context == null) {
            this.context = JXPathContext.newContext(null);
            Variables vars = this.context.getVariables();
            vars.declareVariable("integer", (Object)1);
            vars.declareVariable("array", (Object)new double[]{0.25, 0.5, 0.75});
            vars.declareVariable("nan", (Object)Double.NaN);
        }
    }

    @Test
    public void testEmptyNodeSetOperations() {
        this.assertXPathValue(this.context, "/idonotexist = 0", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "/idonotexist != 0", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "/idonotexist < 0", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "/idonotexist > 0", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "/idonotexist >= 0", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "/idonotexist <= 0", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$array[position() < 1] = 0", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$array[position() < 1] != 0", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$array[position() < 1] < 0", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$array[position() < 1] > 0", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$array[position() < 1] >= 0", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$array[position() < 1] <= 0", Boolean.FALSE, Boolean.class);
    }

    @Test
    public void testInfoSetTypes() {
        this.assertXPathValue(this.context, "1", 1.0);
        this.assertXPathPointer(this.context, "1", "1");
        this.assertXPathValueIterator(this.context, "1", CoreOperationTest.list(1.0));
        this.assertXPathPointerIterator(this.context, "1", CoreOperationTest.list("1"));
        this.assertXPathValue(this.context, "-1", -1.0);
        this.assertXPathValue(this.context, "2 + 2", 4.0);
        this.assertXPathValue(this.context, "3 - 2", 1.0);
        this.assertXPathValue(this.context, "1 + 2 + 3 - 4 + 5", 7.0);
        this.assertXPathValue(this.context, "3 * 2", 6.0);
        this.assertXPathValue(this.context, "3 div 2", 1.5);
        this.assertXPathValue(this.context, "5 mod 2", 1.0);
        this.assertXPathValue(this.context, "5.9 mod 2.1", 1.0);
        this.assertXPathValue(this.context, "5 mod -2", 1.0);
        this.assertXPathValue(this.context, "-5 mod 2", -1.0);
        this.assertXPathValue(this.context, "-5 mod -2", -1.0);
        this.assertXPathValue(this.context, "1 < 2", Boolean.TRUE);
        this.assertXPathValue(this.context, "1 > 2", Boolean.FALSE);
        this.assertXPathValue(this.context, "1 <= 1", Boolean.TRUE);
        this.assertXPathValue(this.context, "1 >= 2", Boolean.FALSE);
        this.assertXPathValue(this.context, "3 > 2 > 1", Boolean.FALSE);
        this.assertXPathValue(this.context, "3 > 2 and 2 > 1", Boolean.TRUE);
        this.assertXPathValue(this.context, "3 > 2 and 2 < 1", Boolean.FALSE);
        this.assertXPathValue(this.context, "3 < 2 or 2 > 1", Boolean.TRUE);
        this.assertXPathValue(this.context, "3 < 2 or 2 < 1", Boolean.FALSE);
        this.assertXPathValue(this.context, "1 = 1", Boolean.TRUE);
        this.assertXPathValue(this.context, "1 = '1'", Boolean.TRUE);
        this.assertXPathValue(this.context, "1 > 2 = 2 > 3", Boolean.TRUE);
        this.assertXPathValue(this.context, "1 > 2 = 0", Boolean.TRUE);
        this.assertXPathValue(this.context, "1 = 2", Boolean.FALSE);
        this.assertXPathValue(this.context, "$integer", 1.0, Double.class);
        this.assertXPathValue(this.context, "2 + 3", "5.0", String.class);
        this.assertXPathValue(this.context, "2 + 3", Boolean.TRUE, Boolean.TYPE);
        this.assertXPathValue(this.context, "'true'", Boolean.TRUE, Boolean.class);
    }

    @Test
    public void testNan() {
        this.assertXPathValue(this.context, "$nan > $nan", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$nan < $nan", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$nan >= $nan", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$nan <= $nan", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$nan >= $nan and $nan <= $nan", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$nan = $nan", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$nan != $nan", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$nan > 0", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$nan < 0", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$nan >= 0", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$nan <= 0", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$nan >= 0 and $nan <= 0", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$nan = 0", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$nan != 0", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$nan > 1", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$nan < 1", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$nan >= 1", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$nan <= 1", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$nan >= 1 and $nan <= 1", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$nan = 1", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$nan != 1", Boolean.FALSE, Boolean.class);
    }

    @Test
    public void testNodeSetOperations() {
        this.assertXPathValue(this.context, "$array > 0", Boolean.TRUE, Boolean.class);
        this.assertXPathValue(this.context, "$array >= 0", Boolean.TRUE, Boolean.class);
        this.assertXPathValue(this.context, "$array = 0", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$array = 0.25", Boolean.TRUE, Boolean.class);
        this.assertXPathValue(this.context, "$array = 0.5", Boolean.TRUE, Boolean.class);
        this.assertXPathValue(this.context, "$array = 0.50000", Boolean.TRUE, Boolean.class);
        this.assertXPathValue(this.context, "$array = 0.75", Boolean.TRUE, Boolean.class);
        this.assertXPathValue(this.context, "$array < 1", Boolean.TRUE, Boolean.class);
        this.assertXPathValue(this.context, "$array <= 1", Boolean.TRUE, Boolean.class);
        this.assertXPathValue(this.context, "$array = 1", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$array > 1", Boolean.FALSE, Boolean.class);
        this.assertXPathValue(this.context, "$array < 0", Boolean.FALSE, Boolean.class);
    }
}

