/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.genetics;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.commons.math3.genetics.DummyRandomKey;
import org.apache.commons.math3.genetics.RandomKey;
import org.junit.Assert;
import org.junit.Test;

public class RandomKeyTest {
    @Test(expected=IllegalArgumentException.class)
    public void testConstructor1() {
        new DummyRandomKey(new Double[]{0.2, 0.3, 1.2});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor2() {
        new DummyRandomKey(new Double[]{0.2, 0.3, -0.2});
    }

    @Test
    public void testIsSame() {
        DummyRandomKey drk1 = new DummyRandomKey(new Double[]{0.4, 0.1, 0.5, 0.8, 0.2});
        DummyRandomKey drk2 = new DummyRandomKey(new Double[]{0.4, 0.1, 0.5, 0.8, 0.2});
        DummyRandomKey drk3 = new DummyRandomKey(new Double[]{0.4, 0.15, 0.5, 0.8, 0.2});
        DummyRandomKey drk4 = new DummyRandomKey(new Double[]{0.4, 0.25, 0.5, 0.8, 0.2});
        DummyRandomKey drk5 = new DummyRandomKey(new Double[]{0.4, 0.25, 0.5, 0.8, 0.2, 0.5});
        Assert.assertTrue((boolean)drk1.isSame((Chromosome)drk2));
        Assert.assertTrue((boolean)drk2.isSame((Chromosome)drk3));
        Assert.assertFalse((boolean)drk3.isSame((Chromosome)drk4));
        Assert.assertFalse((boolean)drk4.isSame((Chromosome)drk5));
    }

    @Test
    public void testDecode() {
        DummyRandomKey drk = new DummyRandomKey(new Double[]{0.4, 0.1, 0.5, 0.8, 0.2});
        List decoded = drk.decode(Arrays.asList("a", "b", "c", "d", "e"));
        Assert.assertEquals((Object)"b", decoded.get(0));
        Assert.assertEquals((Object)"e", decoded.get(1));
        Assert.assertEquals((Object)"a", decoded.get(2));
        Assert.assertEquals((Object)"c", decoded.get(3));
        Assert.assertEquals((Object)"d", decoded.get(4));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidRepresentation() {
        new DummyRandomKey(new Double[]{0.1, 0.1, 2.0, 0.8, 0.2});
    }

    @Test
    public void testRandomPermutation() {
        for (int i = 0; i < 10; ++i) {
            DummyRandomKey drk = new DummyRandomKey(RandomKey.randomPermutation((int)20));
            Assert.assertNotNull((Object)((Object)drk));
        }
    }

    @Test
    public void testIdentityPermutation() {
        DummyRandomKey drk = new DummyRandomKey(RandomKey.identityPermutation((int)5));
        List decoded = drk.decode(Arrays.asList("a", "b", "c", "d", "e"));
        Assert.assertEquals((Object)"a", decoded.get(0));
        Assert.assertEquals((Object)"b", decoded.get(1));
        Assert.assertEquals((Object)"c", decoded.get(2));
        Assert.assertEquals((Object)"d", decoded.get(3));
        Assert.assertEquals((Object)"e", decoded.get(4));
    }

    @Test
    public void testComparatorPermutation() {
        List<String> data = Arrays.asList("x", "b", "c", "z", "b");
        List permutation = RandomKey.comparatorPermutation(data, (Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        Object[] permArr = new Double[data.size()];
        permArr = permutation.toArray(permArr);
        Assert.assertArrayEquals((Object[])new Double[]{0.6, 0.0, 0.4, 0.8, 0.2}, (Object[])permArr);
        List decodedData = new DummyRandomKey(permutation).decode(data);
        Assert.assertEquals((Object)"b", decodedData.get(0));
        Assert.assertEquals((Object)"b", decodedData.get(1));
        Assert.assertEquals((Object)"c", decodedData.get(2));
        Assert.assertEquals((Object)"x", decodedData.get(3));
        Assert.assertEquals((Object)"z", decodedData.get(4));
        permutation = RandomKey.comparatorPermutation(data, (Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.compareTo(o1);
            }
        });
        permArr = new Double[data.size()];
        permArr = (Double[])permutation.toArray(permArr);
        Assert.assertArrayEquals((Object[])new Double[]{0.2, 0.6, 0.4, 0.0, 0.8}, (Object[])permArr);
        decodedData = new DummyRandomKey(permutation).decode(data);
        Assert.assertEquals((Object)"z", decodedData.get(0));
        Assert.assertEquals((Object)"x", decodedData.get(1));
        Assert.assertEquals((Object)"c", decodedData.get(2));
        Assert.assertEquals((Object)"b", decodedData.get(3));
        Assert.assertEquals((Object)"b", decodedData.get(4));
    }

    @Test
    public void testInducedPermutation() {
        List<String> origData = Arrays.asList("a", "b", "c", "d", "d");
        List<String> permutedData = Arrays.asList("d", "b", "c", "a", "d");
        DummyRandomKey drk = new DummyRandomKey(RandomKey.inducedPermutation(origData, permutedData));
        List decoded = drk.decode(origData);
        Assert.assertEquals((Object)"d", decoded.get(0));
        Assert.assertEquals((Object)"b", decoded.get(1));
        Assert.assertEquals((Object)"c", decoded.get(2));
        Assert.assertEquals((Object)"a", decoded.get(3));
        Assert.assertEquals((Object)"d", decoded.get(4));
        try {
            RandomKey.inducedPermutation(Arrays.asList("a", "b", "c", "d", "d"), Arrays.asList("a", "b", "c", "d"));
            Assert.fail((String)"Uncaught exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            RandomKey.inducedPermutation(Arrays.asList("a", "b", "c", "d", "d"), Arrays.asList("a", "b", "c", "d", "f"));
            Assert.fail((String)"Uncaught exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testEqualRepr() {
        DummyRandomKey drk = new DummyRandomKey(new Double[]{0.2, 0.2, 0.5});
        List decodedData = drk.decode(Arrays.asList("a", "b", "c"));
        Assert.assertEquals((Object)"a", decodedData.get(0));
        Assert.assertEquals((Object)"b", decodedData.get(1));
        Assert.assertEquals((Object)"c", decodedData.get(2));
    }
}

