/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.descriptive.rank;

import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.exception.MathIllegalArgumentException;
import org.apache.commons.math4.legacy.exception.NotPositiveException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.exception.NumberIsTooLargeException;
import org.apache.commons.math4.legacy.exception.OutOfRangeException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.math4.legacy.stat.descriptive.AbstractUnivariateStatistic;
import org.apache.commons.math4.legacy.stat.descriptive.rank.KthSelector;
import org.apache.commons.math4.legacy.stat.descriptive.rank.MedianOf3PivotingStrategy;
import org.apache.commons.math4.legacy.stat.descriptive.rank.PivotingStrategy;
import org.apache.commons.math4.legacy.stat.ranking.NaNStrategy;
import org.apache.commons.numbers.arrays.SortInPlace;
import org.apache.commons.numbers.core.Precision;

public class Percentile
extends AbstractUnivariateStatistic {
    private static final int MAX_CACHED_LEVELS = 10;
    private static final int PIVOTS_HEAP_LENGTH = 512;
    private final KthSelector kthSelector;
    private final EstimationType estimationType;
    private final NaNStrategy nanStrategy;
    private double quantile;
    private int[] cachedPivots;
    private double[] weights;

    public Percentile() {
        this(50.0);
    }

    public Percentile(double quantile) {
        this(quantile, EstimationType.LEGACY, NaNStrategy.REMOVED, new KthSelector(new MedianOf3PivotingStrategy()));
    }

    public Percentile(Percentile original) {
        NullArgumentException.check((Object)original);
        this.estimationType = original.getEstimationType();
        this.nanStrategy = original.getNaNStrategy();
        this.kthSelector = original.getKthSelector();
        this.setData(original.getDataRef());
        if (original.cachedPivots != null) {
            System.arraycopy(original.cachedPivots, 0, this.cachedPivots, 0, original.cachedPivots.length);
        }
        this.setQuantile(original.quantile);
    }

    protected Percentile(double quantile, EstimationType estimationType, NaNStrategy nanStrategy, KthSelector kthSelector) {
        this.setQuantile(quantile);
        this.cachedPivots = null;
        NullArgumentException.check((Object)((Object)estimationType));
        NullArgumentException.check((Object)((Object)nanStrategy));
        NullArgumentException.check((Object)kthSelector);
        this.estimationType = estimationType;
        this.nanStrategy = nanStrategy;
        this.kthSelector = kthSelector;
    }

    @Override
    public void setData(double[] values) {
        if (values == null) {
            this.cachedPivots = null;
        } else {
            this.cachedPivots = new int[512];
            Arrays.fill(this.cachedPivots, -1);
        }
        super.setData(values);
    }

    public void setData(double[] values, double[] sampleWeights) {
        this.setData(values, sampleWeights, 0, values.length);
    }

    @Override
    public void setData(double[] values, int begin, int length) {
        if (values == null) {
            this.cachedPivots = null;
        } else {
            this.cachedPivots = new int[512];
            Arrays.fill(this.cachedPivots, -1);
        }
        super.setData(values, begin, length);
    }

    public void setData(double[] values, double[] sampleWeights, int begin, int length) {
        if (begin < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.START_POSITION, (Number)begin);
        }
        if (length < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.LENGTH, (Number)length);
        }
        if (begin + length > values.length) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SUBARRAY_ENDS_AFTER_ARRAY_END, (Number)(begin + length), (Number)values.length, true);
        }
        if (sampleWeights == null) {
            throw new MathIllegalArgumentException((Localizable)LocalizedFormats.NULL_NOT_ALLOWED, new Object[0]);
        }
        this.cachedPivots = new int[512];
        Arrays.fill(this.cachedPivots, -1);
        if (values.length != sampleWeights.length) {
            throw new MathIllegalArgumentException((Localizable)LocalizedFormats.LENGTH, new Object[]{values, sampleWeights});
        }
        MathArrays.checkPositive((double[])sampleWeights);
        MathArrays.checkNotNaN((double[])sampleWeights);
        super.setData(values, begin, length);
        this.weights = new double[length];
        System.arraycopy(sampleWeights, begin, this.weights, 0, length);
    }

    public double evaluate(double p) {
        if (this.weights == null) {
            return this.evaluate(this.getDataRef(), p);
        }
        return this.evaluate(this.getDataRef(), this.weights, p);
    }

    public double evaluate(double[] values, double p) {
        MathArrays.verifyValues((double[])values, (int)0, (int)0);
        return this.evaluate(values, 0, values.length, p);
    }

    public double evaluate(double[] values, double[] sampleWeights, double p) {
        MathArrays.verifyValues((double[])values, (int)0, (int)0);
        MathArrays.verifyValues((double[])sampleWeights, (int)0, (int)0);
        return this.evaluate(values, sampleWeights, 0, values.length, p);
    }

    @Override
    public double evaluate(double[] values, int start, int length) {
        return this.evaluate(values, start, length, this.quantile);
    }

    public double evaluate(double[] values, double[] sampleWeights, int start, int length) {
        return this.evaluate(values, sampleWeights, start, length, this.quantile);
    }

    public double evaluate(double[] values, int begin, int length, double p) {
        MathArrays.verifyValues((double[])values, (int)begin, (int)length);
        if (p > 100.0 || p <= 0.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUNDS_QUANTILE_VALUE, (Number)p, (Number)0, (Number)100);
        }
        if (length == 0) {
            return Double.NaN;
        }
        if (length == 1) {
            return values[begin];
        }
        double[] work = this.getWorkArray(values, begin, length);
        int[] pivotsHeap = this.getPivots(values);
        return work.length == 0 ? Double.NaN : this.estimationType.evaluate(work, pivotsHeap, p, this.kthSelector);
    }

    public double evaluate(double[] values, double[] sampleWeights, int begin, int length, double p) {
        if (values == null || sampleWeights == null) {
            throw new MathIllegalArgumentException((Localizable)LocalizedFormats.NULL_NOT_ALLOWED, new Object[0]);
        }
        if (values.length != sampleWeights.length) {
            throw new MathIllegalArgumentException((Localizable)LocalizedFormats.LENGTH, new Object[]{values, sampleWeights});
        }
        MathArrays.verifyValues((double[])values, (int)begin, (int)length);
        MathArrays.verifyValues((double[])sampleWeights, (int)begin, (int)length);
        MathArrays.checkPositive((double[])sampleWeights);
        MathArrays.checkNotNaN((double[])sampleWeights);
        if (p > 100.0 || p <= 0.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUNDS_QUANTILE_VALUE, (Number)p, (Number)0, (Number)100);
        }
        if (length == 0) {
            return Double.NaN;
        }
        if (length == 1) {
            return values[begin];
        }
        double[] work = this.getWorkArray(values, begin, length);
        double[] workWeights = this.getWorkArray(values, sampleWeights, begin, length);
        return work.length == 0 ? Double.NaN : this.estimationType.evaluate(work, workWeights, p);
    }

    public double getQuantile() {
        return this.quantile;
    }

    public void setQuantile(double p) {
        if (p <= 0.0 || p > 100.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUNDS_QUANTILE_VALUE, (Number)p, (Number)0, (Number)100);
        }
        this.quantile = p;
    }

    @Override
    public Percentile copy() {
        return new Percentile(this);
    }

    private double[] getWorkArray(double[] values, int begin, int length) {
        double[] work;
        if (values == this.getDataRef()) {
            work = this.getDataRef();
        } else {
            switch (this.nanStrategy) {
                case MAXIMAL: {
                    work = Percentile.replaceAndSlice(values, begin, length, Double.NaN, Double.POSITIVE_INFINITY);
                    break;
                }
                case MINIMAL: {
                    work = Percentile.replaceAndSlice(values, begin, length, Double.NaN, Double.NEGATIVE_INFINITY);
                    break;
                }
                case REMOVED: {
                    work = Percentile.removeAndSlice(values, begin, length, Double.NaN);
                    break;
                }
                case FAILED: {
                    work = Percentile.copyOf(values, begin, length);
                    MathArrays.checkNotNaN((double[])work);
                    break;
                }
                default: {
                    work = Percentile.copyOf(values, begin, length);
                }
            }
        }
        return work;
    }

    protected double[] getWorkArray(double[] values, double[] sampleWeights, int begin, int length) {
        double[] work;
        if (values == this.getDataRef()) {
            work = this.weights;
        } else {
            switch (this.nanStrategy) {
                case REMOVED: {
                    work = Percentile.removeAndSliceByRef(values, sampleWeights, begin, length, Double.NaN);
                    break;
                }
                default: {
                    work = Percentile.copyOf(sampleWeights, begin, length);
                }
            }
        }
        return work;
    }

    private static double[] copyOf(double[] values, int begin, int length) {
        MathArrays.verifyValues((double[])values, (int)begin, (int)length);
        return Arrays.copyOfRange(values, begin, begin + length);
    }

    private static double[] replaceAndSlice(double[] values, int begin, int length, double original, double replacement) {
        double[] temp = Percentile.copyOf(values, begin, length);
        for (int i = 0; i < length; ++i) {
            temp[i] = Precision.equalsIncludingNaN((double)original, (double)temp[i]) ? replacement : temp[i];
        }
        return temp;
    }

    private static double[] removeAndSlice(double[] values, int begin, int length, double removedValue) {
        double[] temp;
        MathArrays.verifyValues((double[])values, (int)begin, (int)length);
        BitSet bits = new BitSet(length);
        for (int i = begin; i < begin + length; ++i) {
            if (!Precision.equalsIncludingNaN((double)removedValue, (double)values[i])) continue;
            bits.set(i - begin);
        }
        if (bits.isEmpty()) {
            temp = Percentile.copyOf(values, begin, length);
        } else if (bits.cardinality() == length) {
            temp = new double[]{};
        } else {
            temp = new double[length - bits.cardinality()];
            int start = begin;
            int dest = 0;
            int nextOne = -1;
            int bitSetPtr = 0;
            while ((nextOne = bits.nextSetBit(bitSetPtr)) != -1) {
                int lengthToCopy = nextOne - bitSetPtr;
                System.arraycopy(values, start, temp, dest, lengthToCopy);
                dest += lengthToCopy;
                bitSetPtr = bits.nextClearBit(nextOne);
                start = begin + bitSetPtr;
            }
            if (start < begin + length) {
                System.arraycopy(values, start, temp, dest, begin + length - start);
            }
        }
        return temp;
    }

    private static double[] removeAndSliceByRef(double[] values, double[] sampleWeights, int begin, int length, double removedValue) {
        double[] temp;
        MathArrays.verifyValues((double[])values, (int)begin, (int)length);
        BitSet bits = new BitSet(length);
        for (int i = begin; i < begin + length; ++i) {
            if (!Precision.equalsIncludingNaN((double)removedValue, (double)values[i])) continue;
            bits.set(i - begin);
        }
        if (bits.isEmpty()) {
            temp = Percentile.copyOf(sampleWeights, begin, length);
        } else if (bits.cardinality() == length) {
            temp = new double[]{};
        } else {
            temp = new double[length - bits.cardinality()];
            int start = begin;
            int dest = 0;
            int nextOne = -1;
            int bitSetPtr = 0;
            while ((nextOne = bits.nextSetBit(bitSetPtr)) != -1) {
                int lengthToCopy = nextOne - bitSetPtr;
                System.arraycopy(sampleWeights, start, temp, dest, lengthToCopy);
                dest += lengthToCopy;
                bitSetPtr = bits.nextClearBit(nextOne);
                start = begin + bitSetPtr;
            }
            if (start < begin + length) {
                System.arraycopy(sampleWeights, start, temp, dest, begin + length - start);
            }
        }
        return temp;
    }

    private int[] getPivots(double[] values) {
        int[] pivotsHeap;
        if (values == this.getDataRef()) {
            pivotsHeap = this.cachedPivots;
        } else {
            pivotsHeap = new int[512];
            Arrays.fill(pivotsHeap, -1);
        }
        return pivotsHeap;
    }

    public EstimationType getEstimationType() {
        return this.estimationType;
    }

    public Percentile withEstimationType(EstimationType newEstimationType) {
        return new Percentile(this.quantile, newEstimationType, this.nanStrategy, this.kthSelector);
    }

    public NaNStrategy getNaNStrategy() {
        return this.nanStrategy;
    }

    public Percentile withNaNStrategy(NaNStrategy newNaNStrategy) {
        return new Percentile(this.quantile, this.estimationType, newNaNStrategy, this.kthSelector);
    }

    public KthSelector getKthSelector() {
        return this.kthSelector;
    }

    public PivotingStrategy getPivotingStrategy() {
        return this.kthSelector.getPivotingStrategy();
    }

    public Percentile withKthSelector(KthSelector newKthSelector) {
        return new Percentile(this.quantile, this.estimationType, this.nanStrategy, newKthSelector);
    }

    public static enum EstimationType {
        LEGACY("Legacy Apache Commons Math"){

            @Override
            protected double index(double p, int length) {
                double minLimit = 0.0;
                double maxLimit = 1.0;
                return Double.compare(p, 0.0) == 0 ? 0.0 : (Double.compare(p, 1.0) == 0 ? (double)length : p * (double)(length + 1));
            }

            @Override
            public double evaluate(double[] work, double[] sampleWeights, double p) {
                throw new MathIllegalArgumentException((Localizable)LocalizedFormats.UNSUPPORTED_OPERATION, new Object[0]);
            }
        }
        ,
        R_1("R-1"){

            @Override
            protected double index(double p, int length) {
                double minLimit = 0.0;
                return Double.compare(p, 0.0) == 0 ? 0.0 : (double)length * p + 0.5;
            }

            @Override
            protected double estimate(double[] values, int[] pivotsHeap, double pos, int length, KthSelector selector) {
                return super.estimate(values, pivotsHeap, JdkMath.ceil((double)(pos - 0.5)), length, selector);
            }

            @Override
            public double evaluate(double[] work, double[] sampleWeights, double p) {
                throw new MathIllegalArgumentException((Localizable)LocalizedFormats.UNSUPPORTED_OPERATION, new Object[0]);
            }
        }
        ,
        R_2("R-2"){

            @Override
            protected double index(double p, int length) {
                double minLimit = 0.0;
                double maxLimit = 1.0;
                return Double.compare(p, 1.0) == 0 ? (double)length : (Double.compare(p, 0.0) == 0 ? 0.0 : (double)length * p + 0.5);
            }

            @Override
            protected double estimate(double[] values, int[] pivotsHeap, double pos, int length, KthSelector selector) {
                double low = super.estimate(values, pivotsHeap, JdkMath.ceil((double)(pos - 0.5)), length, selector);
                double high = super.estimate(values, pivotsHeap, JdkMath.floor((double)(pos + 0.5)), length, selector);
                return (low + high) / 2.0;
            }

            @Override
            public double evaluate(double[] work, double[] sampleWeights, double p) {
                throw new MathIllegalArgumentException((Localizable)LocalizedFormats.UNSUPPORTED_OPERATION, new Object[0]);
            }
        }
        ,
        R_3("R-3"){

            @Override
            protected double index(double p, int length) {
                double minLimit = 0.5 / (double)length;
                return Double.compare(p, minLimit) <= 0 ? 0.0 : JdkMath.rint((double)((double)length * p));
            }

            @Override
            public double evaluate(double[] work, double[] sampleWeights, double p) {
                throw new MathIllegalArgumentException((Localizable)LocalizedFormats.UNSUPPORTED_OPERATION, new Object[0]);
            }
        }
        ,
        R_4("R-4"){

            @Override
            protected double index(double p, int length) {
                double minLimit = 1.0 / (double)length;
                double maxLimit = 1.0;
                return Double.compare(p, minLimit) < 0 ? 0.0 : (Double.compare(p, 1.0) == 0 ? (double)length : (double)length * p);
            }

            @Override
            public double evaluate(double[] work, double[] sampleWeights, double p) {
                throw new MathIllegalArgumentException((Localizable)LocalizedFormats.UNSUPPORTED_OPERATION, new Object[0]);
            }
        }
        ,
        R_5("R-5"){

            @Override
            protected double index(double p, int length) {
                double minLimit = 0.5 / (double)length;
                double maxLimit = ((double)length - 0.5) / (double)length;
                return Double.compare(p, minLimit) < 0 ? 0.0 : (Double.compare(p, maxLimit) >= 0 ? (double)length : (double)length * p + 0.5);
            }

            @Override
            public double evaluate(double[] work, double[] sampleWeights, double p) {
                throw new MathIllegalArgumentException((Localizable)LocalizedFormats.UNSUPPORTED_OPERATION, new Object[0]);
            }
        }
        ,
        R_6("R-6"){

            @Override
            protected double index(double p, int length) {
                double minLimit = 1.0 / (double)(length + 1);
                double maxLimit = 1.0 * (double)length / (double)(length + 1);
                return Double.compare(p, minLimit) < 0 ? 0.0 : (Double.compare(p, maxLimit) >= 0 ? (double)length : (double)(length + 1) * p);
            }

            @Override
            public double evaluate(double[] work, double[] sampleWeights, double p) {
                throw new MathIllegalArgumentException((Localizable)LocalizedFormats.UNSUPPORTED_OPERATION, new Object[0]);
            }
        }
        ,
        R_7("R-7"){

            @Override
            protected double index(double p, int length) {
                double minLimit = 0.0;
                double maxLimit = 1.0;
                return Double.compare(p, 0.0) == 0 ? 0.0 : (Double.compare(p, 1.0) == 0 ? (double)length : 1.0 + (double)(length - 1) * p);
            }

            @Override
            public double evaluate(double[] work, double[] sampleWeights, double p) {
                SortInPlace.ASCENDING.apply(work, (double[][])new double[][]{sampleWeights});
                double[] sk = new double[work.length];
                for (int k = 0; k < work.length; ++k) {
                    sk[k] = 0.0;
                    for (int j = 0; j < k; ++j) {
                        int n = k;
                        sk[n] = sk[n] + sampleWeights[j];
                    }
                    sk[k] = (double)k * sampleWeights[k] + (double)(work.length - 1) * sk[k];
                }
                double qsn = p / 100.0 * sk[sk.length - 1];
                int k = EstimationType.searchSk(qsn, sk, 0, work.length - 1);
                double ret = qsn == sk[k] && k == work.length - 1 ? work[k] - (work[k] - work[k - 1]) * (1.0 - (qsn - sk[k]) / (sk[k] - sk[k - 1])) : work[k] + (work[k + 1] - work[k]) * (qsn - sk[k]) / (sk[k + 1] - sk[k]);
                return ret;
            }
        }
        ,
        R_8("R-8"){

            @Override
            protected double index(double p, int length) {
                double minLimit = 0.6666666666666666 / ((double)length + 0.3333333333333333);
                double maxLimit = ((double)length - 0.3333333333333333) / ((double)length + 0.3333333333333333);
                return Double.compare(p, minLimit) < 0 ? 0.0 : (Double.compare(p, maxLimit) >= 0 ? (double)length : ((double)length + 0.3333333333333333) * p + 0.3333333333333333);
            }

            @Override
            public double evaluate(double[] work, double[] sampleWeights, double p) {
                throw new MathIllegalArgumentException((Localizable)LocalizedFormats.UNSUPPORTED_OPERATION, new Object[0]);
            }
        }
        ,
        R_9("R-9"){

            @Override
            protected double index(double p, int length) {
                double minLimit = 0.625 / ((double)length + 0.25);
                double maxLimit = ((double)length - 0.375) / ((double)length + 0.25);
                return Double.compare(p, minLimit) < 0 ? 0.0 : (Double.compare(p, maxLimit) >= 0 ? (double)length : ((double)length + 0.25) * p + 0.375);
            }

            @Override
            public double evaluate(double[] work, double[] sampleWeights, double p) {
                throw new MathIllegalArgumentException((Localizable)LocalizedFormats.UNSUPPORTED_OPERATION, new Object[0]);
            }
        };

        private final String name;

        private EstimationType(String type) {
            this.name = type;
        }

        protected abstract double index(double var1, int var3);

        protected double estimate(double[] work, int[] pivotsHeap, double pos, int length, KthSelector selector) {
            double fpos = JdkMath.floor((double)pos);
            int intPos = (int)fpos;
            double dif = pos - fpos;
            if (pos < 1.0) {
                return selector.select(work, pivotsHeap, 0);
            }
            if (pos >= (double)length) {
                return selector.select(work, pivotsHeap, length - 1);
            }
            double lower = selector.select(work, pivotsHeap, intPos - 1);
            double upper = selector.select(work, pivotsHeap, intPos);
            return lower + dif * (upper - lower);
        }

        protected double evaluate(double[] work, int[] pivotsHeap, double p, KthSelector selector) {
            NullArgumentException.check((Object)work);
            if (p > 100.0 || p <= 0.0) {
                throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUNDS_QUANTILE_VALUE, (Number)p, (Number)0, (Number)100);
            }
            return this.estimate(work, pivotsHeap, this.index(p / 100.0, work.length), work.length, selector);
        }

        public double evaluate(double[] work, double p, KthSelector selector) {
            return this.evaluate(work, null, p, selector);
        }

        public abstract double evaluate(double[] var1, double[] var2, double var3);

        private static int searchSk(double qsn, double[] sk, int lo, int hi) {
            if (sk.length == 1) {
                return 0;
            }
            if (hi - lo == 1) {
                if (qsn == sk[hi]) {
                    return hi;
                }
                return lo;
            }
            int mid = lo + hi >>> 1;
            if (qsn == sk[mid]) {
                return mid;
            }
            if (qsn > sk[mid]) {
                return EstimationType.searchSk(qsn, sk, mid, hi);
            }
            return EstimationType.searchSk(qsn, sk, lo, mid);
        }

        String getName() {
            return this.name;
        }
    }
}

