/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.rng.examples.stress;

/**
 * The mode to output a 64-bit source of randomness.
 */
enum Source64Mode {
    /** The 64-bit output from nextLong. */
    LONG,
    /** The 32-bit output from nextInt. */
    INT,
    /** The high 32-bits, then low 32-bits of the 64-bit output. */
    HI_LO,
    /** The low 32-bits, then high 32-bits of the 64-bit output. */
    LO_HI,
    /** The low 32-bits of the 64-bit output. */
    LO,
    /** The high 32-bits of the 64-bit output. */
    HI;
}
