/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.model;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.SCXMLHelper;
import org.apache.commons.scxml.model.Action;

public class CustomAction {
    private static final String ERR_NO_NAMESPACE = "Cannot define a custom SCXML action with a null or empty namespace";
    private static final String NAMESPACE_SCXML = "http://www.w3.org/2005/07/scxml";
    private static final String ERR_RESERVED_NAMESPACE = "Cannot define a custom SCXML action within the SCXML namespace 'http://www.w3.org/2005/07/scxml'";
    private static final String ERR_NO_LOCAL_NAME = "Cannot define a custom SCXML action with a null or empty local name";
    private static final String ERR_NOT_AN_ACTION = "Custom SCXML action does not extend Action superclass";
    private String namespaceURI;
    private String localName;
    private Class actionClass;
    private Log log = LogFactory.getLog((Class)CustomAction.class);

    public CustomAction(String namespaceURI, String localName, Class actionClass) {
        if (SCXMLHelper.isStringEmpty(namespaceURI)) {
            this.log.error((Object)ERR_NO_NAMESPACE);
            throw new IllegalArgumentException(ERR_NO_NAMESPACE);
        }
        if (namespaceURI.trim().equalsIgnoreCase(NAMESPACE_SCXML)) {
            this.log.error((Object)ERR_RESERVED_NAMESPACE);
            throw new IllegalArgumentException(ERR_RESERVED_NAMESPACE);
        }
        if (SCXMLHelper.isStringEmpty(localName)) {
            this.log.error((Object)ERR_NO_LOCAL_NAME);
            throw new IllegalArgumentException(ERR_NO_LOCAL_NAME);
        }
        if (actionClass == null || !Action.class.isAssignableFrom(actionClass)) {
            this.log.error((Object)ERR_NOT_AN_ACTION);
            throw new IllegalArgumentException(ERR_NOT_AN_ACTION);
        }
        this.namespaceURI = namespaceURI;
        this.localName = localName;
        this.actionClass = actionClass;
    }

    public Class getActionClass() {
        return this.actionClass;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }
}

