/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.Configuration;
import net.sf.saxon.lib.FunctionAnnotationHandler;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.query.Annotation;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.TypeHierarchy;

public class AnyFunctionTypeWithAssertions
extends AnyFunctionType {
    private final AnnotationList assertions;
    private final Configuration config;

    public AnyFunctionTypeWithAssertions(AnnotationList assertions, Configuration config) {
        this.assertions = assertions;
        this.config = config;
    }

    @Override
    public AnnotationList getAnnotationAssertions() {
        return this.assertions;
    }

    @Override
    public boolean matches(Item item, TypeHierarchy th) {
        return item instanceof FunctionItem && AnyFunctionTypeWithAssertions.checkAnnotationAssertions(this.assertions, (FunctionItem)item, th.getConfiguration());
    }

    private static boolean checkAnnotationAssertions(AnnotationList assertions, FunctionItem item, Configuration config) {
        AnnotationList annotations = item.getAnnotations();
        for (Annotation ann : assertions) {
            boolean ok;
            FunctionAnnotationHandler handler = config.getFunctionAnnotationHandler(ann.getAnnotationQName().getNamespaceUri());
            if (handler == null || (ok = handler.satisfiesAssertion(ann, annotations))) continue;
            return false;
        }
        return true;
    }
}

