/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.filters.bloomfilter;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.MemorySegmentStatus;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.common.positional.PositionalSegment;
import org.apache.datasketches.filters.bloomfilter.DirectBitArray;
import org.apache.datasketches.filters.bloomfilter.DirectBitArrayR;
import org.apache.datasketches.filters.bloomfilter.HeapBitArray;

abstract class BitArray
implements MemorySegmentStatus {
    protected static final long MAX_BITS = 137438953408L;

    protected BitArray() {
    }

    static BitArray heapify(PositionalSegment posSeg, boolean isEmpty) {
        return HeapBitArray.heapify(posSeg, isEmpty);
    }

    static BitArray wrap(MemorySegment seg, boolean isEmpty) {
        return DirectBitArrayR.wrap(seg, isEmpty);
    }

    static BitArray writableWrap(MemorySegment wseg, boolean isEmpty) {
        return DirectBitArray.writableWrap(wseg, isEmpty);
    }

    boolean isEmpty() {
        return !this.isDirty() && this.getNumBitsSet() == 0L;
    }

    @Override
    public abstract boolean hasMemorySegment();

    @Override
    public abstract boolean isOffHeap();

    abstract boolean isReadOnly();

    @Override
    public abstract boolean isSameResource(MemorySegment var1);

    abstract boolean getBit(long var1);

    abstract boolean getAndSetBit(long var1);

    abstract void setBit(long var1);

    abstract long getNumBitsSet();

    abstract void reset();

    abstract long getCapacity();

    abstract int getArrayLength();

    abstract void union(BitArray var1);

    abstract void intersect(BitArray var1);

    abstract void invert();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.getArrayLength(); ++i) {
            sb.append(i + ": ").append(BitArray.printLong(this.getLong(i))).append(Util.LS);
        }
        return sb.toString();
    }

    long getSerializedSizeBytes() {
        return 8L * (this.isEmpty() ? 1L : 2L + (long)this.getArrayLength());
    }

    static long getSerializedSizeBytes(long numBits) {
        if (numBits <= 0L) {
            throw new SketchesArgumentException("Requested number of bits must be strictly positive");
        }
        if (numBits > 137438953408L) {
            throw new SketchesArgumentException("Requested number of bits exceeds maximum allowed. Requested: " + numBits + ", maximum: 137438953408");
        }
        int numLongs = (int)Util.ceilingMultiple2expK(numBits, 6);
        return 8L * ((long)numLongs + 2L);
    }

    protected abstract boolean isDirty();

    protected abstract long getLong(int var1);

    protected abstract void setLong(int var1, long var2);

    protected static String printLong(long val) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < 64; ++j) {
            sb.append((val & 1L << j) != 0L ? "1" : "0");
            if (j % 8 != 7) continue;
            sb.append(" ");
        }
        return sb.toString();
    }
}

